/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.config;

import fathertoast.specialai.config.Config;
import fathertoast.specialai.config.EntryEntity;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class EntityListConfig {
    private final EntryEntity[] ENTRIES;

    public EntityListConfig(String line) {
        this(line.split(","));
    }

    public EntityListConfig(String[] list) {
        ArrayList<EntryEntity> entryList = new ArrayList<EntryEntity>();
        for (String item : list) {
            String[] itemList;
            Class entityClass;
            boolean extendable = true;
            if (item.startsWith("~")) {
                item = item.substring(1);
                extendable = false;
            }
            if ((entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation((itemList = item.split(" "))[0].trim()))) != null) {
                entryList.add(new EntryEntity((Class<? extends Entity>)entityClass, extendable, itemList));
                continue;
            }
            Config.log.error("Invalid entity id! ({})", (Object)item);
        }
        this.ENTRIES = entryList.toArray(new EntryEntity[0]);
    }

    public boolean contains(Entity entity) {
        EntryEntity entry = new EntryEntity(entity.getClass());
        for (EntryEntity currentEntry : this.ENTRIES) {
            if (!currentEntry.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public float[] getChances(Entity entity) {
        EntryEntity entry = new EntryEntity(entity.getClass());
        EntryEntity bestMatch = null;
        float[] matchChances = null;
        for (EntryEntity currentEntry : this.ENTRIES) {
            if (!currentEntry.contains(entry) || bestMatch != null && !bestMatch.contains(currentEntry)) continue;
            bestMatch = currentEntry;
            matchChances = currentEntry.VALUES;
        }
        return matchChances;
    }

    public boolean rollChance(EntityLivingBase entity) {
        float[] chances = this.getChances((Entity)entity);
        return chances != null && (chances.length <= 0 || entity.func_70681_au().nextFloat() < chances[0]);
    }
}

