/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.ai;

import fathertoast.specialai.SpecialAIMod;
import fathertoast.specialai.ai.EntityAIAttackMeleePassive;
import fathertoast.specialai.ai.EntityAIRider;
import fathertoast.specialai.ai.elite.EliteAIHandler;
import fathertoast.specialai.ai.grief.EntityAIBreakDoorSpecial;
import fathertoast.specialai.ai.grief.EntityAIEatBreedingItem;
import fathertoast.specialai.ai.grief.EntityAIGriefBlocks;
import fathertoast.specialai.ai.react.EntityAIAvoidExplosions;
import fathertoast.specialai.ai.react.EntityAIDodgeArrows;
import fathertoast.specialai.config.Config;
import fathertoast.specialai.config.EntityListConfig;
import fathertoast.specialai.village.EntityAIVillagerDefendVillage;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AIHandler {
    public static final int NBT_TYPE_PRIMITIVE = 99;
    private static final String AVOID_EXPLOSIONS_TAG = "AvoidExplosions";
    private static final String DODGE_ARROWS_TAG = "DodgeArrows";
    private static final String DODGE_ARROW_INIT_TAG = "SAIArrowDodgeCheck";
    private static final String DEFEND_VILLAGE_TAG = "DefendVillage";
    private static final String DEPACIFY_TAG = "Depacify";
    public static final String DOOR_BREAK_TAG = "DoorBreaking";
    public static final String DOOR_BREAK_SPEED = "DoorBreakSpeed";
    public static final String DOOR_BREAK_TARGET_TAG = "DoorNeedsTarget";
    public static final String DOOR_BREAK_TOOL_TAG = "DoorNeedsTool";
    public static final String DOOR_BREAK_BLOCK_TAG = "DoorBlocks";
    public static final String IDLE_RANGE_XZ_TAG = "IdleScanRangeXZ";
    public static final String IDLE_RANGE_Y_TAG = "IdleScanRangeY";
    public static final String GRIEF_TAG = "Griefing";
    public static final String GRIEF_BREAK_SPEED = "GriefBreakSpeed";
    public static final String GRIEF_TOOL_TAG = "GriefNeedsTool";
    public static final String GRIEF_LIGHT_TAG = "GriefLights";
    public static final String GRIEF_BLOCK_TAG = "GriefBlocks";
    public static final String GRIEF_LOOTABLE_TAG = "GriefLootable";
    public static final String GRIEF_EXCEPTION_TAG = "GriefBlacklist";
    public static final String FIDDLE_TAG = "Fiddling";
    public static final String FIDDLE_BLOCK_TAG = "FiddleBlocks";
    public static final String FIDDLE_EXCEPTION_TAG = "FiddleBlacklist";
    private static final String RIDER_TAG = "Rider";
    private static final String ELITE_AI_TAG = "EliteAI";
    private static final String FORCE_INIT_TAG = "ForceInit";
    public static final byte BIT_NONE = 0;
    public static final byte BIT_MOVEMENT = 1;
    public static final byte BIT_FACING = 2;
    public static final byte BIT_SWIMMING = 4;
    public static final byte TARGET_BIT = 1;
    private static int scansLeft = Config.get().IDLE_AI.SCAN_COUNT_GLOBAL;

    public static boolean canScan() {
        return Config.get().IDLE_AI.SCAN_COUNT_GLOBAL <= 0 || scansLeft-- > 0;
    }

    private static void clearAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            entity.field_70714_bg.func_85156_a(entry.field_75733_a);
        }
    }

    private static void clearTargetAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            entity.field_70715_bh.func_85156_a(entry.field_75733_a);
        }
    }

    private static void addAvoidExplosionsAI(EntityCreature entity) {
        entity.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAIAvoidExplosions(entity));
    }

    private static void addDodgeArrowsAI(EntityCreature entity, float dodgeChance) {
        entity.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAIDodgeArrows(entity, dodgeChance));
    }

    private static void addDefendVillageAI(EntityCreature entity, boolean addedAttackAI) {
        if (!addedAttackAI) {
            entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMeleePassive(entity, 0.7, false));
        }
        entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIVillagerDefendVillage(entity));
    }

    private static void addHurtByTargetAI(EntityCreature entity, byte depacify, boolean addedAttackAI) {
        if (!addedAttackAI) {
            entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackMeleePassive(entity, entity instanceof EntityChicken ? 1.8 : 1.4, false));
        }
        entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget(entity, Config.get().REACT_AI.CALL_HELP, new Class[0]));
        if (depacify > 1) {
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget(entity, EntityPlayer.class, true));
        }
    }

    private static void setHelpAI(EntityCreature entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (entry.field_75733_a.getClass() != EntityAIHurtByTarget.class) continue;
            int priority = entry.field_75731_b;
            entity.field_70715_bh.func_85156_a(entry.field_75733_a);
            entity.field_70715_bh.func_75776_a(priority, (EntityAIBase)new EntityAIHurtByTarget(entity, true, new Class[0]));
            return;
        }
    }

    private static void addRiderAI(EntityLiving entity, boolean small) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority(entity), (EntityAIBase)new EntityAIRider(entity, small));
    }

    private static void addEatingAI(EntityAnimal entity) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority((EntityLiving)entity), (EntityAIBase)new EntityAIEatBreedingItem(entity));
    }

    private static void addGriefAI(EntityLiving entity, boolean griefing, boolean fiddling, NBTTagCompound tag) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority(entity), (EntityAIBase)new EntityAIGriefBlocks(entity, griefing, fiddling, tag));
    }

    private static int getPassivePriority(EntityLiving entity) {
        int highest = Integer.MIN_VALUE;
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (entry.field_75733_a instanceof EntityAIWander || entry.field_75733_a instanceof EntityAIWatchClosest || entry.field_75733_a instanceof EntityAILookIdle) {
                return entry.field_75731_b;
            }
            if (highest >= entry.field_75731_b) continue;
            highest = entry.field_75731_b;
        }
        return highest + 1;
    }

    private static void addDigAI(EntityLiving entity) {
    }

    private static void addDoorBreakAI(EntityLiving entity, NBTTagCompound tag) {
        if (entity.func_70661_as() instanceof PathNavigateGround) {
            for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
                if (!(entry.field_75733_a instanceof EntityAIBreakDoor)) continue;
                entity.field_70714_bg.func_85156_a(entry.field_75733_a);
            }
            ((PathNavigateGround)entity.func_70661_as()).func_179688_b(true);
            entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakDoorSpecial(entity, tag));
        } else {
            SpecialAIMod.log().warn("Attempted to add door-breaking ai to entity '{}' with incompatible navigator '{}'", (Object)EntityList.func_191301_a((Entity)entity), (Object)entity.func_70661_as().getClass().getSimpleName());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            scansLeft = Config.get().IDLE_AI.SCAN_COUNT_GLOBAL;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && event.phase == TickEvent.Phase.END) {
            for (int i = 0; i < event.world.field_72996_f.size(); ++i) {
                Entity entity = (Entity)event.world.field_72996_f.get(i);
                if (!(entity instanceof EntityItem)) continue;
                this.equipToThief((EntityItem)entity);
            }
        }
    }

    private void equipToThief(EntityItem item) {
        String TAG = "ThiefUUID";
        if (item.getEntityData().func_186855_b("ThiefUUID")) {
            UUID thiefId = item.getEntityData().func_186857_a("ThiefUUID");
            for (int i = 0; i < item.field_70170_p.field_72996_f.size(); ++i) {
                Entity entity = (Entity)item.field_70170_p.field_72996_f.get(i);
                if (!(entity instanceof EntityLiving) || !thiefId.equals(entity.func_110124_au())) continue;
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, item.func_92059_d());
                ((EntityLiving)entity).func_184642_a(EntityEquipmentSlot.MAINHAND, 2.0f);
                ((EntityLiving)entity).func_110163_bv();
                item.func_70106_y();
                return;
            }
            item.getEntityData().func_82580_o("ThiefUUIDMost");
            item.getEntityData().func_82580_o("ThiefUUIDLeast");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        NBTTagCompound aiTag;
        boolean fiddling;
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntityArrow && !event.getEntity().getEntityData().func_74767_n(DODGE_ARROW_INIT_TAG)) {
            event.getEntity().getEntityData().func_74757_a(DODGE_ARROW_INIT_TAG, true);
            EntityAIDodgeArrows.doDodgeCheckForArrow(event.getEntity());
        }
        if (!(event.getEntity() instanceof EntityLiving)) {
            return;
        }
        EntityLiving theEntity = (EntityLiving)event.getEntity();
        NBTTagCompound tag = SpecialAIMod.getTag((Entity)theEntity);
        if (theEntity instanceof EntityCreature) {
            boolean addedAttackAI = false;
            if (!tag.func_150297_b(AVOID_EXPLOSIONS_TAG, 99)) {
                tag.func_74757_a(AVOID_EXPLOSIONS_TAG, Config.get().REACT_AI.AVOID_EXPLOSIONS);
            }
            if (tag.func_74767_n(AVOID_EXPLOSIONS_TAG)) {
                AIHandler.addAvoidExplosionsAI((EntityCreature)theEntity);
            }
            if (!tag.func_150297_b(DODGE_ARROWS_TAG, 99)) {
                tag.func_74776_a(DODGE_ARROWS_TAG, (float)Config.get().REACT_AI.DODGE_ARROWS);
            }
            if (tag.func_74760_g(DODGE_ARROWS_TAG) > 0.0f) {
                AIHandler.addDodgeArrowsAI((EntityCreature)theEntity, tag.func_74760_g(DODGE_ARROWS_TAG));
            }
            if (!tag.func_150297_b(DEFEND_VILLAGE_TAG, 99)) {
                tag.func_74757_a(DEFEND_VILLAGE_TAG, Config.get().VILLAGES.VILLAGERS_DEFEND && theEntity instanceof EntityVillager);
            }
            if (tag.func_74767_n(DEFEND_VILLAGE_TAG)) {
                AIHandler.addDefendVillageAI((EntityCreature)theEntity, addedAttackAI);
                addedAttackAI = true;
            }
            int depacify = tag.func_150297_b(DEPACIFY_TAG, 99) ? tag.func_74771_c(DEPACIFY_TAG) : (Config.get().GENERAL.DEPACIFY_LIST.rollChance((EntityLivingBase)theEntity) ? (theEntity.func_70681_au().nextDouble() < Config.get().GENERAL.AGGRESSIVE_CHANCE ? 2 : 1) : 0);
            if (depacify > 0) {
                AIHandler.addHurtByTargetAI((EntityCreature)theEntity, (byte)depacify, addedAttackAI);
                addedAttackAI = true;
            } else if (Config.get().REACT_AI.CALL_HELP) {
                AIHandler.setHelpAI((EntityCreature)theEntity);
            }
        }
        boolean small = Config.get().JOCKEYS.RIDER_LIST_SMALL.contains((Entity)theEntity);
        if (!tag.func_150297_b(RIDER_TAG, 99)) {
            EntityListConfig list = small ? Config.get().JOCKEYS.RIDER_LIST_SMALL : Config.get().JOCKEYS.RIDER_LIST;
            tag.func_74757_a(RIDER_TAG, list.rollChance((EntityLivingBase)theEntity));
        }
        if (tag.func_74767_n(RIDER_TAG)) {
            AIHandler.addRiderAI(theEntity, small);
        }
        if (Config.get().GENERAL.EAT_BREEDING_ITEMS && theEntity instanceof EntityAnimal) {
            AIHandler.addEatingAI((EntityAnimal)theEntity);
        }
        if (!tag.func_150297_b(GRIEF_TAG, 99)) {
            tag.func_74757_a(GRIEF_TAG, Config.get().GRIEFING.MOB_LIST.rollChance((EntityLivingBase)theEntity));
        }
        if (!tag.func_150297_b(FIDDLE_TAG, 99)) {
            tag.func_74757_a(FIDDLE_TAG, Config.get().FIDDLING.MOB_LIST.rollChance((EntityLivingBase)theEntity));
        }
        boolean griefing = Config.get().GRIEFING.ENABLED && tag.func_74767_n(GRIEF_TAG);
        boolean bl = fiddling = Config.get().FIDDLING.ENABLED && tag.func_74767_n(FIDDLE_TAG);
        if (griefing || fiddling) {
            AIHandler.addGriefAI(theEntity, griefing, fiddling, tag);
        }
        if (!tag.func_150297_b(DOOR_BREAK_TAG, 99)) {
            tag.func_74757_a(DOOR_BREAK_TAG, Config.get().DOOR_BREAKING.MOB_LIST.rollChance((EntityLivingBase)theEntity));
        }
        if (Config.get().DOOR_BREAKING.ENABLED && tag.func_74767_n(DOOR_BREAK_TAG)) {
            AIHandler.addDoorBreakAI(theEntity, tag);
        }
        if (!tag.func_150297_b(ELITE_AI_TAG, (int)tag.func_74732_a())) {
            aiTag = new NBTTagCompound();
            tag.func_74782_a(ELITE_AI_TAG, (NBTBase)aiTag);
            float[] chances = Config.get().ELITE_AI.MOB_LIST.getChances((Entity)theEntity);
            if (chances != null) {
                for (float chance : chances) {
                    if (!(chance > 0.0f) || !(theEntity.func_70681_au().nextFloat() < chance)) continue;
                    EliteAIHandler.saveSpecialAI(theEntity, aiTag);
                }
            }
            if (!tag.func_150297_b(FORCE_INIT_TAG, 99)) {
                tag.func_74757_a(FORCE_INIT_TAG, true);
            }
        } else {
            aiTag = tag.func_74775_l(ELITE_AI_TAG);
        }
        EliteAIHandler.addSpecialAI(theEntity, aiTag, tag.func_74767_n(FORCE_INIT_TAG));
        tag.func_82580_o(FORCE_INIT_TAG);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        if (Config.get().REACT_AI.CALL_HELP_ON_DEATH > 0.0 && event.getEntityLiving() instanceof EntityLiving && event.getEntityLiving().func_70681_au().nextDouble() < Config.get().REACT_AI.CALL_HELP_ON_DEATH) {
            EntityLiving theEntity = (EntityLiving)event.getEntityLiving();
            Entity target = event.getSource().func_76346_g();
            if (target instanceof EntityLivingBase) {
                IAttributeInstance attribute = theEntity.func_110148_a(SharedMonsterAttributes.field_111265_b);
                double range = attribute.func_111126_e();
                List entities = theEntity.field_70170_p.func_72839_b((Entity)theEntity, new AxisAlignedBB(theEntity.field_70165_t, theEntity.field_70163_u, theEntity.field_70161_v, theEntity.field_70165_t + 1.0, theEntity.field_70163_u + 1.0, theEntity.field_70161_v + 1.0).func_72321_a(range, 10.0, range));
                for (Object entity : entities) {
                    EntityLiving alliedEntity;
                    if (!(entity instanceof EntityLiving) || !entity.getClass().isAssignableFrom(theEntity.getClass()) && !theEntity.getClass().isAssignableFrom(entity.getClass()) || (alliedEntity = (EntityLiving)entity).func_70638_az() != null || alliedEntity.func_184191_r(target)) continue;
                    alliedEntity.func_70624_b((EntityLivingBase)target);
                }
            }
        }
    }
}

