/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.google.common.base.Predicate;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NetherMinableGenerator
implements IWorldGenerator {
    public static NetherMinableGenerator INSTANCE = new NetherMinableGenerator();
    WorldGenMinable tainedSoilGen = new WorldGenMinable(NaturaNether.netherTaintedSoil.func_176223_P(), Config.tainedSoilClusterSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    WorldGenMinable heatSandGen = new WorldGenMinable(NaturaNether.netherHeatSand.func_176223_P(), Config.heatSandClusterSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150425_aM));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateNether(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16;
        int yPos = world.func_181545_F() / 2 + 1 - 5;
        int zPos = chunkZ * 16;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (biome == null) {
            return;
        }
        if (this.shouldGenerateInDimension(world.field_73011_w.getDimension()) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            int zSpawn;
            int ySpawn;
            int xSpawn;
            int i;
            if (Config.generateTaintedSoil) {
                for (i = 0; i < Config.tainedSoilClusterCount; ++i) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = yPos + random.nextInt(10);
                    zSpawn = zPos + random.nextInt(16);
                    this.tainedSoilGen.func_180709_b(world, random, new BlockPos(xSpawn, ySpawn, zSpawn));
                }
            }
            if (Config.generateHeatSand) {
                for (i = 0; i < Config.heatSandClusterCount; ++i) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = yPos + random.nextInt(10);
                    zSpawn = zPos + random.nextInt(16);
                    this.heatSandGen.func_180709_b(world, random, new BlockPos(xSpawn, ySpawn, zSpawn));
                }
            }
        }
    }

    public boolean shouldGenerateInDimension(int dimension) {
        for (int dimensionId : Config.netherWorldGenBlacklist) {
            if (dimension != dimensionId) continue;
            return false;
        }
        return true;
    }
}

