/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.armor;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.iface.IRepairMaterial;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.blakebr0.mysticalagriculture.items.armor.ArmorType;
import com.blakebr0.mysticalagriculture.lib.Tooltips;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSupremiumArmor
extends ItemArmor
implements IRepairMaterial {
    private ItemStack repairMaterial;

    public ItemSupremiumArmor(String name, ItemArmor.ArmorMaterial material, int index, EntityEquipmentSlot slot) {
        super(material, index, slot);
        this.func_77655_b("ma." + name);
        this.setRegistryName(name);
        this.func_77637_a(MysticalAgriculture.CREATIVE_TAB);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tag;
        int damage = stack.func_77958_k() - stack.func_77952_i();
        tooltip.add(Tooltips.DURABILITY + "\u00a7c" + damage);
        if (ModConfig.confSupremiumFlight) {
            tooltip.add(Tooltips.SET_BONUS + "\u00a7c" + Tooltips.FLIGHT);
        }
        if ((tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ArmorType")) {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + ArmorType.byIndex(tag.func_74762_e("ArmorType")).getLocalizedName());
        } else {
            tooltip.add(Tooltips.CHARM_SLOT + "\u00a7c" + Tooltips.EMPTY);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ArmorType type;
        NBTTagCompound tag;
        if (ModConfig.confSetBonuses && ItemSupremiumArmor.isFullSet(player) && player.func_70090_H()) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 5, 0, true, false));
        }
        if ((tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ArmorType") && (type = ArmorType.byIndex(tag.func_74762_e("ArmorType"))) != null) {
            type.getSpecialAbility(world, player);
        }
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return OreDictionary.itemMatches((ItemStack)this.getRepairMaterial(), (ItemStack)repair, (boolean)false);
    }

    public void setRepairMaterial(ItemStack stack) {
        this.repairMaterial = stack;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public static boolean isFullSet(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = player.func_184582_a(EntityEquipmentSlot.FEET);
        return !head.func_190926_b() && head.func_77973_b() instanceof ItemSupremiumArmor && !chest.func_190926_b() && chest.func_77973_b() instanceof ItemSupremiumArmor && !legs.func_190926_b() && legs.func_77973_b() instanceof ItemSupremiumArmor && !feet.func_190926_b() && feet.func_77973_b() instanceof ItemSupremiumArmor;
    }

    public static class AbilityHandler {
        public static List<String> playersWithSet = new ArrayList<String>();
        public static List<String> playersWithSpeed = new ArrayList<String>();

        public static String playerKey(EntityPlayer player) {
            return player.func_146103_bH().getName() + ":" + player.func_130014_f_().field_72995_K;
        }

        public boolean hasSpeed(EntityPlayer player) {
            NBTTagCompound tag;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.LEGS);
            return stack.func_77973_b() == ModItems.itemSupremiumLeggings && (tag = NBTHelper.getTagCompound((ItemStack)stack)).func_74764_b("ArmorType") && tag.func_74762_e("ArmorType") == ArmorType.SPEED.getIndex();
        }

        @SubscribeEvent
        public void updatePlayerAbilityStatus(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                String key = AbilityHandler.playerKey(player);
                Boolean hasSet = ItemSupremiumArmor.isFullSet(player);
                if (playersWithSet.contains(key)) {
                    if (hasSet.booleanValue()) {
                        if (ModConfig.confSupremiumFlight) {
                            player.field_71075_bZ.field_75101_c = true;
                        }
                        if (ModConfig.confSetBonuses) {
                            player.field_70138_W = 1.0625f;
                            boolean flying = player.field_71075_bZ.field_75100_b;
                            if (flying) {
                                boolean sneaking = player.func_70093_af();
                                float speed = 0.08f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f);
                                if (player.field_191988_bg > 0.0f) {
                                    player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                                } else if (player.field_191988_bg < 0.0f) {
                                    player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                                }
                                if (player.field_70702_br != 0.0f) {
                                    player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                                }
                            }
                        }
                    } else {
                        player.field_70138_W = 0.6f;
                        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
                            player.field_71075_bZ.field_75101_c = false;
                            player.field_71075_bZ.field_75100_b = false;
                        }
                        playersWithSet.remove(key);
                    }
                } else if (hasSet.booleanValue()) {
                    playersWithSet.add(key);
                }
                boolean hasSpeed = this.hasSpeed(player);
                if (playersWithSpeed.contains(key)) {
                    if (hasSpeed) {
                        boolean swimming;
                        boolean flying = player.field_71075_bZ.field_75100_b;
                        boolean bl = swimming = player.func_70055_a(Material.field_151586_h) || player.func_70090_H();
                        if (player.field_70122_E || flying || swimming) {
                            boolean sneaking = player.func_70093_af();
                            boolean sprinting = player.func_70051_ag();
                            float speed = 0.1f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f) * (!sprinting ? 0.6f : 1.2f);
                            if (player.field_191988_bg > 0.0f) {
                                player.func_191958_b(0.0f, 0.0f, 1.0f, speed);
                            } else if (player.field_191988_bg < 0.0f) {
                                player.func_191958_b(0.0f, 0.0f, 1.0f, -speed * 0.3f);
                            }
                            if (player.field_70702_br != 0.0f) {
                                player.func_191958_b(1.0f, 0.0f, 0.0f, speed * 0.5f * Math.signum(player.field_70702_br));
                            }
                        }
                    } else {
                        playersWithSpeed.remove(key);
                    }
                } else if (hasSpeed) {
                    playersWithSpeed.add(key);
                }
            }
        }
    }
}

