/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import lex.LibEx;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import lex.world.gen.feature.FeatureBigMushroom;
import lex.world.gen.feature.FeatureCluster;
import lex.world.gen.feature.FeatureFluid;
import lex.world.gen.feature.FeatureOakTree;
import lex.world.gen.feature.FeatureOre;
import lex.world.gen.feature.FeaturePool;
import lex.world.gen.feature.FeatureScatter;
import lex.world.gen.feature.FeatureStructure;
import net.minecraft.util.ResourceLocation;

public class FeatureRegistry {
    private static final Map<ResourceLocation, Class<? extends Feature>> FEATURES = new HashMap<ResourceLocation, Class<? extends Feature>>();

    public static void registerFeature(ResourceLocation name, Class<? extends Feature> cls) {
        if (!FEATURES.containsKey(name)) {
            FEATURES.put(name, cls);
        } else {
            LibEx.LOGGER.warn("A feature with the name, {}, is already registered!", (Object)name.toString());
        }
    }

    public static Feature createFeature(ResourceLocation name, Config config) {
        if (FEATURES.containsKey(name)) {
            try {
                return FEATURES.get(name).getConstructor(Config.class).newInstance(config);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        FeatureRegistry.registerFeature(new ResourceLocation("lex:scatter"), FeatureScatter.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:cluster"), FeatureCluster.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:fluid"), FeatureFluid.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:ore"), FeatureOre.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:pool"), FeaturePool.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:big_mushroom"), FeatureBigMushroom.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:oak_tree"), FeatureOakTree.class);
        FeatureRegistry.registerFeature(new ResourceLocation("lex:structure"), FeatureStructure.class);
    }
}

