/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Random;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FeatureCluster
extends Feature {
    private IBlockState blockToSpawn;
    private IBlockState blockToAttachTo;
    private EnumFacing direction;

    public FeatureCluster(Config config) {
        super(config);
        this.blockToSpawn = config.getBlock("blockToSpawn", Blocks.field_180401_cv.func_176223_P());
        this.blockToAttachTo = config.getBlock("blockToAttachTo", Blocks.field_180401_cv.func_176223_P());
        this.direction = config.getEnum("direction", EnumFacing.class, EnumFacing.DOWN);
    }

    public FeatureCluster(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState blockToSpawn, IBlockState blockToAttachTo, EnumFacing direction) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.blockToSpawn = blockToSpawn;
        this.blockToAttachTo = blockToAttachTo;
        this.direction = direction;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.blockToSpawn.func_177230_c() == Blocks.field_180401_cv || this.blockToAttachTo.func_177230_c() == Blocks.field_180401_cv) {
            return false;
        }
        if (!world.func_175623_d(pos)) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(this.direction.func_176734_d())) != this.blockToAttachTo) {
            return false;
        }
        world.func_180501_a(pos, this.blockToSpawn, 3);
        for (int i = 0; i < 1500; ++i) {
            BlockPos newPos;
            switch (this.direction) {
                default: {
                    newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), -rand.nextInt(12), rand.nextInt(8) - rand.nextInt(8));
                    break;
                }
                case UP: {
                    newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(12), rand.nextInt(8) - rand.nextInt(8));
                    break;
                }
                case NORTH: {
                    newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(8) - rand.nextInt(8), -rand.nextInt(12));
                    break;
                }
                case SOUTH: {
                    newPos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(8) - rand.nextInt(8), rand.nextInt(12));
                    break;
                }
                case WEST: {
                    newPos = pos.func_177982_a(-rand.nextInt(12), rand.nextInt(8) - rand.nextInt(8), rand.nextInt(8) - rand.nextInt(8));
                    break;
                }
                case EAST: {
                    newPos = pos.func_177982_a(rand.nextInt(12), rand.nextInt(8) - rand.nextInt(8), rand.nextInt(8) - rand.nextInt(8));
                }
            }
            if (!world.func_175623_d(newPos)) continue;
            int j = 0;
            for (EnumFacing facing : EnumFacing.values()) {
                if (world.func_180495_p(newPos.func_177972_a(facing)).func_177230_c() == this.blockToSpawn.func_177230_c()) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.func_180501_a(newPos, this.blockToSpawn, 3);
        }
        return true;
    }
}

