/*
 * Decompiled with CFR 0.152.
 */
package lex.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lex.config.Config;
import lex.world.gen.GenerationStage;
import lex.world.gen.feature.Feature;
import lex.world.gen.feature.FeatureRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeWrapper {
    protected Biome biome;
    protected int weight;
    protected Map<String, IBlockState> blocks = new HashMap<String, IBlockState>();
    protected Map<GenerationStage, List<Feature>> generationStageFeatures = new HashMap<GenerationStage, List<Feature>>();
    protected Map<EnumCreatureType, List<Biome.SpawnListEntry>> spawnableMobs = new HashMap<EnumCreatureType, List<Biome.SpawnListEntry>>();
    protected boolean enabled;
    protected boolean genDefaultFeatures;
    protected Config config;

    public BiomeWrapper(Config config) {
        this.config = config;
        this.parse();
    }

    protected void parse() {
        this.biome = (Biome)ForgeRegistries.BIOMES.getValue(this.config.getResource("biome"));
        if (this.biome != null) {
            this.weight = this.config.getInt("weight", 10);
            Config blockConfig = this.config.getDataBranch("blocks", new JsonObject());
            blockConfig.getBlock("topBlock", this.biome.field_76752_A);
            blockConfig.getBlock("fillerBlock", this.biome.field_76753_B);
            for (Map.Entry<String, JsonElement> entry : blockConfig.getAllData().entrySet()) {
                if (blockConfig.getBlock(entry.getKey()) == null) continue;
                this.blocks.put(entry.getKey(), blockConfig.getBlock(entry.getKey()));
            }
            List<Config> entityConfigs = this.config.getDataBranches("entities", new ArrayList<JsonObject>());
            ArrayList<JsonObject> entityObjects = new ArrayList<JsonObject>();
            for (EnumCreatureType creatureType : EnumCreatureType.values()) {
                block2: for (Biome.SpawnListEntry entry : this.biome.func_76747_a(creatureType)) {
                    ResourceLocation entityName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityRegistry.getEntry((Class)entry.field_76300_b));
                    boolean containsEntry = false;
                    Iterator<Config> configIter = entityConfigs.iterator();
                    while (configIter.hasNext()) {
                        Config entityConfig = configIter.next();
                        if (entityName != null && entityConfig.getString("entity").equals(entityName.toString())) {
                            containsEntry = true;
                        }
                        entityObjects.add(entityConfig.serialize().getAsJsonObject());
                        configIter.remove();
                        if (!containsEntry) continue;
                        continue block2;
                    }
                    JsonObject entityObject = new JsonObject();
                    entityObject.addProperty("entity", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)EntityRegistry.getEntry((Class)entry.field_76300_b)).toString());
                    entityObject.addProperty("creatureType", creatureType.toString().toLowerCase());
                    entityObject.addProperty("weight", (Number)entry.field_76292_a);
                    entityObject.addProperty("minGroupCount", (Number)entry.field_76301_c);
                    entityObject.addProperty("maxGroupCount", (Number)entry.field_76299_d);
                    entityObject.addProperty("spawn", Boolean.valueOf(true));
                    entityObjects.add(entityObject);
                }
            }
            this.config.removeData("entities");
            entityConfigs = this.config.getDataBranches("entities", entityObjects);
            for (Config entityConfig : entityConfigs) {
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityConfig.getResource("entity"));
                if (entry == null || !entityConfig.getBoolean("spawn", true)) continue;
                Class entityCls = entry.getEntityClass();
                EnumCreatureType creatureType = entityConfig.getEnum("creatureType", EnumCreatureType.class);
                if (!EntityLiving.class.isAssignableFrom(entityCls)) continue;
                this.spawnableMobs.computeIfAbsent(creatureType, k -> new ArrayList()).add(new Biome.SpawnListEntry(entityCls, entityConfig.getInt("weight", 10), entityConfig.getInt("minGroupCount", 1), entityConfig.getInt("maxGroupCount", 4)));
            }
            List<Config> featureConfigs = this.config.getDataBranches("features", new ArrayList<JsonObject>());
            ArrayList<JsonObject> featureObjects = new ArrayList<JsonObject>();
            for (Config featureConfig : featureConfigs) {
                Feature feature = FeatureRegistry.createFeature(featureConfig.getResource("feature"), featureConfig);
                if (feature != null && featureConfig.getBoolean("generate", true)) {
                    GenerationStage generationStage = featureConfig.getEnum("genStage", GenerationStage.class, GenerationStage.POST_DECORATE);
                    this.generationStageFeatures.computeIfAbsent(generationStage, k -> new ArrayList()).add(feature);
                }
                featureObjects.add(featureConfig.serialize().getAsJsonObject());
            }
            this.config.removeData("features");
            this.config.getDataBranches("features", featureObjects);
            this.enabled = this.config.getBoolean("enabled", true);
            this.genDefaultFeatures = this.config.getBoolean("genDefaultFeatures", true);
        }
    }

    public Biome getBiome() {
        return this.biome;
    }

    public IBlockState getBlock(String key, IBlockState fallbackValue) {
        IBlockState value = this.getBlock(key);
        if (value == null) {
            this.config.getDataBranch("blocks").getBlock(key, fallbackValue);
            this.blocks.put(key, fallbackValue);
            return fallbackValue;
        }
        return value;
    }

    public IBlockState getBlock(String key) {
        return this.blocks.get(key);
    }

    public List<IBlockState> getBlocks() {
        return ImmutableList.copyOf(this.blocks.values());
    }

    public List<Feature> getFeatures(GenerationStage generationStage) {
        return ImmutableList.copyOf((Collection)this.generationStageFeatures.computeIfAbsent(generationStage, k -> new ArrayList()));
    }

    public List<Biome.SpawnListEntry> getSpawnableMobs(EnumCreatureType creatureType) {
        return ImmutableList.copyOf((Collection)this.spawnableMobs.computeIfAbsent(creatureType, k -> new ArrayList()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldGenDefaultFeatures() {
        return this.genDefaultFeatures;
    }
}

