/*
 * Decompiled with CFR 0.152.
 */
package lex.block;

import java.util.Collection;
import java.util.Random;
import lex.IModData;
import lex.block.BlockLibEx;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockLeavesLibEx
extends BlockLibEx
implements IShearable {
    public static final PropertyBool DECAYABLE = PropertyBool.func_177716_a((String)"decayable");
    public static final PropertyBool CHECK_DECAY = PropertyBool.func_177716_a((String)"check_decay");
    private int[] surroundings;

    public BlockLeavesLibEx(IModData data, String name, Material material) {
        super(data, name, material);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (world.func_175727_C(pos.func_177984_a()) && !world.func_180495_p(pos.func_177977_b()).func_185896_q() && rand.nextInt(15) == 1) {
            world.func_175688_a(EnumParticleTypes.DRIP_WATER, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() - 0.05, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)DECAYABLE)).booleanValue()) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (world.func_175707_a(new BlockPos(posX - 5, posY - 5, posZ - 5), new BlockPos(posX + 5, posY + 5, posZ + 5))) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int offsetX = -4; offsetX <= 4; ++offsetX) {
                    for (int offsetY = -4; offsetY <= 4; ++offsetY) {
                        for (int offsetZ = -4; offsetZ <= 4; ++offsetZ) {
                            IBlockState testState = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ));
                            Block testBlock = testState.func_177230_c();
                            if (!testBlock.canSustainLeaves(testState, (IBlockAccess)world, (BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ))) {
                                if (testBlock.isLeaves(testState, (IBlockAccess)world, (BlockPos)mutableBlockPos.func_181079_c(posX + offsetX, posY + offsetY, posZ + offsetZ))) {
                                    this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = -1;
                                continue;
                            }
                            this.surroundings[(offsetX + 16) * 1024 + (offsetY + 16) * 32 + offsetZ + 16] = 0;
                        }
                    }
                }
                for (int check = 1; check <= 4; ++check) {
                    for (int localX = -4; localX <= 4; ++localX) {
                        for (int localY = -4; localY <= 4; ++localY) {
                            for (int localZ = -4; localZ <= 4; ++localZ) {
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16] != check - 1) continue;
                                if (this.surroundings[(localX + 16 - 1) * 1024 + (localY + 16) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16 - 1) * 1024 + (localY + 16) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16 + 1) * 1024 + (localY + 16) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16 + 1) * 1024 + (localY + 16) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16 - 1) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16 - 1) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16 + 1) * 32 + localZ + 16] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16 + 1) * 32 + localZ + 16] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + (localZ + 16 - 1)] == -2) {
                                    this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + (localZ + 16 - 1)] = check;
                                }
                                if (this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16 + 1] != -2) continue;
                                this.surroundings[(localX + 16) * 1024 + (localY + 16) * 32 + localZ + 16 + 1] = check;
                            }
                        }
                    }
                }
            }
            if (this.surroundings[16912] >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(world, pos);
            }
        }
    }

    public int func_149745_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int posZ;
        int posY;
        int posX = pos.func_177958_n();
        if (world.func_175707_a(new BlockPos(posX - 2, (posY = pos.func_177956_o()) - 2, (posZ = pos.func_177952_p()) - 2), new BlockPos(posX + 2, posY + 2, posZ + 2))) {
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                        BlockPos newPos = pos.func_177982_a(offsetX, offsetY, offsetZ);
                        IBlockState checkState = world.func_180495_p(newPos);
                        if (!checkState.func_177230_c().isLeaves(checkState, (IBlockAccess)world, newPos)) continue;
                        checkState.func_177230_c().beginLeavesDecay(checkState, world, newPos);
                    }
                }
            }
        }
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)CHECK_DECAY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)CHECK_DECAY, (Comparable)Boolean.valueOf(true)), 4);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.getSaplingDropChance(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            drops.add((Object)drop);
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.dropRareItem((World)world, pos, state, chance);
        }
        drops.addAll((Collection)this.captureDrops(false));
    }

    public abstract Item func_180660_a(IBlockState var1, Random var2, int var3);

    protected abstract void dropRareItem(World var1, BlockPos var2, IBlockState var3, int var4);

    protected abstract int getSaplingDropChance(IBlockState var1);

    private void destroy(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }
}

