/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile.module;

import epicsquid.mysticallib.LibEvents;
import epicsquid.mysticallib.handlers.MysticalFluidHandler;
import epicsquid.mysticallib.handlers.SmartTank;
import epicsquid.mysticallib.tile.TileModular;
import epicsquid.mysticallib.tile.module.FaceConfig;
import epicsquid.mysticallib.tile.module.IModule;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class ModuleFluid
implements IModule<IFluidHandler> {
    @Nonnull
    public static final String MODULE_FLUID = "MODULE_FLUID";
    private Map<EnumFacing, FluidIOProxy> ioProxies = new HashMap<EnumFacing, FluidIOProxy>();
    private TileModular tile;
    @Nonnull
    private MysticalFluidHandler manager;
    @Nonnull
    private FaceConfig faceConfig;

    public ModuleFluid(@Nonnull TileModular tile, int maxTransfer) {
        this(tile, maxTransfer, new SmartTank[]{null});
    }

    public ModuleFluid(@Nonnull TileModular tile, int maxTransfer, SmartTank ... tanks) {
        this.tile = tile;
        this.manager = new MysticalFluidHandler(maxTransfer, tanks);
        this.faceConfig = tile.getFaceConfig();
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f));
        }
    }

    public ModuleFluid addTank(@Nonnull SmartTank tank) {
        this.manager.addTank(tank);
        return this;
    }

    private FluidIOProxy constructIOProxy(@Nonnull EnumFacing face) {
        return new FluidIOProxy(face, this.faceConfig.getIO(face));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<IFluidHandler> capability, @Nullable EnumFacing face) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    @Nonnull
    public IFluidHandler getCapability(@Nonnull Capability<IFluidHandler> capability, @Nullable EnumFacing face) {
        if (face != null) {
            return this.ioProxies.get(face);
        }
        return this.manager;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound fluidHandler = new NBTTagCompound();
        this.manager.writeToNBT(fluidHandler);
        return fluidHandler;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.manager.readFromNBT(tag);
    }

    @Override
    public void onBroken(@Nonnull World world, @Nonnull BlockPos pos, @Nullable EntityPlayer player) {
        for (SmartTank tank : this.manager.getTanks()) {
            if (tank.getCapacity() < 1000 || tank.getFluidAmount() < 1000) continue;
            FluidUtil.tryPlaceFluid((EntityPlayer)player, (World)world, (BlockPos)pos, (IFluidHandler)this.manager, (FluidStack)new FluidStack(tank.getFluid().getFluid(), 1000));
        }
    }

    @Override
    public void onUpdate(@Nonnull BlockPos pos, @Nonnull World world) {
        block0: for (EnumFacing dir : EnumFacing.values()) {
            if (this.faceConfig.getIO(dir) != FaceConfig.FaceIO.OUT || world.field_72995_K) continue;
            for (SmartTank tank : this.manager.getTanks()) {
                int amount;
                IFluidHandler adjTank;
                TileEntity adjTile;
                if (!tank.canDrain() || tank.getFluid() == null || tank.getFluid().getFluid() == null || (adjTile = world.func_175625_s(pos.func_177972_a(dir))) == null || !adjTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) || (adjTank = (IFluidHandler)adjTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) == null || (amount = adjTank.fill(new FluidStack(tank.getFluid().getFluid(), Math.min(this.manager.getMaxExtract(), tank.getFluidAmount())), false)) <= 0) continue;
                FluidStack fl = tank.getFluid().copy();
                adjTank.fill(new FluidStack(tank.getFluid(), amount), true);
                tank.drainInternal(new FluidStack(fl.getFluid(), amount), true);
                this.tile.func_70296_d();
                adjTile.func_70296_d();
                LibEvents.markForUpdate(this.tile.func_174877_v().func_177972_a(dir), adjTile);
                continue block0;
            }
        }
    }

    @Override
    @Nonnull
    public Capability<IFluidHandler> getCapabilityType() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    @Nonnull
    public String getModuleName() {
        return MODULE_FLUID;
    }

    public class FluidIOProxy
    extends MysticalFluidHandler {
        private EnumFacing face;
        private FaceConfig.FaceIO ioMode;

        public FluidIOProxy(@Nonnull EnumFacing face, FaceConfig.FaceIO ioMode) {
            super(ModuleFluid.this.manager.getMaxInsert());
            this.face = face;
            this.ioMode = ioMode;
        }

        @Override
        @Nonnull
        public IFluidTankProperties[] getTankProperties() {
            return ModuleFluid.this.manager.getTankProperties();
        }

        @Override
        @Nullable
        public FluidStack drain(@Nullable FluidStack stack, boolean simulate) {
            if (this.ioMode == FaceConfig.FaceIO.OUT || this.ioMode == FaceConfig.FaceIO.INOUT || this.ioMode == FaceConfig.FaceIO.NEUTRAL) {
                ModuleFluid.this.tile.func_70296_d();
                return ModuleFluid.this.manager.drain(stack, simulate);
            }
            return null;
        }

        @Override
        public int fill(@Nullable FluidStack stack, boolean simulate) {
            if (this.ioMode == FaceConfig.FaceIO.IN || this.ioMode == FaceConfig.FaceIO.INOUT) {
                ModuleFluid.this.tile.func_70296_d();
                return ModuleFluid.this.manager.fill(stack, simulate);
            }
            return 0;
        }

        @Override
        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.ioMode == FaceConfig.FaceIO.OUT || this.ioMode == FaceConfig.FaceIO.INOUT) {
                return ModuleFluid.this.manager.drain(maxDrain, doDrain);
            }
            return null;
        }
    }
}

