/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.client.renderer;

import gcewing.sg.BaseGLUtils;
import gcewing.sg.BaseTileEntityRenderer;
import gcewing.sg.SGCraft;
import gcewing.sg.Vector3;
import gcewing.sg.client.renderer.RingType;
import gcewing.sg.client.renderer.TextureIndex;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGState;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class SGBaseTERenderer
extends BaseTileEntityRenderer {
    static final int numRingSegments = 32;
    static final double ringInnerRadius = 2.0;
    static final double ringMidRadius = 2.25;
    static final double ringOuterRadius = 2.5;
    static final double ringDepth = 0.5;
    static final double ringOverlap = 0.015625;
    static final double ringZOffset = 1.0E-4;
    static final double chevronInnerRadius = 2.25;
    static final double chevronOuterRadius = 2.5625;
    static final double chevronWidth = 0.46875;
    static final double chevronDepth = 0.125;
    static final double chevronBorderWidth = 0.078125;
    static final double chevronMotionDistance = 0.125;
    static final int textureTilesWide = 32;
    static final int textureTilesHigh = 2;
    static final double textureScaleU = 0.001953125;
    static final double textureScaleV = 0.03125;
    static final double ringSymbolTextureLength = 512.0;
    static final double ringSymbolTextureHeight = 16.0;
    static final double ringSymbolSegmentWidth = 16.0;
    public static final int ehGridRadialSize = 5;
    public static final int ehGridPolarSize = 32;
    public static final double ehBandWidth = 0.4;
    static final double numIrisBlades = 12.0;
    static int[][] chevronEngagementSequences = new int[][]{{9, 3, 4, 5, 6, 0, 1, 2, 9}, {7, 3, 4, 5, 8, 0, 1, 2, 6}};
    static double[] s = new double[33];
    static double[] c = new double[33];
    double u0;
    double v0;

    @Override
    public void func_192841_a(TileEntity te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        SGBaseTE gate = (SGBaseTE)te;
        if (gate.isMerged) {
            GL11.glPushMatrix();
            if (gate.transparency) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            } else {
                GL11.glDisable((int)3042);
            }
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (gate.gateOrientation == 1) {
                GL11.glTranslated((double)(x + 0.5), (double)(y + 2.5), (double)(z + 0.5));
            }
            if (gate.gateOrientation == 2) {
                if (gate.facingDirectionOfBase == 0) {
                    GL11.glTranslated((double)(x + 0.5), (double)(y + 0.25), (double)(z + -1.5));
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)180.0f, (float)180.0f);
                }
                if (gate.facingDirectionOfBase == 1) {
                    GL11.glTranslated((double)(x + -1.5), (double)(y + 0.25), (double)(z + 0.5));
                    GL11.glRotatef((float)180.0f, (float)180.0f, (float)180.0f, (float)0.0f);
                }
                if (gate.facingDirectionOfBase == 2) {
                    GL11.glTranslated((double)(x + 0.5), (double)(y + 0.25), (double)(z + 2.5));
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)-180.0f, (float)180.0f);
                }
                if (gate.facingDirectionOfBase == 3) {
                    GL11.glTranslated((double)(x + 2.5), (double)(y + 0.25), (double)(z + 0.5));
                    GL11.glRotatef((float)180.0f, (float)180.0f, (float)-180.0f, (float)0.0f);
                }
            }
            if (gate.gateOrientation == 3) {
                if (gate.facingDirectionOfBase == 0) {
                    GL11.glTranslated((double)(x + 0.5), (double)(y + 0.25), (double)(z + -1.5));
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)-180.0f, (float)180.0f);
                }
                if (gate.facingDirectionOfBase == 1) {
                    GL11.glTranslated((double)(x + -1.5), (double)(y + 0.25), (double)(z + 0.5));
                    GL11.glRotatef((float)180.0f, (float)180.0f, (float)-180.0f, (float)0.0f);
                }
                if (gate.facingDirectionOfBase == 2) {
                    GL11.glTranslated((double)(x + 0.5), (double)(y + 0.25), (double)(z + 2.5));
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)180.0f, (float)180.0f);
                }
                if (gate.facingDirectionOfBase == 3) {
                    GL11.glTranslated((double)(x + 2.5), (double)(y + 0.25), (double)(z + 0.5));
                    GL11.glRotatef((float)180.0f, (float)180.0f, (float)180.0f, (float)0.0f);
                }
            }
            this.renderStargate(gate, partialTicks);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    void renderStargate(SGBaseTE gate, float partialTicks) {
        BaseGLUtils.glMultMatrix(gate.localToGlobalTransformation(Vector3.zero));
        if (gate.gateType <= 1) {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/milkyway/stargate.png"));
        } else {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/pegasus/stargate.png"));
        }
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        this.renderRing(2.234375, 2.5, RingType.Outer, 1.0E-4);
        this.renderInnerRing(gate, partialTicks);
        this.renderChevrons(gate);
        if (gate.hasIrisUpgrade) {
            this.renderIris(gate, partialTicks);
        }
        if (gate.isConnected() && gate.state != SGState.SyncAwait) {
            this.renderEventHorizon(gate, partialTicks);
        }
    }

    void renderInnerRing(SGBaseTE te, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)((float)(te.interpolatedRingAngle(partialTicks) + SGBaseTE.ringSymbolAngle / 2.0)), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderRing(2.0, 2.25, RingType.Inner, 0.0);
        GL11.glPopMatrix();
    }

    void renderRing(double r1, double r2, RingType type, double dz) {
        double z = 0.25 + dz;
        double u = 0.0;
        double du = 0.0;
        double dv = 0.0;
        GL11.glBegin((int)7);
        for (int i = 0; i < 32; ++i) {
            this.selectTile(TextureIndex.RING);
            switch (type) {
                case Outer: {
                    GL11.glNormal3d((double)c[i], (double)s[i], (double)0.0);
                    this.vertex(r2 * c[i], r2 * s[i], z, 0.0, 0.0);
                    this.vertex(r2 * c[i], r2 * s[i], -z, 0.0, 16.0);
                    this.vertex(r2 * c[i + 1], r2 * s[i + 1], -z, 16.0, 16.0);
                    this.vertex(r2 * c[i + 1], r2 * s[i + 1], z, 16.0, 0.0);
                    break;
                }
                case Inner: {
                    GL11.glNormal3d((double)(-c[i]), (double)(-s[i]), (double)0.0);
                    this.vertex(r1 * c[i], r1 * s[i], -z, 0.0, 0.0);
                    this.vertex(r1 * c[i], r1 * s[i], z, 0.0, 16.0);
                    this.vertex(r1 * c[i + 1], r1 * s[i + 1], z, 16.0, 16.0);
                    this.vertex(r1 * c[i + 1], r1 * s[i + 1], -z, 16.0, 0.0);
                }
            }
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            this.vertex(r1 * c[i], r1 * s[i], -z, 0.0, 16.0);
            this.vertex(r1 * c[i + 1], r1 * s[i + 1], -z, 16.0, 16.0);
            this.vertex(r2 * c[i + 1], r2 * s[i + 1], -z, 16.0, 0.0);
            this.vertex(r2 * c[i], r2 * s[i], -z, 0.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            switch (type) {
                case Outer: {
                    this.selectTile(TextureIndex.RING_FACE);
                    u = 0.0;
                    du = 16.0;
                    dv = 16.0;
                    break;
                }
                case Inner: {
                    this.selectTile(TextureIndex.RING_SYMBOL);
                    u = 512.0 - (double)(i + 1) * 16.0;
                    du = 16.0;
                    dv = 16.0;
                }
            }
            this.vertex(r1 * c[i], r1 * s[i], z, u + du, dv);
            this.vertex(r2 * c[i], r2 * s[i], z, u + du, 0.0);
            this.vertex(r2 * c[i + 1], r2 * s[i + 1], z, u, 0.0);
            this.vertex(r1 * c[i + 1], r1 * s[i + 1], z, u, dv);
        }
        GL11.glEnd();
    }

    void renderChevrons(SGBaseTE te) {
        int numChevrons = te.getNumChevrons();
        int i0 = numChevrons > 7 ? 0 : 1;
        int k = 0;
        k = te.state == SGState.Disconnecting ? (te.numEngagedChevrons > 7 ? 1 : 0) : (!te.chevronsLockOnDial ? (te.dialledAddress.length() > 7 ? 1 : 0) : (!te.immediateDialAddress.isEmpty() ? (te.immediateDialAddress.length() > 7 ? 1 : 0) : (te.dialledAddress.length() > 7 ? 1 : 0)));
        float a = te.angleBetweenChevrons();
        for (int i = i0; i < i0 + numChevrons; ++i) {
            int j = chevronEngagementSequences[k][i];
            boolean engaged = te.chevronIsEngaged(j);
            this.renderChevronAtPosition(te, i, a, engaged);
        }
    }

    void renderChevronAtPosition(SGBaseTE gate, int i, float a, boolean engaged) {
        GL11.glPushMatrix();
        if (gate.gateOrientation == 1) {
            GL11.glRotatef((float)(90.0f - (float)(i - 4) * a), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (gate.gateOrientation == 2) {
            GL11.glRotatef((float)(-90.0f - (float)(i - 4) * a), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (gate.gateOrientation == 3) {
            GL11.glRotatef((float)(90.0f - (float)(i - 4) * a), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.chevron(engaged);
        GL11.glPopMatrix();
    }

    void chevron(boolean engaged) {
        double r1 = 2.25;
        double r2 = 2.5625;
        double z2 = 0.25;
        double z1 = z2 + 0.125;
        double w1 = 0.078125;
        double w2 = w1 * 1.25;
        double x1 = r1;
        double y1 = 0.1171875;
        double x2 = r2;
        double y2 = 0.234375;
        if (engaged) {
            GL11.glTranslated((double)-0.125, (double)0.0, (double)0.0);
        }
        GL11.glBegin((int)7);
        this.selectTile(TextureIndex.CHEVRON);
        this.vertex(x2, y2, z1, 0.0, 2.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x2, y2 - w2, z1, 4.0, 2.0);
        this.vertex(x2, y2, z1, 0.0, 0.0);
        this.vertex(x2, y2, z2, 0.0, 4.0);
        this.vertex(x1, y1, z2, 16.0, 4.0);
        this.vertex(x1, y1, z1, 16.0, 0.0);
        this.vertex(x2, y2, z1, 16.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 12.0, 0.0);
        this.vertex(x2, y2 - w2, z2, 12.0, 4.0);
        this.vertex(x2, y2, z2, 16.0, 4.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x1, y1, z1, 0.0, 0.0);
        this.vertex(x1, y1, z2, 0.0, 4.0);
        this.vertex(x1, -y1, z2, 16.0, 4.0);
        this.vertex(x1, -y1, z1, 16.0, 0.0);
        this.vertex(x2, -y2 + w2, z1, 12.0, 0.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x1, -y1, z1, 0.0, 0.0);
        this.vertex(x1, -y1, z2, 0.0, 4.0);
        this.vertex(x2, -y2, z2, 16.0, 4.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x2, -y2, z1, 0.0, 0.0);
        this.vertex(x2, -y2, z2, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z2, 4.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 4.0, 0.0);
        this.vertex(x2, -y2, z2, 0.0, 0.0);
        this.vertex(x1, -y1, z2, 0.0, 16.0);
        this.vertex(x1, y1, z2, 16.0, 16.0);
        this.vertex(x2, y2, z2, 16.0, 0.0);
        GL11.glEnd();
        this.selectTile(TextureIndex.CHEVRON_LIT);
        if (!engaged) {
            GL11.glColor3d((double)0.5, (double)0.5, (double)0.5);
        } else {
            GL11.glDisable((int)2896);
            SGBaseTERenderer.setLightingDisabled(true);
        }
        GL11.glBegin((int)7);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 16.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 16.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, y2 - w2, z2, 0.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, -y2 + w2, z2, 16.0, 0.0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        SGBaseTERenderer.setLightingDisabled(false);
    }

    protected static void setLightingDisabled(boolean off) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        if (off) {
            GL11.glDisable((int)3553);
        } else {
            GL11.glEnable((int)3553);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    void renderEventHorizon(SGBaseTE te, float partialTicks) {
        if (SGCraft.useHDEventHorizionTexture) {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/eventhorizonhd.png"));
        } else {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/eventhorizon.png"));
        }
        GL11.glDisable((int)2896);
        SGBaseTERenderer.setLightingDisabled(true);
        GL11.glDisable((int)2884);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        double[][] grid = te.getEventHorizonGrid()[0];
        double rclip = 2.5 * (te.irisIsClosed() ? te.getIrisAperture(partialTicks) : 1.0);
        for (int i = 1; i < 5; ++i) {
            GL11.glBegin((int)8);
            for (int j = 0; j <= 32; ++j) {
                this.ehVertex(grid, i, j, rclip);
                this.ehVertex(grid, i + 1, j, rclip);
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)this.ehClip(grid[1][0], 0.0, rclip));
        for (int j = 0; j <= 32; ++j) {
            this.ehVertex(grid, 1, j, rclip);
        }
        GL11.glEnd();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        SGBaseTERenderer.setLightingDisabled(false);
    }

    void ehVertex(double[][] grid, int i, int j, double rclip) {
        double r = (double)i * 0.4;
        double x = r * c[j];
        double y = r * s[j];
        double z = this.ehClip(grid[j + 1][i], r, rclip);
        GL11.glTexCoord2d((double)x, (double)y);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    double ehClip(double z, double r, double rclip) {
        if (r >= rclip) {
            z = Math.min(z, 0.0);
        }
        return z;
    }

    void renderIris(SGBaseTE te, double t) {
        if (te.gateType <= 1) {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/milkyway/iris.png"));
        } else {
            this.func_147499_a(SGCraft.mod.resourceLocation("textures/tileentity/pegasus/iris.png"));
        }
        double a = 0.8 * te.getIrisAperture(t);
        int i = 0;
        while ((double)i < 12.0) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(360.0 * (double)i / 12.0), (double)0.0, (double)0.0, (double)1.0);
            this.renderIrisBlade(te, a, t);
            GL11.glPopMatrix();
            ++i;
        }
    }

    void renderIrisBlade(SGBaseTE te, double a, double t) {
        double aa = a * 60.0;
        double r = 2.31;
        double w1 = 2.4;
        double w2 = 1.85;
        double h0 = 0.16;
        double h1 = 1.0;
        double h = h1 - (h1 - h0) * a * a;
        double u = w2 / w1;
        double v = h / h1;
        double v0 = h0 / h1;
        double z0 = 0.1;
        double z1 = 0.01;
        GL11.glPushMatrix();
        GL11.glTranslated((double)r, (double)0.0, (double)0.0);
        GL11.glRotated((double)(-aa), (double)0.0, (double)0.0, (double)1.0);
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)(-w1), (double)0.0, (double)z0);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)(z0 + z1));
        GL11.glTexCoord2d((double)1.0, (double)v0);
        GL11.glVertex3d((double)0.0, (double)h0, (double)(z0 + z1));
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)(-w1 + w2), (double)h, (double)z0);
        GL11.glTexCoord2d((double)0.0, (double)v);
        GL11.glVertex3d((double)(-w1), (double)h, (double)z0);
        GL11.glEnd();
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)(-w1), (double)0.0, (double)z0);
        GL11.glTexCoord2d((double)0.0, (double)v);
        GL11.glVertex3d((double)(-w1), (double)h, (double)z0);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)(-w1 + w2), (double)h, (double)z0);
        GL11.glTexCoord2d((double)1.0, (double)v0);
        GL11.glVertex3d((double)0.0, (double)h0, (double)(z0 - z1));
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)(z0 - z1));
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    void selectTile(TextureIndex index) {
        this.u0 = (double)(index.index % 32) * 0.03125;
        this.v0 = (double)(index.index / 32) * 0.5;
    }

    void vertex(double x, double y, double z, double u, double v) {
        GL11.glTexCoord2d((double)(this.u0 + u * 0.001953125), (double)(this.v0 + v * 0.03125));
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            double a = Math.PI * 2 * (double)i / 32.0;
            SGBaseTERenderer.s[i] = Math.sin(a);
            SGBaseTERenderer.c[i] = Math.cos(a);
        }
    }
}

