/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.misc.client.render.RenderParrotEgg;
import vazkii.quark.misc.client.render.RenderParrotKoto;
import vazkii.quark.misc.entity.EntityParrotEgg;
import vazkii.quark.misc.item.ItemParrotEgg;

public class ParrotEggs
extends Feature {
    private static final String TAG_EGG_TIMER = "quark:parrot_egg_timer";
    public static Item parrot_egg;
    public static Item item;
    public static double chance;
    public static int eggTime;
    public static boolean enableKotobirb;

    @Override
    public void setupConfig() {
        item = Items.field_185163_cU;
        String itemName = this.loadPropString("Feed Item", "", Objects.toString(item.getRegistryName()));
        Item targetItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
        if (targetItem != null) {
            item = targetItem;
        }
        chance = this.loadLegacyPropChance("Success Percentage Chance", "Success Chance", "If this is X, the parrot will, on average, start making an egg in every 1/X seeds fed", 0.05);
        eggTime = this.loadPropInt("Egg Creation Time", "", 12000);
        enableKotobirb = this.loadPropBool("Enable Special Awesome Parrot", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        parrot_egg = new ItemParrotEgg();
        String eggName = "quark:parrot_egg";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(eggName), EntityParrotEgg.class, (String)eggName, (int)14, (Object)Quark.instance, (int)64, (int)10, (boolean)true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        RenderingRegistry.registerEntityRenderingHandler(EntityParrotEgg.class, RenderParrotEgg.factory());
        if (enableKotobirb) {
            RenderingRegistry.registerEntityRenderingHandler(EntityParrot.class, RenderParrotKoto.factory());
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity e;
        if (event.getTarget() != null && (e = event.getTarget()) instanceof EntityParrot && e.getEntityData().func_74762_e(TAG_EGG_TIMER) == 0) {
            EntityParrot parrot = (EntityParrot)e;
            if (!parrot.func_70909_n()) {
                return;
            }
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || stack.func_77973_b() != item) {
                stack = player.func_184592_cb();
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == item) {
                event.setCanceled(true);
                if (e.field_70170_p.field_72995_K || event.getHand() == EnumHand.OFF_HAND) {
                    return;
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                WorldServer ws = (WorldServer)e.field_70170_p;
                ws.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, SoundEvents.field_192797_eu, SoundCategory.NEUTRAL, 1.0f, 1.0f + (ws.field_73012_v.nextFloat() - ws.field_73012_v.nextFloat()) * 0.2f);
                if (e.field_70170_p.field_73012_v.nextDouble() < chance) {
                    e.getEntityData().func_74768_a(TAG_EGG_TIMER, eggTime);
                    ws.func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, e.field_70165_t, e.field_70163_u, e.field_70161_v, 10, (double)e.field_70130_N, (double)e.field_70131_O, (double)e.field_70130_N, 0.0, new int[0]);
                } else {
                    ws.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, e.field_70165_t, e.field_70163_u, e.field_70161_v, 10, (double)e.field_70130_N, (double)e.field_70131_O, (double)e.field_70130_N, 0.0, new int[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void entityUpdate(LivingEvent.LivingUpdateEvent event) {
        int time;
        Entity e = event.getEntity();
        if (e instanceof EntityParrot && (time = e.getEntityData().func_74762_e(TAG_EGG_TIMER)) > 0) {
            if (time == 1) {
                e.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (e.field_70170_p.field_73012_v.nextFloat() - e.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                e.func_70099_a(new ItemStack(parrot_egg, 1, this.getResultingEggColor((EntityParrot)e)), 0.0f);
            }
            e.getEntityData().func_74768_a(TAG_EGG_TIMER, time - 1);
        }
    }

    private int getResultingEggColor(EntityParrot parrot) {
        int color = parrot.func_191998_ds();
        Random rand = parrot.field_70170_p.field_73012_v;
        if (rand.nextBoolean()) {
            return color;
        }
        return rand.nextInt(5);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

