/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.lens.Lens;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.blocks.BlockLaserRelay;
import de.ellpeck.actuallyadditions.mod.booklet.chapter.BookletChapter;
import de.ellpeck.actuallyadditions.mod.booklet.chapter.BookletChapterTrials;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageCrafting;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageFurnace;
import de.ellpeck.actuallyadditions.mod.booklet.page.PagePicture;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageTextOnly;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.items.lens.LensRecipeHandler;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class MethodHandler
implements IMethodHandler {
    @Override
    public boolean addEffectToStack(ItemStack stack, CoffeeIngredient ingredient) {
        PotionEffect[] effects;
        boolean worked = false;
        if (ingredient != null && (effects = ingredient.getEffects()) != null && effects.length > 0) {
            for (PotionEffect effect : effects) {
                PotionEffect effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.func_76458_c() >= ingredient.getMaxAmplifier() - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public PotionEffect getSameEffectFromStack(ItemStack stack, PotionEffect effect) {
        PotionEffect[] effectsStack = this.getEffectsFromStack(stack);
        if (effectsStack != null && effectsStack.length > 0) {
            for (PotionEffect effectStack : effectsStack) {
                if (effect.func_188419_a() != effectStack.func_188419_a()) continue;
                return effectStack;
            }
        }
        return null;
    }

    @Override
    public void addEffectProperties(ItemStack stack, PotionEffect effect, boolean addDur, boolean addAmp) {
        PotionEffect[] effects = this.getEffectsFromStack(stack);
        stack.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < effects.length; ++i) {
            if (effects[i].func_188419_a() == effect.func_188419_a()) {
                effects[i] = new PotionEffect(effects[i].func_188419_a(), effects[i].func_76459_b() + (addDur ? effect.func_76459_b() : 0), effects[i].func_76458_c() + (addAmp ? (effect.func_76458_c() > 0 ? effect.func_76458_c() : 1) : 0));
            }
            this.addEffectToStack(stack, effects[i]);
        }
    }

    @Override
    public void addEffectToStack(ItemStack stack, PotionEffect effect) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        int prevCounter = tag.func_74762_e("Counter");
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", Potion.func_188409_a((Potion)effect.func_188419_a()));
        compound.func_74768_a("Duration", effect.func_76459_b());
        compound.func_74768_a("Amplifier", effect.func_76458_c());
        int counter = prevCounter + 1;
        tag.func_74782_a(counter + "", (NBTBase)compound);
        tag.func_74768_a("Counter", counter);
        stack.func_77982_d(tag);
    }

    @Override
    public PotionEffect[] getEffectsFromStack(ItemStack stack) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            for (int counter = tag.func_74762_e("Counter"); counter > 0; --counter) {
                NBTTagCompound compound = (NBTTagCompound)tag.func_74781_a(counter + "");
                PotionEffect effect = new PotionEffect(Potion.func_188412_a((int)compound.func_74762_e("ID")), compound.func_74762_e("Duration"), (int)compound.func_74771_c("Amplifier"));
                effects.add(effect);
            }
        }
        return effects.size() > 0 ? effects.toArray(new PotionEffect[effects.size()]) : null;
    }

    @Override
    public boolean invokeConversionLens(IBlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null) {
            int range = 1;
            int rangeX = 0;
            int rangeY = 0;
            int rangeZ = 0;
            EnumFacing facing = tile.getOrientation();
            if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
                rangeY = range;
                if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                    rangeX = range;
                } else {
                    rangeZ = range;
                }
            } else {
                rangeX = range;
                rangeZ = range;
            }
            for (int reachX = -rangeX; reachX <= rangeX; ++reachX) {
                block1: for (int reachZ = -rangeZ; reachZ <= rangeZ; ++reachZ) {
                    for (int reachY = -rangeY; reachY <= rangeY; ++reachY) {
                        ItemStack output;
                        LensConversionRecipe recipe;
                        IBlockState state;
                        BlockPos pos = new BlockPos(hitBlock.func_177958_n() + reachX, hitBlock.func_177956_o() + reachY, hitBlock.func_177952_p() + reachZ);
                        if (tile.getWorldObject().func_175623_d(pos) || (state = tile.getWorldObject().func_180495_p(pos)).func_177230_c() instanceof BlockLaserRelay || (recipe = LensRecipeHandler.findMatchingRecipe(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)), tile.getLens())) == null || tile.getEnergy() < recipe.getEnergyUsed() || !StackUtil.isValid(output = recipe.getOutput())) continue;
                        tile.getWorldObject().func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                        recipe.transformHook(ItemStack.field_190927_a, state, pos, tile);
                        if (output.func_77973_b() instanceof ItemBlock) {
                            Block toPlace = Block.func_149634_a((Item)output.func_77973_b());
                            IBlockState state2Place = toPlace.getStateForPlacement(tile.getWorldObject(), pos, facing, 0.0f, 0.0f, 0.0f, output.func_77960_j(), (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)tile.getWorldObject())), EnumHand.MAIN_HAND);
                            tile.getWorldObject().func_180501_a(pos, state2Place, 2);
                        } else {
                            EntityItem item = new EntityItem(tile.getWorldObject(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, output.func_77946_l());
                            tile.getWorldObject().func_72838_d((Entity)item);
                            tile.getWorldObject().func_175698_g(pos);
                        }
                        tile.extractEnergy(recipe.getEnergyUsed());
                        continue block1;
                    }
                }
            }
            AxisAlignedBB aabb = new AxisAlignedBB((double)tile.getPosition().func_177958_n(), (double)tile.getPosition().func_177956_o(), (double)tile.getPosition().func_177952_p(), (double)(hitBlock.func_177958_n() + 1), (double)(hitBlock.func_177956_o() + 1), (double)(hitBlock.func_177952_p() + 1));
            Vec3i dir = tile.getOrientation().func_176730_m();
            aabb = aabb.func_72314_b(0.02, 0.02, 0.02).func_72321_a((double)dir.func_177958_n(), (double)dir.func_177956_o(), (double)dir.func_177952_p());
            List items = tile.getWorldObject().func_72872_a(EntityItem.class, aabb);
            for (EntityItem item : items) {
                int itemsPossible;
                LensConversionRecipe recipe;
                ItemStack stack = item.func_92059_d();
                if (item.field_70128_L || !StackUtil.isValid(stack) || (recipe = LensRecipeHandler.findMatchingRecipe(stack, tile.getLens())) == null || (itemsPossible = Math.min(tile.getEnergy() / recipe.getEnergyUsed(), stack.func_190916_E())) <= 0) continue;
                recipe.transformHook(item.func_92059_d(), null, item.func_180425_c(), tile);
                item.func_70106_y();
                if (stack.func_190916_E() - itemsPossible > 0) {
                    ItemStack stackCopy = stack.func_77946_l();
                    stackCopy.func_190918_g(itemsPossible);
                    EntityItem inputLeft = new EntityItem(tile.getWorldObject(), item.field_70165_t, item.field_70163_u, item.field_70161_v, stackCopy);
                    tile.getWorldObject().func_72838_d((Entity)inputLeft);
                }
                ItemStack outputCopy = recipe.getOutput().func_77946_l();
                outputCopy.func_190920_e(itemsPossible);
                EntityItem newItem = new EntityItem(tile.getWorldObject(), item.field_70165_t, item.field_70163_u, item.field_70161_v, outputCopy);
                tile.getWorldObject().func_72838_d((Entity)newItem);
                tile.extractEnergy(recipe.getEnergyUsed() * itemsPossible);
                break;
            }
            return !hitState.func_177230_c().isAir(hitState, (IBlockAccess)tile.getWorldObject(), hitBlock);
        }
        return false;
    }

    @Override
    public boolean invokeReconstructor(IAtomicReconstructor tile) {
        if (tile.getEnergy() >= 1000) {
            EnumFacing sideToManipulate = tile.getOrientation();
            Lens currentLens = tile.getLens();
            if (currentLens.canInvoke(tile, sideToManipulate, 1000)) {
                tile.extractEnergy(1000);
                int distance = currentLens.getDistance();
                for (int i = 0; i < distance; ++i) {
                    BlockPos hitBlock = tile.getPosition().func_177967_a(sideToManipulate, i + 1);
                    if (!currentLens.invoke(tile.getWorldObject().func_180495_p(hitBlock), hitBlock, tile) && i < distance - 1) continue;
                    TileEntityAtomicReconstructor.shootLaser(tile.getWorldObject(), tile.getX(), tile.getY(), tile.getZ(), hitBlock.func_177958_n(), hitBlock.func_177956_o(), hitBlock.func_177952_p(), currentLens);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, List<ItemStack> outputOnes, int outputOneAmounts, List<ItemStack> outputTwos, int outputTwoAmounts, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        for (ItemStack input : inputs) {
            if (!StackUtil.isValid(input) || CrusherRecipeRegistry.getRecipeFromInput(input) != null) continue;
            for (ItemStack outputOne : outputOnes) {
                if (!StackUtil.isValid(outputOne) || CrusherRecipeRegistry.hasBlacklistedOutput(outputOne, ConfigStringListValues.CRUSHER_OUTPUT_BLACKLIST.getValue())) continue;
                ItemStack outputOneCopy = outputOne.func_77946_l();
                outputOneCopy.func_190920_e(outputOneAmounts);
                if (outputTwos.isEmpty()) {
                    ActuallyAdditionsAPI.addCrusherRecipe(input, outputOneCopy, StackUtil.getEmpty(), 0);
                    hasWorkedOnce = true;
                    continue;
                }
                for (ItemStack outputTwo : outputTwos) {
                    if (!StackUtil.isValid(outputTwo) || CrusherRecipeRegistry.hasBlacklistedOutput(outputTwo, ConfigStringListValues.CRUSHER_OUTPUT_BLACKLIST.getValue())) continue;
                    ItemStack outputTwoCopy = outputTwo.func_77946_l();
                    outputTwoCopy.func_190920_e(outputTwoAmounts);
                    ActuallyAdditionsAPI.addCrusherRecipe(input, outputOneCopy, outputTwoCopy, outputTwoChance);
                    hasWorkedOnce = true;
                }
            }
        }
        return hasWorkedOnce;
    }

    @Override
    public boolean addCrusherRecipes(List<ItemStack> inputs, ItemStack outputOne, int outputOneAmount, ItemStack outputTwo, int outputTwoAmount, int outputTwoChance) {
        boolean hasWorkedOnce = false;
        for (ItemStack input : inputs) {
            if (!StackUtil.isValid(input) || CrusherRecipeRegistry.getRecipeFromInput(input) != null || !StackUtil.isValid(outputOne) || CrusherRecipeRegistry.hasBlacklistedOutput(outputOne, ConfigStringListValues.CRUSHER_OUTPUT_BLACKLIST.getValue())) continue;
            ItemStack outputOneCopy = outputOne.func_77946_l();
            outputOneCopy.func_190920_e(outputOneAmount);
            if (!StackUtil.isValid(outputTwo)) {
                ActuallyAdditionsAPI.addCrusherRecipe(input, outputOneCopy, StackUtil.getEmpty(), 0);
                hasWorkedOnce = true;
                continue;
            }
            if (!StackUtil.isValid(outputTwo) || CrusherRecipeRegistry.hasBlacklistedOutput(outputTwo, ConfigStringListValues.CRUSHER_OUTPUT_BLACKLIST.getValue())) continue;
            ItemStack outputTwoCopy = outputTwo.func_77946_l();
            outputTwoCopy.func_190920_e(outputTwoAmount);
            ActuallyAdditionsAPI.addCrusherRecipe(input, outputOneCopy, outputTwoCopy, outputTwoChance);
            hasWorkedOnce = true;
        }
        return hasWorkedOnce;
    }

    @Override
    public IBookletPage generateTextPage(int id) {
        return this.generateTextPage(id, 0);
    }

    @Override
    public IBookletPage generatePicturePage(int id, ResourceLocation resLoc, int textStartY) {
        return this.generatePicturePage(id, resLoc, textStartY, 0);
    }

    @Override
    public IBookletPage generateCraftingPage(int id, IRecipe ... recipes) {
        return this.generateCraftingPage(id, 0, recipes);
    }

    @Override
    public IBookletPage generateFurnacePage(int id, ItemStack input, ItemStack result) {
        return this.generateFurnacePage(id, input, result, 0);
    }

    @Override
    public IBookletChapter generateBookletChapter(String identifier, IBookletEntry entry, ItemStack displayStack, IBookletPage ... pages) {
        return this.generateBookletChapter(identifier, entry, displayStack, 0, pages);
    }

    @Override
    public IBookletPage generateTextPage(int id, int priority) {
        return new PageTextOnly(id, priority);
    }

    @Override
    public IBookletPage generatePicturePage(int id, ResourceLocation resLoc, int textStartY, int priority) {
        return new PagePicture(id, resLoc, textStartY, priority);
    }

    @Override
    public IBookletPage generateCraftingPage(int id, int priority, IRecipe ... recipes) {
        return new PageCrafting(id, priority, recipes);
    }

    @Override
    public IBookletPage generateFurnacePage(int id, ItemStack input, ItemStack result, int priority) {
        return new PageFurnace(id, result, priority);
    }

    @Override
    public IBookletChapter generateBookletChapter(String identifier, IBookletEntry entry, ItemStack displayStack, int priority, IBookletPage ... pages) {
        return new BookletChapter(identifier, entry, displayStack, priority, pages);
    }

    @Override
    public IBookletChapter createTrial(String identifier, ItemStack displayStack, boolean textOnSecondPage) {
        return new BookletChapterTrials(identifier, displayStack, textOnSecondPage);
    }
}

