/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.core.Patch;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.world.NextTickListEntry;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public final class WorldServerPatch
extends Patch {
    public static final String WORLD_SERVER_PATCH = WorldServerPatch.getName(WorldServerPatch.class);

    @Override
    public boolean apply(ClassNode node) {
        WorldServerPatch.patch(WorldServerPatch.findInstructions(node, "isUpdateScheduled", "func_184145_b"), "contains");
        WorldServerPatch.patch(WorldServerPatch.findInstructions(node, "updateBlockTick", "func_175654_a"), "contains");
        WorldServerPatch.patch(WorldServerPatch.findInstructions(node, "scheduleBlockUpdate", "func_175684_a"), "contains");
        WorldServerPatch.patch(WorldServerPatch.findInstructions(node, "tickUpdates", "func_72955_a"), "remove");
        return true;
    }

    public static boolean contains(Set<NextTickListEntry> entries, Object object) {
        for (NextTickListEntry entry : entries) {
            if (!object.equals(entry)) continue;
            return true;
        }
        return false;
    }

    public static boolean remove(Set<NextTickListEntry> entries, Object object) {
        Iterator<NextTickListEntry> it = entries.iterator();
        while (it.hasNext()) {
            if (!object.equals(it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private static void patch(InsnList instructions, String methodName) {
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 185) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!"java/util/Set".equals(method.owner) || !methodName.equals(method.name)) continue;
            method.setOpcode(184);
            method.owner = WORLD_SERVER_PATCH;
            method.desc = "(Ljava/util/Set;Ljava/lang/Object;)Z";
            return;
        }
    }
}

