/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.storage.INameCache;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;

public final class NameCache
implements INameCache {
    public static final NameCache INSTANCE = new NameCache();
    private final ConcurrentHashMap<UUID, NBTTagCompound> cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(UUID uuid, String name) {
        if (uuid == null || name == null) {
            return;
        }
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            NBTTagCompound tag = this.cache.get(uuid);
            if (tag == null) {
                tag = new NBTTagCompound();
                tag.func_74757_a("isOP", false);
            }
            tag.func_74778_a("name", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            if (!this.cache.containsKey(uuid)) {
                return uuid.toString();
            }
            return this.cache.get(uuid).func_74779_i("name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID getUUID(String name) {
        if (name == null) {
            return null;
        }
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
                if (!entry.getValue().func_74779_i("name").equalsIgnoreCase(name)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOP(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            if (!this.cache.containsKey(uuid)) {
                return false;
            }
            return this.cache.get(uuid).func_74767_n("isOP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNames(MinecraftServer server) {
        String[] names;
        for (String name : names = server.func_152358_ax().func_152654_a()) {
            GameProfile prof;
            EntityPlayerMP player = server.func_184103_al().func_152612_a(name);
            GameProfile gameProfile = prof = player == null ? null : player.func_146103_bH();
            if (prof == null) continue;
            ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
            synchronized (concurrentHashMap) {
                UUID oldID = this.getUUID(prof.getName());
                while (oldID != null) {
                    this.cache.remove(oldID);
                    oldID = this.getUUID(prof.getName());
                }
                NBTTagCompound json = new NBTTagCompound();
                json.func_74778_a("name", prof.getName());
                json.func_74757_a("isOP", server.func_184103_al().func_152596_g(prof));
                this.cache.put(prof.getId(), json);
            }
        }
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            return this.cache.size();
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagList(), (List<UUID>)null));
        return new QuestingPacket(PacketTypeNative.NAME_CACHE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_150295_c("data", 10), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagList writeToNBT(NBTTagList json, List<UUID> users) {
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            for (Map.Entry<UUID, NBTTagCompound> entry : this.cache.entrySet()) {
                NBTTagCompound jn = new NBTTagCompound();
                jn.func_74778_a("uuid", entry.getKey().toString());
                jn.func_74778_a("name", entry.getValue().func_74779_i("name"));
                jn.func_74757_a("isOP", entry.getValue().func_74767_n("isOP"));
                json.func_74742_a((NBTBase)jn);
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagList nbt, boolean merge) {
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            this.cache.clear();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                NBTBase element = nbt.func_179238_g(i);
                if (element.func_74732_a() != 10) continue;
                NBTTagCompound jn = (NBTTagCompound)element;
                try {
                    UUID uuid = UUID.fromString(jn.func_74779_i("uuid"));
                    String name = jn.func_74779_i("name");
                    boolean isOP = jn.func_74767_n("isOP");
                    NBTTagCompound j2 = new NBTTagCompound();
                    j2.func_74778_a("name", name);
                    j2.func_74757_a("isOP", isOP);
                    this.cache.put(uuid, j2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllNames() {
        ArrayList<String> list = new ArrayList<String>();
        ConcurrentHashMap<UUID, NBTTagCompound> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            for (NBTTagCompound json : this.cache.values()) {
                if (json == null || !json.func_150297_b("name", 8)) continue;
                list.add(json.func_74779_i("name"));
            }
        }
        return list;
    }
}

