/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.placeholders.tasks.FactoryTaskPlaceholder;
import betterquesting.api.placeholders.tasks.TaskPlaceholder;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.tasks.TaskRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class TaskStorage
extends SimpleDatabase<ITask>
implements IDatabaseNBT<ITask, NBTTagList, NBTTagList> {
    @Override
    public NBTTagList writeToNBT(NBTTagList json) {
        for (DBEntry entry : this.getEntries()) {
            ResourceLocation taskID = ((ITask)entry.getValue()).getFactoryID();
            NBTTagCompound qJson = ((ITask)entry.getValue()).writeToNBT(new NBTTagCompound());
            qJson.func_74778_a("taskID", taskID.toString());
            qJson.func_74768_a("index", entry.getID());
            json.func_74742_a((NBTBase)qJson);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json) {
        this.reset();
        ArrayList<ITask> unassigned = new ArrayList<ITask>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jt2;
            ResourceLocation loc2;
            ITask t2;
            NBTTagCompound jsonTask = json.func_150305_b(i);
            ResourceLocation loc = new ResourceLocation(jsonTask.func_74779_i("taskID"));
            int index = jsonTask.func_150297_b("index", 99) ? jsonTask.func_74762_e("index") : -1;
            ITask task = TaskRegistry.INSTANCE.createNew(loc);
            if (task instanceof TaskPlaceholder && (t2 = TaskRegistry.INSTANCE.createNew(loc2 = new ResourceLocation((jt2 = jsonTask.func_74775_l("orig_data")).func_74779_i("taskID")))) != null) {
                jsonTask = jt2;
                task = t2;
            }
            if (task != null) {
                task.readFromNBT(jsonTask);
            } else {
                task = new TaskPlaceholder();
                ((TaskPlaceholder)task).setTaskConfigData(jsonTask);
            }
            if (index >= 0) {
                this.add(index, task);
                continue;
            }
            unassigned.add(task);
        }
        for (ITask t : unassigned) {
            this.add(this.nextID(), t);
        }
    }

    @Override
    public NBTTagList writeProgressToNBT(NBTTagList json, List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            ResourceLocation taskID = ((ITask)entry.getValue()).getFactoryID();
            NBTTagCompound qJson = ((ITask)entry.getValue()).writeProgressToNBT(new NBTTagCompound(), users);
            qJson.func_74778_a("taskID", taskID.toString());
            qJson.func_74768_a("index", entry.getID());
            json.func_74742_a((NBTBase)qJson);
        }
        return json;
    }

    @Override
    public void readProgressFromNBT(NBTTagList json, boolean merge) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jsonTask = json.func_150305_b(i);
            int index = jsonTask.func_150297_b("index", 99) ? jsonTask.func_74762_e("index") : -1;
            ResourceLocation loc = new ResourceLocation(jsonTask.func_74779_i("taskID"));
            ITask task = (ITask)this.getValue(index);
            if (task instanceof TaskPlaceholder) {
                if (!task.getFactoryID().equals((Object)loc)) {
                    ((TaskPlaceholder)task).setTaskProgressData(jsonTask);
                    continue;
                }
                task.readProgressFromNBT(jsonTask, false);
                continue;
            }
            if (task == null) continue;
            if (task.getFactoryID().equals((Object)loc)) {
                task.readProgressFromNBT(jsonTask, false);
                continue;
            }
            if (!FactoryTaskPlaceholder.INSTANCE.getRegistryName().equals((Object)loc)) continue;
            task.readProgressFromNBT(jsonTask.func_74775_l("orig_prog"), false);
        }
    }
}

