/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyInstance;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyManager
extends SimpleDatabase<IParty>
implements IPartyDatabase {
    public static final PartyManager INSTANCE = new PartyManager();
    private final HashMap<UUID, Integer> partyCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IParty getUserParty(UUID uuid) {
        if (!QuestSettings.INSTANCE.getProperty(NativeProps.PARTY_ENABLE).booleanValue()) {
            return null;
        }
        DBEntry<T>[] dBEntryArray = this.partyCache;
        synchronized (this.partyCache) {
            IParty cachedParty;
            Integer cachedID = this.partyCache.get(uuid);
            IParty iParty = cachedParty = cachedID == null ? null : (IParty)this.getValue(cachedID);
            if (cachedID != null && cachedParty == null) {
                this.partyCache.remove(uuid);
            } else if (cachedParty != null) {
                EnumPartyStatus status = cachedParty.getStatus(uuid);
                if (status != null && status != EnumPartyStatus.INVITE) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return cachedParty;
                }
                this.partyCache.remove(uuid);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (DBEntry entry : this.getEntries()) {
                EnumPartyStatus status = ((IParty)entry.getValue()).getStatus(uuid);
                if (status == null || status == EnumPartyStatus.INVITE) continue;
                this.partyCache.put(uuid, entry.getID());
                return (IParty)entry.getValue();
            }
            return null;
        }
    }

    @Override
    public List<Integer> getPartyInvites(UUID uuid) {
        ArrayList<Integer> invites = new ArrayList<Integer>();
        boolean isOp = NameCache.INSTANCE.isOP(uuid);
        for (DBEntry entry : this.getEntries()) {
            if (!isOp && ((IParty)entry.getValue()).getStatus(uuid) != EnumPartyStatus.INVITE) continue;
            invites.add(entry.getID());
        }
        return invites;
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagList(), (List<UUID>)null));
        return new QuestingPacket(PacketTypeNative.PARTY_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_150295_c("data", 10), false);
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jp = ((IParty)entry.getValue()).writeToNBT(new NBTTagCompound());
            jp.func_74768_a("partyID", entry.getID());
            json.func_74742_a((NBTBase)jp);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, boolean merge) {
        this.reset();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            int partyID;
            NBTBase element = json.func_179238_g(i);
            if (element.func_74732_a() != 10) continue;
            NBTTagCompound jp = (NBTTagCompound)element;
            int n = partyID = jp.func_150297_b("partyID", 99) ? jp.func_74762_e("partyID") : -1;
            if (partyID < 0) continue;
            PartyInstance party = new PartyInstance();
            party.readFromNBT(jp);
            if (party.getMembers().size() <= 0) continue;
            this.add(partyID, party);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        HashMap<UUID, Integer> hashMap = this.partyCache;
        synchronized (hashMap) {
            this.partyCache.clear();
        }
    }
}

