/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.questing.rewards.RewardStorage;
import betterquesting.questing.tasks.TaskStorage;
import betterquesting.storage.PropertyContainer;
import betterquesting.storage.QuestSettings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class QuestInstance
implements IQuest {
    private final TaskStorage tasks = new TaskStorage();
    private final RewardStorage rewards = new RewardStorage();
    private final HashMap<UUID, NBTTagCompound> completeUsers = new HashMap();
    private int[] preRequisites = new int[0];
    private final PropertyContainer qInfo = new PropertyContainer();

    public QuestInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151156_bN));
        this.setupValue(NativeProps.SOUND_COMPLETE);
        this.setupValue(NativeProps.SOUND_UPDATE);
        this.setupValue(NativeProps.LOGIC_QUEST, EnumLogic.AND);
        this.setupValue(NativeProps.LOGIC_TASK, EnumLogic.AND);
        this.setupValue(NativeProps.REPEAT_TIME, -1);
        this.setupValue(NativeProps.LOCKED_PROGRESS, false);
        this.setupValue(NativeProps.AUTO_CLAIM, false);
        this.setupValue(NativeProps.SILENT, false);
        this.setupValue(NativeProps.MAIN, false);
        this.setupValue(NativeProps.PARTY_LOOT, false);
        this.setupValue(NativeProps.GLOBAL_SHARE, false);
        this.setupValue(NativeProps.SIMULTANEOUS, false);
        this.setupValue(NativeProps.VISIBILITY, EnumQuestVisibility.NORMAL);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.qInfo.setProperty(prop, this.qInfo.getProperty(prop, def));
    }

    @Override
    public void update(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        int done = 0;
        for (DBEntry entry : this.tasks.getEntries()) {
            if (!((ITask)entry.getValue()).isComplete(playerID)) continue;
            ++done;
        }
        if (this.tasks.size() <= 0 || this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
            this.setComplete(playerID, FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E());
        } else if (done > 0 && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
            this.resetUser(playerID, false);
        }
    }

    @Override
    public void detect(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc == null) {
            return;
        }
        int questID = QuestDatabase.INSTANCE.getID(this);
        if (this.isComplete(playerID) && (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0 || this.rewards.size() <= 0)) {
            return;
        }
        if (!this.canSubmit(player)) {
            return;
        }
        if (this.isUnlocked(playerID) || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            int done = 0;
            boolean update = false;
            for (DBEntry entry : this.tasks.getEntries()) {
                if (!((ITask)entry.getValue()).isComplete(playerID)) {
                    ((ITask)entry.getValue()).detect(player, this);
                    if (!((ITask)entry.getValue()).isComplete(playerID)) continue;
                    ++done;
                    update = true;
                    continue;
                }
                ++done;
            }
            if (this.tasks.size() <= 0 || this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
                if (QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
                    this.setComplete(playerID, FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E());
                }
                qc.markQuestDirty(questID);
            } else if (update && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                qc.markQuestDirty(questID);
            } else if (update) {
                qc.markQuestDirty(questID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClaimed(UUID uuid) {
        if (this.rewards.size() <= 0) {
            return true;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry;
            if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
                if (this.GetParticipation(uuid) < this.qInfo.getProperty(NativeProps.PARTICIPATION).floatValue()) {
                    return true;
                }
                if (!this.qInfo.getProperty(NativeProps.GLOBAL_SHARE).booleanValue()) {
                    for (NBTTagCompound entry2 : this.completeUsers.values()) {
                        if (!entry2.func_74767_n("claimed")) continue;
                        return true;
                    }
                    return false;
                }
            }
            if ((entry = this.getCompletionInfo(uuid)) == null) {
                return false;
            }
            return entry.func_74767_n("claimed");
        }
    }

    @Override
    public boolean canClaim(EntityPlayer player) {
        NBTTagCompound entry = this.getCompletionInfo(QuestingAPI.getQuestingUUID(player));
        if (entry == null || this.hasClaimed(QuestingAPI.getQuestingUUID(player))) {
            return false;
        }
        if (this.canSubmit(player)) {
            return false;
        }
        for (DBEntry rew : this.rewards.getEntries()) {
            if (((IReward)rew.getValue()).canClaim(player, this)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void claimReward(EntityPlayer player) {
        for (DBEntry rew : this.rewards.getEntries()) {
            ((IReward)rew.getValue()).claimReward(player, this);
        }
        UUID pID = QuestingAPI.getQuestingUUID(player);
        IParty party = PartyManager.INSTANCE.getUserParty(pID);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (party != null && this.qInfo.getProperty(NativeProps.PARTY_LOOT).booleanValue()) {
                for (UUID mem : party.getMembers()) {
                    EnumPartyStatus pStat = party.getStatus(mem);
                    if (pStat == null || pStat == EnumPartyStatus.INVITE) continue;
                    NBTTagCompound entry = this.getCompletionInfo(mem);
                    if (entry == null) {
                        entry = new NBTTagCompound();
                        this.completeUsers.put(mem, entry);
                    }
                    entry.func_74757_a("claimed", true);
                    entry.func_74772_a("timestamp", FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E());
                }
            } else {
                NBTTagCompound entry = this.getCompletionInfo(pID);
                if (entry == null) {
                    entry = new NBTTagCompound();
                    this.completeUsers.put(pID, entry);
                }
                entry.func_74757_a("claimed", true);
                entry.func_74772_a("timestamp", FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E());
            }
        }
        if (qc != null) {
            qc.markQuestDirty(QuestDatabase.INSTANCE.getID(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSubmit(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry = this.getCompletionInfo(playerID);
            if (entry == null) {
                return true;
            }
            if (!entry.func_74767_n("claimed") && this.getProperty(NativeProps.REPEAT_TIME) >= 0) {
                if (this.tasks.size() <= 0) {
                    return true;
                }
                int done = 0;
                for (DBEntry tsk : this.tasks.getEntries()) {
                    if (!((ITask)tsk.getValue()).isComplete(playerID)) continue;
                    ++done;
                }
                return !this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size());
            }
            return false;
        }
    }

    private float GetParticipation(UUID uuid) {
        if (this.tasks.size() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (DBEntry t : this.tasks.getEntries()) {
            if (!(t.getValue() instanceof IProgression)) continue;
            total += ((IProgression)t.getValue()).getParticipation(uuid);
        }
        return total / (float)this.tasks.size();
    }

    @Override
    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip(EntityPlayer player) {
        List<String> tooltip = this.getStandardTooltip(player);
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            tooltip.add("");
            tooltip.addAll(this.getAdvancedTooltip(player));
        }
        return tooltip;
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getStandardTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(QuestTranslation.translate(this.qInfo.getProperty(NativeProps.NAME), new Object[0]) + (!Minecraft.func_71410_x().field_71474_y.field_82882_x ? "" : " #" + QuestDatabase.INSTANCE.getID(this)));
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(playerID)) {
            list.add(TextFormatting.GREEN + QuestTranslation.translate("betterquesting.tooltip.complete", new Object[0]));
            if (!this.hasClaimed(playerID)) {
                list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.rewards_pending", new Object[0]));
            } else if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) > 0) {
                long time = this.getRepeatSeconds(player);
                DecimalFormat df = new DecimalFormat("00");
                String timeTxt = "";
                if (time >= 3600L) {
                    timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
                } else if (time >= 60L) {
                    timeTxt = timeTxt + time / 60L + "m ";
                }
                timeTxt = timeTxt + df.format(time % 60L) + "s";
                list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
            }
        } else if (!this.isUnlocked(playerID)) {
            list.add(TextFormatting.RED + "" + TextFormatting.UNDERLINE + QuestTranslation.translate("betterquesting.tooltip.requires", new Object[0]) + " (" + this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase() + ")");
            for (DBEntry<IQuest> req : QuestDatabase.INSTANCE.bulkLookup(this.getRequirements())) {
                if (req.getValue().isComplete(playerID)) continue;
                list.add(TextFormatting.RED + "- " + QuestTranslation.translate(req.getValue().getProperty(NativeProps.NAME), new Object[0]));
            }
        } else {
            int n = 0;
            for (DBEntry task : this.tasks.getEntries()) {
                if (!((ITask)task.getValue()).isComplete(playerID)) continue;
                ++n;
            }
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.tasks_complete", n, this.tasks.size()));
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    private List<String> getAdvancedTooltip(EntityPlayer player) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_quest", this.qInfo.getProperty(NativeProps.GLOBAL)));
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.global_share", this.qInfo.getProperty(NativeProps.GLOBAL_SHARE)));
        }
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.task_logic", this.qInfo.getProperty(NativeProps.LOGIC_QUEST).toString().toUpperCase()));
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.simultaneous", this.qInfo.getProperty(NativeProps.SIMULTANEOUS)));
        list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.auto_claim", this.qInfo.getProperty(NativeProps.AUTO_CLAIM)));
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) >= 0) {
            long time = this.qInfo.getProperty(NativeProps.REPEAT_TIME) / 20;
            DecimalFormat df = new DecimalFormat("00");
            String timeTxt = "";
            if (time >= 3600L) {
                timeTxt = timeTxt + time / 3600L + "h " + df.format(time % 3600L / 60L) + "m ";
            } else if (time >= 60L) {
                timeTxt = timeTxt + time / 60L + "m ";
            }
            timeTxt = timeTxt + df.format(time % 60L) + "s";
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", timeTxt));
        } else {
            list.add(TextFormatting.GRAY + QuestTranslation.translate("betterquesting.tooltip.repeat", false));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public long getRepeatSeconds(EntityPlayer player) {
        if (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0) {
            return -1L;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound ue = this.getCompletionInfo(QuestingAPI.getQuestingUUID(player));
            if (ue == null) {
                return 0L;
            }
            return ((long)this.qInfo.getProperty(NativeProps.REPEAT_TIME).intValue() - (player.field_70170_p.func_82737_E() - ue.func_74763_f("timestamp"))) / 20L;
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        base.func_74782_a("progress", (NBTBase)this.writeProgressToNBT(new NBTTagCompound(), (List<UUID>)null));
        tags.func_74782_a("data", (NBTBase)base);
        tags.func_74768_a("questID", QuestDatabase.INSTANCE.getID(this));
        return new QuestingPacket(PacketTypeNative.QUEST_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        NBTTagCompound base = payload.func_74775_l("data");
        this.readFromNBT(base.func_74775_l("config"));
        this.readProgressFromNBT(base.func_74775_l("progress"), false);
    }

    @Override
    public boolean isUnlocked(UUID uuid) {
        if (this.preRequisites.length <= 0) {
            return true;
        }
        int A = 0;
        int B = this.preRequisites.length;
        for (DBEntry<IQuest> quest : QuestDatabase.INSTANCE.bulkLookup(this.getRequirements())) {
            if (!quest.getValue().isComplete(uuid)) continue;
            ++A;
        }
        return this.qInfo.getProperty(NativeProps.LOGIC_QUEST).getResult(A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComplete(UUID uuid, long timestamp) {
        if (uuid == null) {
            return;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry = this.getCompletionInfo(uuid);
            if (entry == null) {
                entry = new NBTTagCompound();
                this.completeUsers.put(uuid, entry);
            }
            entry.func_74757_a("claimed", false);
            entry.func_74772_a("timestamp", timestamp);
        }
    }

    @Override
    public boolean isComplete(UUID uuid) {
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            return this.completeUsers.size() > 0;
        }
        return this.getCompletionInfo(uuid) != null;
    }

    @Override
    public EnumQuestState getState(UUID uuid) {
        if (this.isComplete(uuid)) {
            if (this.hasClaimed(uuid)) {
                return EnumQuestState.COMPLETED;
            }
            return EnumQuestState.UNCLAIMED;
        }
        if (this.isUnlocked(uuid)) {
            return EnumQuestState.UNLOCKED;
        }
        return EnumQuestState.LOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound getCompletionInfo(UUID uuid) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            return this.completeUsers.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompletionInfo(UUID uuid, NBTTagCompound nbt) {
        if (uuid == null) {
            return;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (nbt == null) {
                this.completeUsers.remove(uuid);
            } else {
                this.completeUsers.put(uuid, nbt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetUser(UUID uuid, boolean fullReset) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (fullReset) {
                this.completeUsers.remove(uuid);
            } else {
                NBTTagCompound entry = this.getCompletionInfo(uuid);
                if (entry != null) {
                    entry.func_74757_a("claimed", false);
                    entry.func_74772_a("timestamp", 0L);
                }
            }
            for (DBEntry t : this.tasks.getEntries()) {
                ((ITask)t.getValue()).resetUser(uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAll(boolean fullReset) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (fullReset) {
                this.completeUsers.clear();
            } else {
                for (NBTTagCompound entry : this.completeUsers.values()) {
                    entry.func_74757_a("claimed", false);
                    entry.func_74772_a("timestamp", 0L);
                }
            }
            for (DBEntry t : this.tasks.getEntries()) {
                ((ITask)t.getValue()).resetAll();
            }
        }
    }

    @Override
    public IDatabaseNBT<ITask, NBTTagList, NBTTagList> getTasks() {
        return this.tasks;
    }

    @Override
    public IDatabaseNBT<IReward, NBTTagList, NBTTagList> getRewards() {
        return this.rewards;
    }

    @Override
    @Nonnull
    public int[] getRequirements() {
        return this.preRequisites;
    }

    @Override
    public void setRequirements(@Nonnull int[] req) {
        this.preRequisites = req;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound jObj) {
        jObj.func_74782_a("properties", (NBTBase)this.qInfo.writeToNBT(new NBTTagCompound()));
        jObj.func_74782_a("tasks", (NBTBase)this.tasks.writeToNBT(new NBTTagList()));
        jObj.func_74782_a("rewards", (NBTBase)this.rewards.writeToNBT(new NBTTagList()));
        jObj.func_74782_a("preRequisites", (NBTBase)new NBTTagIntArray(this.getRequirements()));
        return jObj;
    }

    @Override
    public void readFromNBT(NBTTagCompound jObj) {
        this.qInfo.readFromNBT(jObj.func_74775_l("properties"));
        this.tasks.readFromNBT(jObj.func_150295_c("tasks", 10));
        this.rewards.readFromNBT(jObj.func_150295_c("rewards", 10));
        if (jObj.func_150299_b("preRequisites") == 11) {
            this.setRequirements(jObj.func_74759_k("preRequisites"));
        } else {
            NBTTagList rList = jObj.func_150295_c("preRequisites", 4);
            int[] req = new int[rList.func_74745_c()];
            for (int i = 0; i < rList.func_74745_c(); ++i) {
                NBTBase pTag = rList.func_179238_g(i);
                req[i] = pTag instanceof NBTPrimitive ? ((NBTPrimitive)pTag).func_150287_d() : -1;
            }
            this.setRequirements(req);
        }
        this.setupProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, List<UUID> users) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagList comJson = new NBTTagList();
            for (Map.Entry<UUID, NBTTagCompound> entry : this.completeUsers.entrySet()) {
                if (entry.getValue() == null || entry.getKey() == null) continue;
                NBTTagCompound tags = entry.getValue().func_74737_b();
                tags.func_74778_a("uuid", entry.getKey().toString());
                comJson.func_74742_a((NBTBase)tags);
            }
            json.func_74782_a("completed", (NBTBase)comJson);
            NBTTagList tskJson = this.tasks.writeProgressToNBT(new NBTTagList(), users);
            json.func_74782_a("tasks", (NBTBase)tskJson);
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            this.completeUsers.clear();
            NBTTagList comList = json.func_150295_c("completed", 10);
            for (int i = 0; i < comList.func_74745_c(); ++i) {
                NBTTagCompound entry = comList.func_150305_b(i).func_74737_b();
                try {
                    UUID uuid = UUID.fromString(entry.func_74779_i("uuid"));
                    this.completeUsers.put(uuid, entry);
                    continue;
                }
                catch (Exception e) {
                    BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for quest", (Throwable)e);
                }
            }
            this.tasks.readProgressFromNBT(json.func_150295_c("tasks", 10), merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClaimed(UUID uuid, long timestamp) {
        IParty party = PartyManager.INSTANCE.getUserParty(uuid);
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (party == null || !this.getProperty(NativeProps.PARTY_LOOT).booleanValue()) {
                NBTTagCompound entry = this.getCompletionInfo(uuid);
                if (entry != null) {
                    entry.func_74757_a("claimed", true);
                    entry.func_74772_a("timestamp", timestamp);
                } else {
                    entry = new NBTTagCompound();
                    entry.func_74757_a("claimed", true);
                    entry.func_74772_a("timestamp", timestamp);
                    this.completeUsers.put(uuid, entry);
                }
            } else {
                for (UUID mem : party.getMembers()) {
                    NBTTagCompound entry = this.getCompletionInfo(mem);
                    if (entry != null) {
                        entry.func_74757_a("claimed", true);
                        entry.func_74772_a("timestamp", timestamp);
                        continue;
                    }
                    entry = new NBTTagCompound();
                    entry.func_74757_a("claimed", true);
                    entry.func_74772_a("timestamp", timestamp);
                    this.completeUsers.put(mem, entry);
                }
            }
        }
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        return this.qInfo.getProperty(prop);
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        return this.qInfo.getProperty(prop, def);
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        return this.qInfo.hasProperty(prop);
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        this.qInfo.setProperty(prop, value);
    }

    @Override
    public void removeProperty(IPropertyType<?> prop) {
        this.qInfo.removeProperty(prop);
    }

    @Override
    public void removeAllProps() {
        this.qInfo.removeAllProps();
    }
}

