/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyInstance;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PktHandlerPartyAction
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.PARTY_EDIT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound data, EntityPlayerMP sender) {
        IParty tarParty;
        UUID senderID;
        EnumPartyStatus status;
        UUID tarUser;
        int partyID;
        EnumPacketAction action;
        boolean isOp;
        block20: {
            int aID;
            if (sender == null) {
                return;
            }
            isOp = sender.field_70170_p.func_73046_m().func_184103_al().func_152596_g(sender.func_146103_bH());
            int n = aID = !data.func_74764_b("action") ? -1 : data.func_74762_e("action");
            if (aID < 0 || aID >= EnumPacketAction.values().length) {
                return;
            }
            action = EnumPacketAction.values()[aID];
            partyID = !data.func_74764_b("partyID") ? -1 : data.func_74762_e("partyID");
            tarUser = null;
            status = null;
            senderID = QuestingAPI.getQuestingUUID((EntityPlayer)sender);
            if (isOp) {
                tarParty = (IParty)PartyManager.INSTANCE.getValue(partyID);
                status = EnumPartyStatus.OWNER;
            } else {
                tarParty = action == EnumPacketAction.JOIN ? (IParty)PartyManager.INSTANCE.getValue(partyID) : PartyManager.INSTANCE.getUserParty(senderID);
                if (tarParty != null) {
                    status = tarParty.getStatus(senderID);
                }
            }
            if (data.func_74764_b("target")) {
                String tarName = data.func_74779_i("target");
                try {
                    tarUser = UUID.fromString(tarName);
                }
                catch (Exception e) {
                    EntityPlayerMP tpmp;
                    tarUser = NameCache.INSTANCE.getUUID(tarName);
                    if (tarUser != null || (tpmp = sender.field_70170_p.func_73046_m().func_184103_al().func_152612_a(tarName)) == null) break block20;
                    tarUser = QuestingAPI.getQuestingUUID((EntityPlayer)tpmp);
                }
            }
        }
        if (action == EnumPacketAction.ADD && tarParty == null) {
            String name = data.func_74779_i("name");
            name = name.length() > 0 ? name : "New Party";
            PartyInstance nParty = new PartyInstance();
            nParty.getProperties().setProperty(NativeProps.NAME, name);
            nParty.inviteUser(senderID);
            PartyManager.INSTANCE.add(PartyManager.INSTANCE.nextID(), nParty);
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
        } else if (action == EnumPacketAction.REMOVE && tarParty != null && status == EnumPartyStatus.OWNER) {
            PartyManager.INSTANCE.removeID(partyID);
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
        } else if (action == EnumPacketAction.KICK && tarUser != null && tarParty != null && status != null && (status.ordinal() >= 2 || tarUser.equals(senderID))) {
            tarParty.kickUser(tarUser);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
        } else if (action == EnumPacketAction.EDIT && tarParty != null && status == EnumPartyStatus.OWNER) {
            tarParty.readPacket(data);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
        } else if (action == EnumPacketAction.JOIN && tarParty != null && (isOp || status == EnumPartyStatus.INVITE)) {
            if (isOp) {
                tarParty.inviteUser(senderID);
            }
            tarParty.setStatus(senderID, EnumPartyStatus.MEMBER);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
        } else if (action == EnumPacketAction.INVITE && tarParty != null && tarUser != null && status != null && status.ordinal() >= 2) {
            tarParty.inviteUser(tarUser);
            PacketSender.INSTANCE.sendToAll(tarParty.getSyncPacket());
        }
    }

    @Override
    public void handleClient(NBTTagCompound data) {
    }
}

