/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.importers.ImportedQuestLines;
import betterquesting.client.importers.ImportedQuests;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;

public class PktHandlerImport
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.IMPORT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound tag, EntityPlayerMP sender) {
        if (sender == null || sender.func_184102_h() == null) {
            return;
        }
        boolean isOP = sender.func_184102_h().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to import quests without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit quests!"), false);
            return;
        }
        NBTTagCompound jsonBase = tag.func_74775_l("data");
        ImportedQuests impQuestDB = new ImportedQuests();
        ImportedQuestLines impQuestLineDB = new ImportedQuestLines();
        impQuestDB.readFromNBT(jsonBase.func_150295_c("quests", 10), false);
        impQuestLineDB.readFromNBT(jsonBase.func_150295_c("lines", 10), false);
        BetterQuesting.logger.log(Level.INFO, "Importing " + impQuestDB.size() + " quest(s) and " + impQuestLineDB.size() + " quest line(s) from " + sender.func_146103_bH().getName());
        HashMap<Integer, Integer> remapped = this.getRemappedIDs(impQuestDB.getEntries());
        for (DBEntry entry : impQuestDB.getEntries()) {
            int[] oldIDs = Arrays.copyOf(((IQuest)entry.getValue()).getRequirements(), ((IQuest)entry.getValue()).getRequirements().length);
            for (int n = 0; n < oldIDs.length; ++n) {
                if (!remapped.containsKey(oldIDs[n])) continue;
                oldIDs[n] = remapped.get(oldIDs[n]);
            }
            ((IQuest)entry.getValue()).setRequirements(oldIDs);
            QuestDatabase.INSTANCE.add(remapped.get(entry.getID()), entry.getValue());
        }
        for (DBEntry questLine : impQuestLineDB.getEntries()) {
            ArrayList pendingQLE = new ArrayList();
            for (DBEntry qle : ((IQuestLine)questLine.getValue()).getEntries()) {
                pendingQLE.add(qle);
                ((IQuestLine)questLine.getValue()).removeID(qle.getID());
            }
            for (DBEntry dBEntry : pendingQLE) {
                if (!remapped.containsKey(dBEntry.getID())) {
                    BetterQuesting.logger.error("Failed to import quest into quest line. Unable to remap ID " + dBEntry.getID());
                    continue;
                }
                ((IQuestLine)questLine.getValue()).add(remapped.get(dBEntry.getID()), dBEntry.getValue());
            }
            QuestLineDatabase.INSTANCE.add(QuestLineDatabase.INSTANCE.nextID(), questLine.getValue());
        }
        PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
        PacketSender.INSTANCE.sendToAll(QuestLineDatabase.INSTANCE.getSyncPacket());
    }

    @Override
    public void handleClient(NBTTagCompound tag) {
    }

    private HashMap<Integer, Integer> getRemappedIDs(DBEntry<IQuest>[] idList) {
        int[] nextIDs = this.getNextIDs(idList.length);
        HashMap<Integer, Integer> remapped = new HashMap<Integer, Integer>();
        for (int i = 0; i < nextIDs.length; ++i) {
            remapped.put(idList[i].getID(), nextIDs[i]);
        }
        return remapped;
    }

    private int[] getNextIDs(int num) {
        DBEntry<T>[] listDB = QuestDatabase.INSTANCE.getEntries();
        int[] nxtIDs = new int[num];
        if (listDB.length <= 0 || listDB[listDB.length - 1].getID() == listDB.length - 1) {
            for (int i = 0; i < num; ++i) {
                nxtIDs[i] = listDB.length + i;
            }
            return nxtIDs;
        }
        int n1 = 0;
        int n2 = 0;
        for (int i = 0; i < num; ++i) {
            while (n2 < listDB.length && listDB[n2].getID() == n1) {
                ++n1;
                ++n2;
            }
            nxtIDs[i] = n1++;
        }
        return nxtIDs;
    }
}

