/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.events.QuestEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.placeholders.FluidPlaceholder;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenTest;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNone;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.storage.DBEntry;
import betterquesting.client.BQ_Keybindings;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandler {
    public static final EventHandler INSTANCE = new EventHandler();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (BQ_Keybindings.openQuests.func_151468_f()) {
            if (mc.field_71439_g.func_70093_af() && mc.field_71439_g.func_70005_c_().equalsIgnoreCase("Funwayguy")) {
                mc.func_147108_a((GuiScreen)new GuiScreenTest(mc.field_71462_r));
            } else if (BQ_Settings.useBookmark && GuiHome.bookmark != null) {
                mc.func_147108_a(GuiHome.bookmark);
            } else {
                mc.func_147108_a(ThemeRegistry.INSTANCE.getGui(PresetGUIs.HOME, GArgsNone.NONE));
            }
        }
    }

    @SubscribeEvent
    public void onCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof EntityPlayer)) {
            return;
        }
        event.addCapability(CapabilityProviderQuestCache.LOC_QUEST_CACHE, (ICapabilityProvider)new CapabilityProviderQuestCache());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        QuestCache oCache = (QuestCache)event.getOriginal().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        QuestCache nCache = (QuestCache)event.getEntityPlayer().getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (oCache != null && nCache != null) {
            nCache.deserializeNBT(oCache.serializeNBT());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            if (event.getEntityLiving().field_70173_aa % 20 != 0) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            boolean editMode = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE);
            if (qc == null) {
                return;
            }
            List<DBEntry<IQuest>> activeQuests = QuestDatabase.INSTANCE.bulkLookup(qc.getActiveQuests());
            List<DBEntry<IQuest>> pendingAutoClaims = QuestDatabase.INSTANCE.bulkLookup(qc.getPendingAutoClaims());
            QuestCache.QResetTime[] pendingResets = qc.getScheduledResets();
            UUID uuid = QuestingAPI.getQuestingUUID(player);
            boolean refreshCache = false;
            if (!editMode && player.field_70173_aa % 60 == 0) {
                for (DBEntry<IQuest> quest : activeQuests) {
                    if (!quest.getValue().isUnlocked(uuid)) continue;
                    if (quest.getValue().canSubmit(player)) {
                        quest.getValue().update(player);
                    }
                    if (!quest.getValue().isComplete(uuid) || quest.getValue().canSubmit(player)) continue;
                    refreshCache = true;
                    qc.markQuestDirty(quest.getID());
                    MinecraftForge.EVENT_BUS.post((Event)new QuestEvent.QuestComplete(quest.getID(), uuid));
                    if (quest.getValue().getProperty(NativeProps.SILENT).booleanValue()) continue;
                    EventHandler.postPresetNotice(quest.getValue(), player, 2);
                }
            }
            if (!editMode && player.func_184102_h() != null) {
                long totalTime = player.func_184102_h().func_71218_a(0).func_82737_E();
                for (QuestCache.QResetTime rTime : pendingResets) {
                    IQuest entry = (IQuest)QuestDatabase.INSTANCE.getValue(rTime.questID);
                    if (totalTime < rTime.time || entry.canSubmit(player)) break;
                    if (entry.getProperty(NativeProps.GLOBAL).booleanValue()) {
                        entry.resetAll(false);
                    } else {
                        entry.resetUser(uuid, false);
                    }
                    refreshCache = true;
                    qc.markQuestDirty(rTime.questID);
                    if (entry.getProperty(NativeProps.SILENT).booleanValue()) continue;
                    EventHandler.postPresetNotice(entry, player, 1);
                }
            }
            if (!editMode) {
                for (DBEntry<IQuest> entry : pendingAutoClaims) {
                    if (!entry.getValue().canClaim(player)) continue;
                    entry.getValue().claimReward(player);
                    refreshCache = true;
                    qc.markQuestDirty(entry.getID());
                }
            }
            if (refreshCache || player.field_70173_aa % 200 == 0) {
                qc.updateCache(player);
            }
            List<DBEntry<IQuest>> syncMe = QuestDatabase.INSTANCE.bulkLookup(qc.getDirtyQuests());
            for (DBEntry<IQuest> entry : syncMe) {
                if (entry.getValue().getProperty(NativeProps.GLOBAL).booleanValue()) {
                    PacketSender.INSTANCE.sendToAll(entry.getValue().getSyncPacket());
                    continue;
                }
                if (!(player instanceof EntityPlayerMP)) continue;
                IParty party = PartyManager.INSTANCE.getUserParty(uuid);
                if (party != null && player.func_184102_h() != null) {
                    for (UUID memID : party.getMembers()) {
                        EntityPlayerMP memPlayer = player.func_184102_h().func_184103_al().func_177451_a(memID);
                        if (memPlayer == null) continue;
                        PacketSender.INSTANCE.sendToPlayer(entry.getValue().getSyncPacket(), memPlayer);
                    }
                    continue;
                }
                PacketSender.INSTANCE.sendToPlayer(entry.getValue().getSyncPacket(), (EntityPlayerMP)player);
            }
            qc.cleanAllQuests();
        }
    }

    private static void postPresetNotice(IQuest quest, EntityPlayer player, int preset) {
        switch (preset) {
            case 0: {
                EventHandler.postNotice(quest, player, "betterquesting.notice.unlock", quest.getProperty(NativeProps.NAME), quest.getProperty(NativeProps.SOUND_UNLOCK), quest.getProperty(NativeProps.ICON));
                break;
            }
            case 1: {
                EventHandler.postNotice(quest, player, "betterquesting.notice.update", quest.getProperty(NativeProps.NAME), quest.getProperty(NativeProps.SOUND_UPDATE), quest.getProperty(NativeProps.ICON));
                break;
            }
            case 2: {
                EventHandler.postNotice(quest, player, "betterquesting.notice.complete", quest.getProperty(NativeProps.NAME), quest.getProperty(NativeProps.SOUND_COMPLETE), quest.getProperty(NativeProps.ICON));
            }
        }
    }

    private static void postNotice(IQuest quest, EntityPlayer player, String mainTxt, String subTxt, String sound, BigItemStack icon) {
        if (QuestDatabase.INSTANCE.getID(quest) < 0) {
            BetterQuesting.logger.error("Non-existant quest is posting notifications!", (Throwable)new Exception());
        }
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a("Main", mainTxt);
        tags.func_74778_a("Sub", subTxt);
        tags.func_74778_a("Sound", sound);
        tags.func_74782_a("Icon", (NBTBase)icon.writeToNBT(new NBTTagCompound()));
        QuestingPacket payload = new QuestingPacket(PacketTypeNative.NOTIFICATION.GetLocation(), tags);
        if (quest.getProperty(NativeProps.GLOBAL).booleanValue()) {
            PacketSender.INSTANCE.sendToAll(payload);
        } else if (player instanceof EntityPlayerMP) {
            PacketSender.INSTANCE.sendToPlayer(payload, (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("betterquesting")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (!event.getWorld().field_72995_K && BQ_Settings.curWorldDir != null && event.getWorld().field_73011_w.getDimension() == 0) {
            SaveLoadHandler.INSTANCE.saveDatabases();
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.player.func_184102_h() == null || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        if (BetterQuesting.proxy.isClient() && !event.player.func_184102_h().func_71262_S() && event.player.func_184102_h().func_71214_G().equals(event.player.func_146103_bH().getName())) {
            return;
        }
        EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
        NameCache.INSTANCE.updateNames(event.player.func_184102_h());
        PacketSender.INSTANCE.sendToPlayer(QuestSettings.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(QuestDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(QuestLineDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(LifeDatabase.INSTANCE.getSyncPacket(), mpPlayer);
        PacketSender.INSTANCE.sendToPlayer(PartyManager.INSTANCE.getSyncPacket(), mpPlayer);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue() && event.player instanceof EntityPlayerMP && !((EntityPlayerMP)event.player).field_71136_j) {
            int lives;
            EntityPlayerMP mpPlayer = (EntityPlayerMP)event.player;
            IParty party = PartyManager.INSTANCE.getUserParty(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer));
            int n = lives = party == null || party.getProperties().getProperty(NativeProps.PARTY_LIVES) == false ? LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)mpPlayer)) : LifeDatabase.INSTANCE.getLives(party);
            if (lives <= 0) {
                MinecraftServer server = mpPlayer.func_184102_h();
                if (server == null) {
                    return;
                }
                mpPlayer.func_71033_a(GameType.SPECTATOR);
                mpPlayer.func_71121_q().func_82736_K().func_82764_b("spectatorsGenerateChunks", "false");
            } else if (lives == 1) {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString("This is your last life!"), true);
            } else {
                mpPlayer.func_146105_b((ITextComponent)new TextComponentString(lives + " lives remaining!"), true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || !QuestSettings.INSTANCE.getProperty(NativeProps.HARDCORE).booleanValue()) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)event.getEntityLiving());
            IParty party = PartyManager.INSTANCE.getUserParty(uuid);
            if (party == null || !party.getProperties().getProperty(NativeProps.PARTY_LIVES).booleanValue()) {
                int lives = LifeDatabase.INSTANCE.getLives(uuid);
                LifeDatabase.INSTANCE.setLives(uuid, lives - 1);
            } else {
                int lives = LifeDatabase.INSTANCE.getLives(party);
                LifeDatabase.INSTANCE.setLives(party, lives - 1);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            event.getMap().func_174942_a(FluidPlaceholder.fluidPlaceholder.getStill());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDataUpdated(DatabaseEvent.Update event) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof INeedsRefresh) {
            Minecraft.func_71410_x().func_152344_a(((INeedsRefresh)screen)::refreshGui);
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (event.getCommand().func_71517_b().equalsIgnoreCase("op") || event.getCommand().func_71517_b().equalsIgnoreCase("deop"))) {
            NameCache.INSTANCE.updateNames(server);
        }
    }
}

