/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;

public class QuestCommandEdit
extends QuestCommandBase {
    @Override
    public String getCommand() {
        return "edit";
    }

    @Override
    public String getUsageSuffix() {
        return "[true|false]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 1 || args.length == 2;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        return args.length == 2 ? CommandBase.func_71530_a((String[])args, (String[])new String[]{"true", "false"}) : Collections.emptyList();
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        boolean flag;
        boolean bl = flag = QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE) == false;
        if (args.length == 2) {
            try {
                flag = args[1].equalsIgnoreCase("on") ? true : (args[1].equalsIgnoreCase("off") ? false : Boolean.parseBoolean(args[1]));
            }
            catch (Exception e) {
                throw this.getException(command);
            }
        }
        if (flag) {
            NameCache.INSTANCE.updateNames(server);
        }
        QuestSettings.INSTANCE.setProperty(NativeProps.EDIT_MODE, flag);
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.edit", new Object[]{new TextComponentTranslation(QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE) != false ? "options.on" : "options.off", new Object[0])}));
        SaveLoadHandler.INSTANCE.markDirty();
        PacketSender.INSTANCE.sendToAll(QuestSettings.INSTANCE.getSyncPacket());
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.edit";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to activate quest editing mode on and off";
    }
}

