/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.client.toolbox.tools.ToolboxToolComplete;
import betterquesting.client.toolbox.tools.ToolboxToolCopy;
import betterquesting.client.toolbox.tools.ToolboxToolDelete;
import betterquesting.client.toolbox.tools.ToolboxToolFrame;
import betterquesting.client.toolbox.tools.ToolboxToolGrab;
import betterquesting.client.toolbox.tools.ToolboxToolIcon;
import betterquesting.client.toolbox.tools.ToolboxToolLink;
import betterquesting.client.toolbox.tools.ToolboxToolNew;
import betterquesting.client.toolbox.tools.ToolboxToolOpen;
import betterquesting.client.toolbox.tools.ToolboxToolRemove;
import betterquesting.client.toolbox.tools.ToolboxToolReset;
import betterquesting.client.toolbox.tools.ToolboxToolScale;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class PanelTabMain
extends CanvasEmpty {
    private final CanvasQuestLine cvQuestLine;
    private final PanelToolController toolController;
    private static final List<ToolEntry> toolEntries = new ArrayList<ToolEntry>();

    public PanelTabMain(IGuiRect rect, CanvasQuestLine cvQuestLine, PanelToolController toolController) {
        super(rect);
        this.cvQuestLine = cvQuestLine;
        this.toolController = toolController;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int w = this.getTransform().getWidth();
        GuiColorStatic tCol = new GuiColorStatic(-16777216);
        this.addPanel(new PanelButton(new GuiRectangle(0, 0, w / 2, 16, 0), -1, "" + ToolboxTabMain.INSTANCE.getSnapValue()){

            @Override
            public void onButtonClick() {
                ToolboxTabMain.INSTANCE.toggleSnap();
                this.setText("" + ToolboxTabMain.INSTANCE.getSnapValue());
            }
        }.setIcon(PresetIcon.ICON_GRID.getTexture()).setTextShadow(false).setTextHighlight(tCol, tCol, tCol).setTooltip(PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.snap.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.snap.desc", new Object[0]))));
        this.addPanel(new PanelButton(new GuiRectangle(w / 2, 0, w / 2, 16, 0), -1, ""){

            @Override
            public void onButtonClick() {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_147108_a((GuiScreen)new GuiNbtEditor(mc.field_71462_r, PanelTabMain.this.cvQuestLine.getQuestLine().writeToNBT(new NBTTagCompound(), null), value -> {
                    NBTTagCompound tag2 = new NBTTagCompound();
                    NBTTagCompound base2 = new NBTTagCompound();
                    base2.func_74782_a("line", (NBTBase)value);
                    tag2.func_74782_a("data", (NBTBase)base2);
                    tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
                    tag2.func_74768_a("lineID", QuestLineDatabase.INSTANCE.getID(PanelTabMain.this.cvQuestLine.getQuestLine()));
                    PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
                }));
            }
        }.setIcon(PresetIcon.ICON_PROPS.getTexture()).setTooltip(PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.raw.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.raw.desc", new Object[0]))));
        ArrayList<PanelButtonStorage<IToolboxTool>> toolBtns = new ArrayList<PanelButtonStorage<IToolboxTool>>();
        for (int i = 0; i < toolEntries.size(); ++i) {
            ToolEntry entry = toolEntries.get(i);
            int x = i % 2 * (w / 2);
            int y = i / 2 * 16 + 24;
            PanelButtonStorage<IToolboxTool> btn = new PanelButtonStorage<IToolboxTool>(new GuiRectangle(x, y, w / 2, 16, 0), -1, "", entry.tool);
            btn.setActive(this.toolController.getActiveTool() != entry.tool);
            btn.setIcon(entry.tex).setTooltip(entry.tt);
            btn.setCallback(value -> {
                this.toolController.setActiveTool((IToolboxTool)value);
                toolBtns.forEach(b -> b.setActive(true));
                btn.setActive(false);
            });
            toolBtns.add(btn);
            this.addPanel(btn);
            if (!(entry.tool instanceof ToolboxToolOpen) || this.toolController.getActiveTool() != null) continue;
            this.toolController.setActiveTool(entry.tool);
            btn.setActive(false);
        }
    }

    private static List<String> makeToolTip(String title, String desc) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(title);
        list.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(TextFormatting.GRAY + desc, 128));
        return list;
    }

    static {
        toolEntries.add(new ToolEntry(new ToolboxToolOpen(), PresetIcon.ICON_CURSOR.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.open.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.open.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolNew(), PresetIcon.ICON_NEW.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.new.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.new.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolGrab(), PresetIcon.ICON_GRAB.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.grab.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.grab.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolLink(), PresetIcon.ICON_LINK.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.link.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.link.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolCopy(), PresetIcon.ICON_COPY.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.copy.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.copy.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolScale(), PresetIcon.ICON_SCALE.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.scale.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.scale.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolDelete(), PresetIcon.ICON_TRASH.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.delete.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.delete.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolRemove(), PresetIcon.ICON_NEGATIVE.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.remove.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.remove.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolComplete(), PresetIcon.ICON_TICK.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.complete.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.complete.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolReset(), PresetIcon.ICON_REFRESH.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.reset.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.reset.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolIcon(), PresetIcon.ICON_ITEM.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.icon.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.icon.desc", new Object[0]))));
        toolEntries.add(new ToolEntry(new ToolboxToolFrame(), PresetIcon.ICON_NOTICE.getTexture(), PanelTabMain.makeToolTip(QuestTranslation.translate("betterquesting.toolbox.tool.frame.name", new Object[0]), QuestTranslation.translate("betterquesting.toolbox.tool.frame.desc", new Object[0]))));
    }

    private static class ToolEntry {
        private final IToolboxTool tool;
        private final IGuiTexture tex;
        private final List<String> tt;

        private ToolEntry(IToolboxTool tool, IGuiTexture tex, List<String> tt) {
            this.tool = tool;
            this.tex = tex;
            this.tt = tt;
        }
    }
}

