/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.themes;

import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.lines.SimpleLine;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SlicedTexture;
import betterquesting.api2.client.gui.themes.GuiKey;
import betterquesting.api2.client.gui.themes.IGuiTheme;
import betterquesting.api2.client.gui.themes.IThemeRegistry;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.registry.IFactoryData;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.editors.GuiFileBrowser;
import betterquesting.client.gui2.editors.GuiTextEditor;
import betterquesting.client.gui2.editors.nbt.GuiEntitySelection;
import betterquesting.client.gui2.editors.nbt.GuiFluidSelection;
import betterquesting.client.gui2.editors.nbt.GuiItemSelection;
import betterquesting.client.gui2.editors.nbt.GuiNbtEditor;
import betterquesting.client.themes.LegacyThemeLoader;
import betterquesting.client.themes.ResourceRegistry;
import betterquesting.client.themes.ResourceTheme;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.ConfigHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class ThemeRegistry
implements IThemeRegistry {
    public static final ThemeRegistry INSTANCE = new ThemeRegistry();
    private static final IGuiTexture NULL_TEXTURE = new SlicedTexture(PresetTexture.TX_NULL, new GuiRectangle(0, 0, 32, 32), new GuiPadding(8, 8, 8, 8));
    private static final IGuiLine NULL_LINE = new SimpleLine();
    private static final IGuiColor NULL_COLOR = new GuiColorStatic(-16777216);
    private final HashMap<ResourceLocation, IGuiTexture> defTextures = new HashMap();
    private final HashMap<ResourceLocation, IGuiLine> defLines = new HashMap();
    private final HashMap<ResourceLocation, IGuiColor> defColors = new HashMap();
    private final HashMap<GuiKey<?>, Function<?, GuiScreen>> defGuis = new HashMap();
    private final HashMap<ResourceLocation, IGuiTheme> themes = new HashMap();
    private final List<ResourceLocation> loadedThemes = new ArrayList<ResourceLocation>();
    private final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private IGuiTheme activeTheme = null;
    private boolean setup = false;

    public ThemeRegistry() {
        PresetTexture.registerTextures(this);
        PresetIcon.registerIcons(this);
        PresetLine.registerLines(this);
        PresetColor.registerColors(this);
        this.setDefaultGui(PresetGUIs.HOME, arg -> new GuiHome(arg.parent));
        this.setDefaultGui(PresetGUIs.EDIT_NBT, arg -> {
            if (arg.value instanceof NBTTagCompound) {
                return new GuiNbtEditor(arg.parent, (NBTTagCompound)arg.value, arg.callback);
            }
            if (arg.value instanceof NBTTagList) {
                return new GuiNbtEditor(arg.parent, (NBTTagList)arg.value, arg.callback);
            }
            return null;
        });
        this.setDefaultGui(PresetGUIs.EDIT_ITEM, arg -> new GuiItemSelection(arg.parent, (BigItemStack)arg.value, arg.callback));
        this.setDefaultGui(PresetGUIs.EDIT_FLUID, arg -> new GuiFluidSelection(arg.parent, (FluidStack)arg.value, arg.callback));
        this.setDefaultGui(PresetGUIs.EDIT_ENTITY, arg -> new GuiEntitySelection(arg.parent, (Entity)arg.value, arg.callback));
        this.setDefaultGui(PresetGUIs.EDIT_TEXT, arg -> new GuiTextEditor(arg.parent, (String)arg.value, arg.callback));
        this.setDefaultGui(PresetGUIs.FILE_EXPLORE, arg -> new GuiFileBrowser(arg.parent, arg.callback, arg.root, arg.filter).allowMultiSelect(arg.multiSelect));
    }

    @Override
    public void registerTheme(IGuiTheme theme) {
        if (theme == null || theme.getID() == null) {
            throw new NullPointerException("Cannot register null theme");
        }
        if (this.themes.containsKey(theme.getID())) {
            throw new IllegalArgumentException("Cannot register duplicate theme: " + theme.getID());
        }
        this.themes.put(theme.getID(), theme);
        if (this.activeTheme == null) {
            this.setup = false;
        }
    }

    @Override
    public void setDefaultTexture(ResourceLocation key, IGuiTexture tex) {
        if (key == null || tex == null) {
            throw new NullPointerException("Tried to register a default theme texture with one or more NULL arguments");
        }
        this.defTextures.put(key, tex);
    }

    @Override
    public void setDefaultLine(ResourceLocation key, IGuiLine line) {
        if (key == null || line == null) {
            throw new NullPointerException("Tried to register a default theme line with one or more NULL arguments");
        }
        this.defLines.put(key, line);
    }

    @Override
    public void setDefaultColor(ResourceLocation key, IGuiColor color) {
        if (key == null || color == null) {
            throw new NullPointerException("Tried to register default theme colour with one or more NULL arguments");
        }
        this.defColors.put(key, color);
    }

    @Override
    public <T> void setDefaultGui(GuiKey<T> key, Function<T, GuiScreen> func) {
        if (key == null || func == null) {
            throw new NullPointerException("Tried to register a default gui with one or more NULL arguments");
        }
        this.defGuis.put(key, func);
    }

    @Override
    public void setTheme(ResourceLocation id) {
        this.setTheme(this.themes.get(id), id);
    }

    @Override
    public IGuiTheme getTheme(ResourceLocation key) {
        if (key == null) {
            return null;
        }
        return this.themes.get(key);
    }

    private void setTheme(IGuiTheme theme, ResourceLocation id) {
        this.activeTheme = theme;
        String string = BQ_Settings.curTheme = id == null ? "" : id.toString();
        if (ConfigHandler.config != null) {
            ConfigHandler.config.get("general", "Theme", "").set(BQ_Settings.curTheme);
            ConfigHandler.config.save();
        } else {
            BetterQuesting.logger.log(Level.WARN, "Unable to save theme setting");
        }
    }

    @Override
    public IGuiTheme getCurrentTheme() {
        if (!this.setup && this.activeTheme == null) {
            this.activeTheme = this.getTheme(new ResourceLocation(BQ_Settings.curTheme));
            this.setup = true;
        }
        return this.activeTheme;
    }

    @Override
    public void loadResourceThemes() {
        this.loadedThemes.forEach(this.themes::remove);
        this.loadedThemes.clear();
        IResourceManager resManager = Minecraft.func_71410_x().func_110442_L();
        for (String domain : resManager.func_135055_a()) {
            List list;
            ResourceLocation res = new ResourceLocation(domain, "bq_themes.json");
            try {
                list = resManager.func_135056_b(res);
            }
            catch (Exception e) {
                continue;
            }
            for (IResource iresource : list) {
                try {
                    InputStreamReader isr = new InputStreamReader(iresource.func_110527_b(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        JsonArray jAry = (JsonArray)this.GSON.fromJson((Reader)isr, JsonArray.class);
                        isr.close();
                        for (int i = 0; i < jAry.size(); ++i) {
                            Object entry2;
                            ResourceTheme resTheme;
                            JsonElement je = jAry.get(i);
                            if (!(je instanceof JsonObject)) {
                                BetterQuesting.logger.log(Level.WARN, "Invalid theme entry at index " + i + " in " + iresource.func_177241_a());
                                continue;
                            }
                            JsonObject jThm = je.getAsJsonObject();
                            if (jThm.has("themeType")) {
                                BetterQuesting.logger.warn("Deprecated legacy theme entry " + i + " in " + iresource.func_177241_a());
                                BetterQuesting.logger.warn("Please convert this to the new format");
                                this.loadLegacy(jThm, domain);
                                continue;
                            }
                            ResourceLocation parentID = !jThm.has("themeParent") ? null : new ResourceLocation(JsonHelper.GetString(jThm, "themeParent", "minecraft:null"));
                            String themeName = JsonHelper.GetString(jThm, "themeName", "Unnamed Theme");
                            String idRaw = JsonHelper.GetString(jThm, "themeID", themeName);
                            if (!(idRaw = idRaw.toLowerCase().trim().replaceAll(" ", "_")).contains(":")) {
                                idRaw = domain + ":" + idRaw;
                            }
                            ResourceLocation themeId = new ResourceLocation(idRaw);
                            int n = 0;
                            while (this.themes.containsKey(themeId)) {
                                themeId = new ResourceLocation(domain, idRaw + n++);
                            }
                            try {
                                resTheme = new ResourceTheme(parentID, themeId, themeName);
                            }
                            catch (Exception e) {
                                BetterQuesting.logger.error("Failed to load theme entry " + i + " in " + iresource.func_177241_a(), (Throwable)e);
                                continue;
                            }
                            JsonObject jsonTextureRoot = JsonHelper.GetObject(jThm, "textures");
                            for (Object entry2 : jsonTextureRoot.entrySet()) {
                                if (!((JsonElement)entry2.getValue()).isJsonObject()) continue;
                                JsonObject joTex = ((JsonElement)entry2.getValue()).getAsJsonObject();
                                ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joTex, "textureType", ""));
                                IFactoryData<IGuiTexture, JsonObject> tFact = ResourceRegistry.INSTANCE.getTexReg().getFactory(typeID);
                                if (tFact == null) {
                                    BetterQuesting.logger.error("Unknown texture type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                IGuiTexture gTex = tFact.loadFromData(joTex);
                                if (gTex == null) {
                                    BetterQuesting.logger.error("Failed to load texture type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                resTheme.setTexture(new ResourceLocation((String)entry2.getKey()), gTex);
                            }
                            JsonObject jsonColourRoot = JsonHelper.GetObject(jThm, "colors");
                            entry2 = jsonColourRoot.entrySet().iterator();
                            while (entry2.hasNext()) {
                                Map.Entry entry3 = (Map.Entry)entry2.next();
                                if (!(entry3.getValue() instanceof JsonObject)) continue;
                                JsonObject joCol = ((JsonElement)entry3.getValue()).getAsJsonObject();
                                ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joCol, "colorType", ""));
                                IFactoryData<IGuiColor, JsonObject> cFact = ResourceRegistry.INSTANCE.getColorReg().getFactory(typeID);
                                if (cFact == null) {
                                    BetterQuesting.logger.error("Unknown color type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                IGuiColor gCol = cFact.loadFromData(joCol);
                                if (gCol == null) {
                                    BetterQuesting.logger.error("Failed to load color type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                resTheme.setColor(new ResourceLocation((String)entry3.getKey()), gCol);
                            }
                            JsonObject jsonLinesRoot = JsonHelper.GetObject(jThm, "lines");
                            for (Map.Entry entry4 : jsonLinesRoot.entrySet()) {
                                if (!(entry4.getValue() instanceof JsonObject)) continue;
                                JsonObject joLine = ((JsonElement)entry4.getValue()).getAsJsonObject();
                                ResourceLocation typeID = new ResourceLocation(JsonHelper.GetString(joLine, "lineType", ""));
                                IFactoryData<IGuiLine, JsonObject> lFact = ResourceRegistry.INSTANCE.getLineReg().getFactory(typeID);
                                if (lFact == null) {
                                    BetterQuesting.logger.error("Unknown line type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                IGuiLine gLine = lFact.loadFromData(joLine);
                                if (gLine == null) {
                                    BetterQuesting.logger.error("Failed to load line type " + typeID + " for theme " + themeName + " in " + iresource.func_177241_a());
                                    continue;
                                }
                                resTheme.setLine(new ResourceLocation((String)entry4.getKey()), gLine);
                            }
                            this.themes.put(resTheme.getID(), resTheme);
                            this.loadedThemes.add(resTheme.getID());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (isr == null) continue;
                        if (throwable != null) {
                            try {
                                isr.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        isr.close();
                    }
                }
                catch (Exception e) {
                    BetterQuesting.logger.error("Error reading bq_themes.json from " + iresource.func_177241_a(), (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    private void loadLegacy(JsonObject json, String domain) {
        IGuiTheme theme = LegacyThemeLoader.INSTANCE.loadTheme(json, domain);
        if (theme == null) {
            BetterQuesting.logger.error("Failed to load legacy theme from " + domain);
            return;
        }
        if (this.themes.containsKey(theme.getID())) {
            BetterQuesting.logger.error("Unable to register legacy resource theme with duplicate ID: " + theme.getID());
        }
        this.themes.put(theme.getID(), theme);
        this.loadedThemes.add(theme.getID());
    }

    @Override
    public IGuiTexture getTexture(ResourceLocation key) {
        if (key == null) {
            return NULL_TEXTURE;
        }
        IGuiTexture tex = null;
        if (this.getCurrentTheme() != null) {
            tex = this.activeTheme.getTexture(key);
        }
        if (tex == null) {
            tex = this.defTextures.get(key);
        }
        return tex == null ? NULL_TEXTURE : tex;
    }

    @Override
    public IGuiLine getLine(ResourceLocation key) {
        if (key == null) {
            return NULL_LINE;
        }
        IGuiLine line = null;
        if (this.getCurrentTheme() != null) {
            line = this.activeTheme.getLine(key);
        }
        if (line == null) {
            line = this.defLines.get(key);
        }
        return line == null ? NULL_LINE : line;
    }

    @Override
    public IGuiColor getColor(ResourceLocation key) {
        if (key == null) {
            return NULL_COLOR;
        }
        IGuiColor color = null;
        if (this.getCurrentTheme() != null) {
            color = this.activeTheme.getColor(key);
        }
        if (color == null) {
            color = this.defColors.get(key);
        }
        return color == null ? NULL_COLOR : color;
    }

    @Override
    public <T> GuiScreen getGui(GuiKey<T> key, T args) {
        if (key == null) {
            return null;
        }
        Function<Object, GuiScreen> func = null;
        if (this.getCurrentTheme() != null) {
            func = this.activeTheme.getGui(key);
        }
        if (func == null) {
            func = this.defGuis.get(key);
        }
        return func == null ? null : func.apply(args);
    }

    @Override
    public List<IGuiTheme> getAllThemes() {
        return new ArrayList<IGuiTheme>(this.themes.values());
    }

    @Override
    public ResourceLocation[] getKnownTextures() {
        return this.defTextures.keySet().toArray(new ResourceLocation[0]);
    }

    @Override
    public ResourceLocation[] getKnownColors() {
        return this.defColors.keySet().toArray(new ResourceLocation[0]);
    }

    @Override
    public ResourceLocation[] getKnownLines() {
        return this.defLines.keySet().toArray(new ResourceLocation[0]);
    }

    @Override
    public GuiKey[] getKnownGuis() {
        return this.defGuis.keySet().toArray(new GuiKey[0]);
    }
}

