/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.party;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelPlayerPortrait;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.party.GuiPartyManage;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.LifeDatabase;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.input.Keyboard;

public class GuiPartyCreate
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private PanelTextField<String> flName;
    private CanvasScrolling invitePanel;
    private PanelVScrollBar inviteScroll;
    private UUID playerID;

    public GuiPartyCreate(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void refreshGui() {
        IParty curParty = PartyManager.INSTANCE.getUserParty(this.playerID);
        if (curParty != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyManage(this.parent));
            return;
        }
        this.refreshInvites();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        this.playerID = QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g);
        IParty curParty = PartyManager.INSTANCE.getUserParty(this.playerID);
        if (curParty != null) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiPartyManage(this.parent));
            return;
        }
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.party_none", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        CanvasEmpty cvLeftHalf = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(16, 32, 8, 32), 0));
        cvBackground.addPanel(cvLeftHalf);
        PanelPlayerPortrait pnPortrait = new PanelPlayerPortrait(new GuiTransform(GuiAlign.TOP_CENTER, -32, 0, 64, 64, 0), (AbstractClientPlayer)this.field_146297_k.field_71439_g).setDepth(-16.0f);
        cvLeftHalf.addPanel(pnPortrait);
        cvLeftHalf.addPanel(new PanelGeneric(new GuiTransform(GuiAlign.TOP_CENTER, 16, 48, 24, 24, 0), new ItemTexture(new BigItemStack(BetterQuesting.extraLife, LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID((EntityPlayer)this.field_146297_k.field_71439_g))), true, true).setDepth(32.0f)));
        PanelTextBox txName = new PanelTextBox(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -44, 16, 28), 0), QuestTranslation.translate("betterquesting.gui.name", new Object[0]));
        txName.setColor(PresetColor.TEXT_HEADER.getColor());
        cvLeftHalf.addPanel(txName);
        this.flName = new PanelTextField<String>(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -32, 16, 16), 0), "New Party", FieldFilterString.INSTANCE);
        cvLeftHalf.addPanel(this.flName);
        PanelButton btnCreate = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_EDGE, new GuiPadding(16, -16, 16, 0), 0), 1, QuestTranslation.translate("betterquesting.btn.party_new", new Object[0]));
        cvLeftHalf.addPanel(btnCreate);
        CanvasEmpty cvRightHalf = new CanvasEmpty(new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 32, 16, 32), 0));
        cvBackground.addPanel(cvRightHalf);
        this.invitePanel = new CanvasScrolling(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 16, 8, 0), 0));
        cvRightHalf.addPanel(this.invitePanel);
        this.inviteScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 16, 0, 0), 0));
        cvRightHalf.addPanel(this.inviteScroll);
        this.invitePanel.setScrollDriverY(this.inviteScroll);
        PanelTextBox txInvite = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 0, 0, -16), 0), QuestTranslation.translate("betterquesting.gui.party_invites", new Object[0])).setAlignment(1);
        txInvite.setColor(PresetColor.TEXT_HEADER.getColor());
        cvRightHalf.addPanel(txInvite);
        this.refreshInvites();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 32, 0, 0, 0);
        ls0.setParent(cvBackground.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -32, 0, 0, 0);
        le0.setParent(cvBackground.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        cvBackground.addPanel(paLine0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("action", EnumPacketAction.ADD.ordinal());
            tags.func_74778_a("name", this.flName.getRawText());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("action", EnumPacketAction.JOIN.ordinal());
            tags.func_74768_a("partyID", ((Integer)((PanelButtonStorage)btn).getStoredValue()).intValue());
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.PARTY_EDIT.GetLocation(), tags));
        }
    }

    private void refreshInvites() {
        int cvWidth = this.invitePanel.getTransform().getWidth();
        List<Integer> invites = PartyManager.INSTANCE.getPartyInvites(this.playerID);
        int elSize = RenderUtils.getStringWidth("...", this.field_146297_k.field_71466_p);
        for (int i = 0; i < invites.size(); ++i) {
            Integer pid = invites.get(i);
            IParty party = (IParty)PartyManager.INSTANCE.getValue(pid);
            if (party == null) continue;
            PanelButtonStorage<Integer> btnJoin = new PanelButtonStorage<Integer>(new GuiRectangle(cvWidth - 50, i * 16, 50, 16, 0), 2, QuestTranslation.translate("betterquesting.btn.party_join", new Object[0]), pid);
            this.invitePanel.addPanel(btnJoin);
            String pName = party.getName();
            if (RenderUtils.getStringWidth(pName, this.field_146297_k.field_71466_p) > cvWidth - 58) {
                pName = this.field_146297_k.field_71466_p.func_78269_a(pName, cvWidth - 58 - elSize) + "...";
            }
            PanelTextBox txPartyName = new PanelTextBox(new GuiRectangle(0, i * 16 + 4, cvWidth - 58, 12, 0), pName);
            txPartyName.setColor(PresetColor.TEXT_MAIN.getColor());
            this.invitePanel.addPanel(txPartyName);
        }
        this.inviteScroll.setActive(this.invitePanel.getScrollBounds().getHeight() > 0);
    }
}

