/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.client.gui.misc.INeedsRefresh;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.editors.GuiQuestEditor;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.vector.Vector4f;

public class GuiQuest
extends GuiScreenCanvas
implements IPEventListener,
INeedsRefresh {
    private final int questID;
    private IQuest quest;
    private PanelButton btnTaskLeft;
    private PanelButton btnTaskRight;
    private PanelButton btnRewardLeft;
    private PanelButton btnRewardRight;
    private PanelButton btnDetect;
    private PanelButton btnClaim;
    private PanelTextBox titleReward;
    private PanelTextBox titleTask;
    private CanvasEmpty cvInner;
    private IGuiRect rectReward;
    private IGuiRect rectTask;
    private IGuiPanel pnReward;
    private IGuiPanel pnTask;
    private int rewardIndex = 0;
    private int taskIndex = 0;

    public GuiQuest(GuiScreen parent, int questID) {
        super(parent);
        this.questID = questID;
    }

    @Override
    public void initPanel() {
        PanelVScrollBar paDescScroll;
        PanelTextBox paDesc;
        CanvasScrolling cvDesc;
        super.initPanel();
        this.quest = (IQuest)QuestDatabase.INSTANCE.getValue(this.questID);
        if (this.quest == null) {
            this.field_146297_k.func_147108_a(this.parent);
            return;
        }
        PEventBroadcaster.INSTANCE.register((IPEventListener)this, PEventButton.class);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        PanelTextBox panTxt = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.NAME), new Object[0])).setAlignment(1);
        panTxt.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(panTxt);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)this.field_146297_k.field_71439_g)) {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 100, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, -16, 100, 16, 0), 1, QuestTranslation.translate("betterquesting.btn.edit", new Object[0])));
        } else {
            cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        }
        this.cvInner = new CanvasEmpty(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 32, 16, 24), 0));
        cvBackground.addPanel(this.cvInner);
        if (this.quest.getRewards().size() > 0) {
            cvDesc = new CanvasScrolling(new GuiTransform(new Vector4f(0.0f, 0.0f, 0.5f, 0.5f), new GuiPadding(0, 0, 16, 16), 0));
            this.cvInner.addPanel(cvDesc);
            paDesc = new PanelTextBox(new GuiRectangle(0, 0, cvDesc.getTransform().getWidth(), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.DESC), new Object[0]), true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            cvDesc.addCulledPanel(paDesc, false);
            paDescScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.quickAnchor(GuiAlign.TOP_CENTER, GuiAlign.MID_CENTER), new GuiPadding(-16, 0, 8, 16), 0));
            this.cvInner.addPanel(paDescScroll);
            cvDesc.setScrollDriverY(paDescScroll);
            paDescScroll.setEnabled(cvDesc.getScrollBounds().getHeight() > 0);
            this.btnClaim = new PanelButton(new GuiTransform(new Vector4f(0.0f, 1.0f, 0.5f, 1.0f), new GuiPadding(16, -16, 24, 0), 0), 6, QuestTranslation.translate("betterquesting.btn.claim", new Object[0]));
            this.btnClaim.setActive(false);
            this.cvInner.addPanel(this.btnClaim);
            this.btnRewardLeft = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_LEFT, new GuiPadding(0, -16, -16, 0), 0), 2, "<");
            this.btnRewardLeft.setActive(this.rewardIndex > 0);
            this.cvInner.addPanel(this.btnRewardLeft);
            this.btnRewardRight = new PanelButton(new GuiTransform(new Vector4f(0.5f, 1.0f, 0.5f, 1.0f), new GuiPadding(-24, -16, 8, 0), 0), 3, ">");
            this.btnRewardRight.setActive(this.rewardIndex < this.quest.getRewards().size() - 1);
            this.cvInner.addPanel(this.btnRewardRight);
            this.rectReward = new GuiTransform(new Vector4f(0.0f, 0.5f, 0.5f, 1.0f), new GuiPadding(0, 0, 8, 16), 0);
            this.rectReward.setParent(this.cvInner.getTransform());
            this.titleReward = new PanelTextBox(new GuiTransform(new Vector4f(0.0f, 0.5f, 0.5f, 0.5f), new GuiPadding(0, -16, 8, 0), 0), "?");
            this.titleReward.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
            this.cvInner.addPanel(this.titleReward);
            this.refreshRewardPanel();
        } else {
            cvDesc = new CanvasScrolling(new GuiTransform(GuiAlign.HALF_LEFT, new GuiPadding(0, 0, 16, 0), 0));
            this.cvInner.addPanel(cvDesc);
            paDesc = new PanelTextBox(new GuiRectangle(0, 0, cvDesc.getTransform().getWidth(), 0), QuestTranslation.translate(this.quest.getProperty(NativeProps.DESC), new Object[0]), true);
            paDesc.setColor(PresetColor.TEXT_MAIN.getColor());
            cvDesc.addCulledPanel(paDesc, false);
            paDescScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.quickAnchor(GuiAlign.TOP_CENTER, GuiAlign.BOTTOM_CENTER), new GuiPadding(-16, 0, 8, 0), 0));
            this.cvInner.addPanel(paDescScroll);
            cvDesc.setScrollDriverY(paDescScroll);
            paDescScroll.setEnabled(cvDesc.getScrollBounds().getHeight() > 0);
        }
        this.btnDetect = new PanelButton(new GuiTransform(new Vector4f(0.5f, 1.0f, 1.0f, 1.0f), new GuiPadding(24, -16, 16, 0), 0), 7, QuestTranslation.translate("betterquesting.btn.detect_submit", new Object[0]));
        this.btnDetect.setActive(false);
        this.cvInner.addPanel(this.btnDetect);
        this.btnTaskLeft = new PanelButton(new GuiTransform(new Vector4f(0.5f, 1.0f, 0.5f, 1.0f), new GuiPadding(8, -16, -24, 0), 0), 4, "<");
        this.btnTaskLeft.setActive(this.taskIndex > 0);
        this.cvInner.addPanel(this.btnTaskLeft);
        this.btnTaskRight = new PanelButton(new GuiTransform(GuiAlign.BOTTOM_RIGHT, new GuiPadding(-16, -16, 0, 0), 0), 5, ">");
        this.btnTaskRight.setActive(this.taskIndex < this.quest.getTasks().size() - 1);
        this.cvInner.addPanel(this.btnTaskRight);
        this.rectTask = new GuiTransform(GuiAlign.HALF_RIGHT, new GuiPadding(8, 16, 0, 16), 0);
        this.rectTask.setParent(this.cvInner.getTransform());
        this.titleTask = new PanelTextBox(new GuiTransform(new Vector4f(0.5f, 0.0f, 1.0f, 0.0f), new GuiPadding(8, 0, 0, -16), 0), "?");
        this.titleTask.setColor(PresetColor.TEXT_HEADER.getColor()).setAlignment(1);
        this.cvInner.addPanel(this.titleTask);
        this.refreshTaskPanel();
        GuiTransform ls0 = new GuiTransform(GuiAlign.TOP_CENTER, 0, 0, 0, 0, 0);
        ls0.setParent(this.cvInner.getTransform());
        GuiTransform le0 = new GuiTransform(GuiAlign.BOTTOM_CENTER, 0, 0, 0, 0, 0);
        le0.setParent(this.cvInner.getTransform());
        PanelLine paLine0 = new PanelLine(ls0, le0, PresetLine.GUI_DIVIDER.getLine(), 1, PresetColor.GUI_DIVIDER.getColor(), 1);
        this.cvInner.addPanel(paLine0);
    }

    @Override
    public void refreshGui() {
        this.refreshTaskPanel();
        this.refreshRewardPanel();
        this.updateButtons();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (super.onMouseClick(mx, my, click)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        if (super.onMouseScroll(mx, my, scroll)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        if (super.onKeyTyped(c, keycode)) {
            this.updateButtons();
            return true;
        }
        return false;
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiQuestEditor(this, this.questID));
        } else if (btn.getButtonID() == 2) {
            this.rewardIndex = MathHelper.func_76125_a((int)(this.rewardIndex - 1), (int)0, (int)(this.quest.getRewards().size() - 1));
            this.refreshRewardPanel();
        } else if (btn.getButtonID() == 3) {
            this.rewardIndex = MathHelper.func_76125_a((int)(this.rewardIndex + 1), (int)0, (int)(this.quest.getRewards().size() - 1));
            this.refreshRewardPanel();
        } else if (btn.getButtonID() == 4) {
            this.taskIndex = MathHelper.func_76125_a((int)(this.taskIndex - 1), (int)0, (int)(this.quest.getTasks().size() - 1));
            this.refreshTaskPanel();
        } else if (btn.getButtonID() == 5) {
            this.taskIndex = MathHelper.func_76125_a((int)(this.taskIndex + 1), (int)0, (int)(this.quest.getTasks().size() - 1));
            this.refreshTaskPanel();
        } else if (btn.getButtonID() == 6) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("questID", QuestDatabase.INSTANCE.getID(this.quest));
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.CLAIM.GetLocation(), tags));
        } else if (btn.getButtonID() == 7) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("questID", QuestDatabase.INSTANCE.getID(this.quest));
            PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.DETECT.GetLocation(), tags));
        }
    }

    private void refreshRewardPanel() {
        if (this.pnReward != null) {
            this.cvInner.removePanel(this.pnReward);
        }
        if (this.rewardIndex < 0 || this.rewardIndex >= this.quest.getRewards().size()) {
            if (this.titleReward != null) {
                this.titleReward.setText("?");
                this.titleReward.setEnabled(false);
            }
            this.updateButtons();
            return;
        }
        if (this.rectReward == null) {
            this.initPanel();
            return;
        }
        IReward rew = (IReward)this.quest.getRewards().getEntries()[this.rewardIndex].getValue();
        this.pnReward = rew.getRewardGui(this.rectReward, this.quest);
        if (this.pnReward != null) {
            this.cvInner.addPanel(this.pnReward);
        }
        if (this.titleReward != null) {
            this.titleReward.setText(QuestTranslation.translate(rew.getUnlocalisedName(), new Object[0]));
            this.titleReward.setEnabled(true);
        }
        this.updateButtons();
    }

    private void refreshTaskPanel() {
        if (this.pnTask != null) {
            this.cvInner.removePanel(this.pnTask);
        }
        if (this.taskIndex < 0 || this.taskIndex >= this.quest.getTasks().size()) {
            this.titleTask.setText("?");
            this.titleTask.setEnabled(false);
            this.updateButtons();
            return;
        }
        ITask tsk = (ITask)this.quest.getTasks().getEntries()[this.taskIndex].getValue();
        this.pnTask = tsk.getTaskGui(this.rectTask, this.quest);
        if (this.pnTask != null) {
            this.cvInner.addPanel(this.pnTask);
        }
        this.titleTask.setText(QuestTranslation.translate(tsk.getUnlocalisedName(), new Object[0]));
        this.titleTask.setEnabled(true);
        this.updateButtons();
    }

    private void updateButtons() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.btnRewardLeft != null && this.btnRewardRight != null && this.btnClaim != null) {
            this.btnRewardLeft.setActive(this.rewardIndex > 0);
            this.btnRewardRight.setActive(this.rewardIndex < this.quest.getRewards().size() - 1);
            this.btnClaim.setActive(this.quest.getRewards().size() > 0 && this.quest.canClaim((EntityPlayer)mc.field_71439_g));
        }
        if (this.btnTaskLeft != null && this.btnTaskRight != null && this.btnDetect != null) {
            this.btnTaskLeft.setActive(this.taskIndex > 0);
            this.btnTaskRight.setActive(this.taskIndex < this.quest.getTasks().size() - 1);
            this.btnDetect.setActive(this.quest.canSubmit((EntityPlayer)mc.field_71439_g));
        }
    }
}

