/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.events;

import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventEntry;
import betterquesting.api2.client.gui.events.PanelEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PEventBroadcaster {
    public static PEventBroadcaster INSTANCE = new PEventBroadcaster();
    private final HashMap<Class<? extends PanelEvent>, PEventEntry<? extends PanelEvent>> entryList = new HashMap();

    public void register(IPEventListener l, Class<? extends PanelEvent>[] types) {
        if (l == null || types == null) {
            return;
        }
        for (Class<? extends PanelEvent> t : types) {
            this.register(l, t);
        }
    }

    public <T extends PanelEvent> void register(IPEventListener l, Class<T> type) {
        if (l == null || type == null) {
            return;
        }
        PEventEntry<PanelEvent> pe = this.entryList.get(type);
        if (pe == null) {
            pe = new PEventEntry<T>(type);
            this.entryList.put(type, pe);
        }
        pe.registerListener(l);
    }

    public void unregister(IPEventListener l) {
        for (Map.Entry<Class<? extends PanelEvent>, PEventEntry<? extends PanelEvent>> e : this.entryList.entrySet()) {
            e.getValue().unregisterListener(l);
        }
    }

    public boolean postEvent(PanelEvent event) {
        for (Map.Entry<Class<? extends PanelEvent>, PEventEntry<? extends PanelEvent>> e : this.entryList.entrySet()) {
            e.getValue().fire(event);
        }
        return event.canCancel() && event.isCancelled();
    }

    @SubscribeEvent
    public void onGuiOpened(GuiOpenEvent event) {
        this.entryList.clear();
    }
}

