/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.tilentity;

import info.u_team.u_team_core.tileentity.UTileEntity;
import info.u_team.useful_railroads.config.CommonConfig;
import info.u_team.useful_railroads.inventory.InvWrapperOnlyInsert;
import java.util.HashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityRailTeleport
extends UTileEntity
implements IInventory,
ITickable {
    protected HashMap<String, Integer> fuelList;
    protected int fuel = 0;
    protected int needFuel = 0;
    protected int dimension = 0;
    protected BlockPos teleportPos = new BlockPos(0, -2000000001, 0);
    protected NonNullList<ItemStack> itemstacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    protected InvWrapper inventoryWrapper = new InvWrapperOnlyInsert(this);
    @SideOnly(value=Side.CLIENT)
    private int client_dim;
    @SideOnly(value=Side.CLIENT)
    private int client_x;
    @SideOnly(value=Side.CLIENT)
    private int client_y;
    @SideOnly(value=Side.CLIENT)
    private int client_z;
    @SideOnly(value=Side.CLIENT)
    private int client_fuel;
    @SideOnly(value=Side.CLIENT)
    private int client_needFuel;

    public TileEntityRailTeleport() {
        this.fuelList = CommonConfig.teleportrail.fuel;
    }

    public void readNBT(NBTTagCompound compound) {
        this.fuel = compound.func_74762_e("fuel");
        this.needFuel = compound.func_74762_e("need_fuel");
        this.dimension = compound.func_74762_e("tel_dim");
        int x = compound.func_74762_e("tel_x");
        int y = compound.func_74762_e("tel_y");
        int z = compound.func_74762_e("tel_z");
        this.teleportPos = new BlockPos(x, y, z);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.itemstacks);
    }

    public void writeNBT(NBTTagCompound compound) {
        compound.func_74768_a("fuel", this.fuel);
        compound.func_74768_a("need_fuel", this.needFuel);
        compound.func_74768_a("tel_dim", this.dimension);
        compound.func_74768_a("tel_x", this.teleportPos.func_177958_n());
        compound.func_74768_a("tel_y", this.teleportPos.func_177956_o());
        compound.func_74768_a("tel_z", this.teleportPos.func_177952_p());
        ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.itemstacks, (boolean)false);
    }

    public void setLocation(int dimension, BlockPos teleportPos) {
        this.dimension = dimension;
        this.teleportPos = teleportPos;
        this.needFuel = this.calculateFuel();
    }

    public void setFuel(int fuel) {
        this.fuel = fuel;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void teleport(World world, EntityMinecart cart, BlockPos pos) {
        Entity entity;
        cart.field_70159_w = 0.0;
        cart.field_70181_x = 0.0;
        cart.field_70179_y = 0.0;
        Entity entity3 = entity = cart.func_184188_bt().isEmpty() ? null : (Entity)cart.func_184188_bt().get(0);
        if (this.teleportPos.func_177956_o() < -2000000000) {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "You have not setup the rail yet."), true);
            }
            return;
        }
        if (this.fuel < this.needFuel) {
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Fuel missing! Need: " + TextFormatting.GOLD + this.needFuel + TextFormatting.DARK_RED + ". Have: " + TextFormatting.GOLD + this.fuel), true);
            }
            return;
        }
        this.fuel -= this.needFuel;
        int currentDim = world.field_73011_w.getDimension();
        if (currentDim == this.dimension) {
            cart.func_70012_b((double)this.teleportPos.func_177958_n(), (double)this.teleportPos.func_177956_o(), (double)this.teleportPos.func_177952_p(), cart.field_70177_z, cart.field_70125_A);
        } else {
            ITeleporter teleporter = (world2, entity2, yaw) -> entity2.func_70012_b((double)this.teleportPos.func_177958_n(), (double)this.teleportPos.func_177956_o(), (double)this.teleportPos.func_177952_p(), entity2.field_70177_z, entity2.field_70125_A);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            PlayerList list = server.func_184103_al();
            if (entity != null) {
                if (entity instanceof EntityPlayerMP) {
                    list.transferPlayerToDimension((EntityPlayerMP)entity, this.dimension, teleporter);
                } else {
                    list.transferEntityToWorld(entity, currentDim, server.func_71218_a(currentDim), server.func_71218_a(this.dimension), teleporter);
                }
            }
            list.transferEntityToWorld((Entity)cart, currentDim, server.func_71218_a(currentDim), server.func_71218_a(this.dimension), teleporter);
        }
        world.func_175704_b(pos, pos);
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
        world.func_180497_b(pos, this.field_145854_h, 0, 0);
        this.func_70296_d();
    }

    private int calculateFuel() {
        if (!this.func_145830_o()) {
            return 0;
        }
        int needFuel = 0;
        int currentDim = this.field_145850_b.field_73011_w.getDimension();
        if (currentDim != this.dimension) {
            needFuel += 100;
        }
        double calculatedDistance = Math.log(this.field_174879_c.func_177951_i((Vec3i)this.teleportPos)) / Math.log(5.0);
        calculatedDistance *= calculatedDistance;
        return needFuel += MathHelper.func_76128_c((double)calculatedDistance);
    }

    public void func_73660_a() {
        ItemStack stack = (ItemStack)this.itemstacks.get(0);
        if (stack.func_190926_b()) {
            return;
        }
        String registryname = stack.func_77973_b().getRegistryName().toString();
        int value = this.fuelList.getOrDefault(registryname, 0);
        if (value > 0) {
            this.fuel += value * stack.func_190916_E();
            this.itemstacks.clear();
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.field_145854_h, 0, 0);
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String registryname = stack.func_77973_b().getRegistryName().toString();
        return this.fuelList.getOrDefault(registryname, 0) > 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public String func_70005_c_() {
        return "railteleport";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.itemstacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemstacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.itemstacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.itemstacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.itemstacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemstacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174888_l() {
        this.itemstacks.clear();
    }

    public int getDimension() {
        return this.dimension;
    }

    public BlockPos getTeleportPos() {
        return this.teleportPos;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientDim() {
        return this.client_dim;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientX() {
        return this.client_x;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientY() {
        return this.client_y;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientZ() {
        return this.client_z;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientFuel() {
        return this.client_fuel;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientNeedFuel() {
        return this.client_needFuel;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.client_dim = value;
                break;
            }
            case 1: {
                this.client_x = value;
                break;
            }
            case 2: {
                this.client_y = value;
                break;
            }
            case 3: {
                this.client_z = value;
                break;
            }
            case 4: {
                this.client_fuel = value;
                break;
            }
            case 5: {
                this.client_needFuel = value;
            }
        }
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.dimension;
            }
            case 1: {
                return this.teleportPos.func_177958_n();
            }
            case 2: {
                return this.teleportPos.func_177956_o();
            }
            case 3: {
                return this.teleportPos.func_177952_p();
            }
            case 4: {
                return this.fuel;
            }
            case 5: {
                return this.needFuel;
            }
        }
        return 0;
    }

    public int func_174890_g() {
        return 6;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }
}

