/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlocks;
import twilightforest.world.feature.TFTreeGenerator;

public class TFGenSmallTwilightOak
extends TFTreeGenerator {
    protected final int minTreeHeight;

    public TFGenSmallTwilightOak(boolean notify) {
        this(notify, 4);
    }

    public TFGenSmallTwilightOak(boolean notify, int minHeight) {
        super(notify);
        this.minTreeHeight = minHeight;
        this.treeState = TFBlocks.twilight_log.func_176223_P();
        this.branchState = this.treeState.func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.twilight_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.rootState = TFBlocks.root.func_176223_P();
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int height = random.nextInt(3) + this.minTreeHeight;
        boolean allClear = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            Block blockID;
            int cz;
            int width;
            for (int cy = pos.func_177956_o(); cy <= pos.func_177956_o() + 1 + height; ++cy) {
                width = 1;
                if (cy == pos.func_177956_o()) {
                    width = 0;
                }
                if (cy >= pos.func_177956_o() + 1 + height - 2) {
                    width = 2;
                }
                for (int cx = pos.func_177958_n() - width; cx <= pos.func_177958_n() + width && allClear; ++cx) {
                    for (cz = pos.func_177952_p() - width; cz <= pos.func_177952_p() + width && allClear; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            BlockPos cPos = new BlockPos(cx, cy, cz);
                            IBlockState block = world.func_180495_p(cPos);
                            blockID = block.func_177230_c();
                            if (blockID == Blocks.field_150350_a || blockID.isLeaves(block, (IBlockAccess)world, cPos) || blockID == Blocks.field_150349_c || blockID == Blocks.field_150346_d || blockID.isWood((IBlockAccess)world, cPos)) continue;
                            allClear = false;
                            continue;
                        }
                        allClear = false;
                    }
                }
            }
            if (!allClear) {
                return false;
            }
            Block blockUsing = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            if ((blockUsing == Blocks.field_150349_c || blockUsing == Blocks.field_150346_d) && pos.func_177956_o() < 256 - height - 1) {
                this.func_175903_a(world, pos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
                width = 3;
                int var18 = 0;
                for (cz = pos.func_177956_o() - width + height; cz <= pos.func_177956_o() + height; ++cz) {
                    int number = cz - (pos.func_177956_o() + height);
                    int treeWidth = var18 + 1 - number / 2;
                    for (int tx = pos.func_177958_n() - treeWidth; tx <= pos.func_177958_n() + treeWidth; ++tx) {
                        int var15 = tx - pos.func_177958_n();
                        for (int tz = pos.func_177952_p() - treeWidth; tz <= pos.func_177952_p() + treeWidth; ++tz) {
                            int var17 = tz - pos.func_177952_p();
                            BlockPos tPos = new BlockPos(tx, cz, tz);
                            IBlockState state = world.func_180495_p(tPos);
                            if (Math.abs(var15) == treeWidth && Math.abs(var17) == treeWidth && (random.nextInt(2) == 0 || number == 0) || !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, tPos)) continue;
                            this.func_175903_a(world, tPos, this.leafState);
                        }
                    }
                }
                for (cz = 0; cz < height; ++cz) {
                    BlockPos cPos = pos.func_177981_b(cz);
                    IBlockState block = world.func_180495_p(cPos);
                    blockID = block.func_177230_c();
                    if (blockID != Blocks.field_150350_a && !blockID.isLeaves(block, (IBlockAccess)world, cPos)) continue;
                    this.func_175903_a(world, cPos, this.treeState);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

