/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.world.WorldHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ModTileEntity
extends TileEntity {
    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        BlockPos position = this.func_174877_v();
        if (this != this.getTile(position)) {
            return false;
        }
        return entityplayer.func_70092_e((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return false;
    }

    public boolean openGui(Object mod, EntityPlayer player, int guiId) {
        player.openGui(mod, guiId, this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        return true;
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return null;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.syncDataFrom(data, SyncReason.FullSync);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        this.syncDataTo(super.func_189515_b(data), SyncReason.FullSync);
        return data;
    }

    public void handleUpdateTag(NBTTagCompound data) {
        super.func_145839_a(data);
        this.syncDataFrom(data, SyncReason.NetworkUpdate);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound data = super.func_189517_E_();
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return data;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.syncDataFrom(packet.func_148857_g(), SyncReason.NetworkUpdate);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.syncDataTo(data, SyncReason.NetworkUpdate);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, data);
    }

    protected abstract void syncDataFrom(NBTTagCompound var1, SyncReason var2);

    protected abstract void syncDataTo(NBTTagCompound var1, SyncReason var2);

    public void markChunkDirty() {
        this.func_145831_w().func_175646_b(this.func_174877_v(), (TileEntity)this);
    }

    public void callNeighborBlockChange() {
        WorldHelper.notifyNeighborsOfStateChange(this.func_145831_w(), this.func_174877_v(), this.func_145838_q());
    }

    @Deprecated
    public void callNeighborTileChange() {
    }

    public void notifyBlockUpdate() {
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), null, null);
    }

    public void notifyBlockUpdate(IBlockState oldState, IBlockState newState) {
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), oldState, newState);
    }

    public void nofityTileEntityUpdate() {
        this.func_70296_d();
        WorldHelper.notifyBlockUpdate(this.func_145831_w(), this.func_174877_v(), null, null);
    }

    @Nullable
    protected TileEntity getTile(@Nonnull BlockPos position) {
        return WorldHelper.getTile((IBlockAccess)this.func_145831_w(), position);
    }

    @Nullable
    protected TileEntity getTile(@Nonnull EnumFacing facing) {
        return WorldHelper.getTile((IBlockAccess)this.func_145831_w(), this.func_174877_v().func_177972_a(facing));
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;

    }
}

