/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;

public final class RenderHelper {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void renderItemModel(ItemStack itemStack, IBakedModel model, ItemCameraTransforms.TransformType transform, boolean leftHanded, boolean renderEffect) {
        if (!itemStack.func_190926_b()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179108_z();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.renderItemModelCustom(itemStack, model, transform, leftHanded, renderEffect);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179133_A();
            GlStateManager.func_179084_k();
        }
    }

    public static void renderItemModelCustom(ItemStack itemStack, IBakedModel model, ItemCameraTransforms.TransformType transform, boolean leftHanded, boolean renderEffect) {
        if (!itemStack.func_190926_b()) {
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179094_E();
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transform, (boolean)leftHanded);
            RenderHelper.renderItem(itemStack, model, renderEffect);
            GlStateManager.func_179121_F();
            textureManager.func_110577_a(TextureMap.field_110575_b);
            textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
    }

    public static void renderItem(ItemStack stack, IBakedModel model, boolean renderEffect) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                RenderHelper.renderModel(model, stack);
                if (renderEffect && stack.func_77962_s()) {
                    RenderHelper.renderEffect(model);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void renderModel(IBakedModel model, ItemStack stack) {
        RenderHelper.renderModel(model, -1, stack);
    }

    public static void renderModel(IBakedModel model, int color) {
        RenderHelper.renderModel(model, color, ItemStack.field_190927_a);
    }

    public static void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            List quads = model.func_188616_a(null, enumfacing, 0L);
            RenderHelper.renderQuads(bufferbuilder, quads, color, stack);
        }
        List quads = model.func_188616_a(null, null, 0L);
        RenderHelper.renderQuads(bufferbuilder, quads, color, stack);
        tessellator.func_78381_a();
    }

    public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = RenderHelper.getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static ItemColors getItemColors() {
        return Minecraft.func_71410_x().getItemColors();
    }

    public static void renderEffect(IBakedModel model) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.renderModel(model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private RenderHelper() {
    }
}

