/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.spi;

import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public abstract class TileDataBase
implements ITileData {
    private final int updateInterval;
    private int updateCounter;
    private boolean dirty;
    private boolean forceUpdate;
    private List<IChangeObserver> changeObservers;

    protected TileDataBase(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public void addChangeObserver(IChangeObserver observer) {
        if (this.changeObservers == null) {
            this.changeObservers = new ArrayList<IChangeObserver>(1);
        }
        this.changeObservers.add(observer);
    }

    @Override
    public void setDirty(boolean dirty) {
        boolean changed = this.dirty != dirty;
        this.dirty = dirty;
        if (this.changeObservers != null && changed) {
            for (int i = 0; i < this.changeObservers.size(); ++i) {
                this.changeObservers.get(i).onDirtyStateChanged(this);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty && this.updateCounter == 0;
    }

    @Override
    public void forceUpdate() {
        this.forceUpdate = true;
    }

    @Override
    public void update() {
        if (this.forceUpdate) {
            this.updateCounter = 0;
            this.forceUpdate = false;
        } else {
            ++this.updateCounter;
            if (this.updateCounter >= this.updateInterval) {
                this.updateCounter = 0;
            }
        }
    }

    public static interface IChangeObserver<D extends TileDataBase> {
        public void onDirtyStateChanged(D var1);

        public static class OnDirtyMarkTileDirty<D extends TileDataBase>
        implements IChangeObserver<D> {
            private final TileEntity tile;

            public OnDirtyMarkTileDirty(TileEntity tile) {
                this.tile = tile;
            }

            @Override
            public void onDirtyStateChanged(D data) {
                if (((TileDataBase)data).isDirty()) {
                    this.tile.func_70296_d();
                }
            }
        }
    }
}

