/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.inventory;

import com.codetaylor.mc.athenaeum.inventory.IObservableFluidTank;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ObservableFluidTank
extends FluidTank
implements IObservableFluidTank {
    private List<IObservableFluidTank.IContentsChangedEventHandler> eventHandlerList = new ArrayList<IObservableFluidTank.IContentsChangedEventHandler>();

    public ObservableFluidTank(int capacity) {
        super(capacity);
    }

    public ObservableFluidTank(@Nullable FluidStack fluidStack, int capacity) {
        super(fluidStack, capacity);
    }

    public ObservableFluidTank(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    @Override
    public void addObserver(IObservableFluidTank.IContentsChangedEventHandler handler) {
        this.eventHandlerList.add(handler);
    }

    public int fillInternal(FluidStack resource, boolean doFill) {
        int amount = super.fillInternal(resource, doFill);
        if (amount > 0 && doFill) {
            this.onContentsChanged(amount);
        }
        return amount;
    }

    @Nullable
    public FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack fluidStack = super.drainInternal(maxDrain, doDrain);
        if (fluidStack != null && doDrain) {
            this.onContentsChanged(-fluidStack.amount);
        }
        return fluidStack;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.fluid != null && this.fluid.amount > capacity) {
            this.drainInternal(this.fluid.amount - capacity, true);
        }
    }

    protected void onContentsChanged(int amount) {
        if (amount != 0 && !this.eventHandlerList.isEmpty()) {
            for (IObservableFluidTank.IContentsChangedEventHandler handler : this.eventHandlerList) {
                handler.onContentsChanged(this, amount);
            }
        }
    }
}

