/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.inventory;

import com.codetaylor.mc.athenaeum.inventory.ObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class DynamicStackHandler
extends ObservableStackHandler
implements ITileDataItemStackHandler {
    public DynamicStackHandler(int initialSize) {
        super(1);
        this.stacks = new ItemStackList(initialSize);
    }

    public void setSize(int size) {
        this.stacks = new ItemStackList(size);
    }

    public int getTotalItemCount() {
        int result = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stackInSlot = this.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            result += stackInSlot.func_190916_E();
        }
        return result;
    }

    public ItemStack getFirstNonEmptyItemStack() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stackInSlot = this.getStackInSlot(0);
            if (stackInSlot.func_190926_b()) continue;
            return stackInSlot;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        while (this.getSlots() - 1 < slot) {
            this.stacks.add((Object)ItemStack.field_190927_a);
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot > this.getSlots() - 1) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public ItemStack extractRandomItem(boolean simulate, Random random) {
        IntArrayList slots = new IntArrayList(this.getSlots());
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            slots.add(i);
        }
        if (slots.size() == 0) {
            return ItemStack.field_190927_a;
        }
        int slot = slots.getInt(random.nextInt(slots.size()));
        return this.extractItem(slot, 1, simulate);
    }

    public ItemStack extractItem(boolean simulate) {
        for (int i = this.getSlots() - 1; i >= 0; --i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            ItemStack extractItem = super.extractItem(i, 1, true);
            if (!simulate) {
                super.extractItem(i, 1, false);
            }
            return extractItem;
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        while (this.getSlots() - 1 < slot) {
            this.stacks.add((Object)ItemStack.field_190927_a);
        }
        super.setStackInSlot(slot, stack);
    }

    public ItemStack insertItem(ItemStack itemStack, boolean simulate) {
        ItemStack remaining = itemStack;
        int i = 0;
        while (!remaining.func_190926_b()) {
            while (this.getSlots() - 1 < i) {
                this.stacks.add((Object)ItemStack.field_190927_a);
            }
            remaining = super.insertItem(i, remaining, simulate);
            ++i;
        }
        return ItemStack.field_190927_a;
    }

    public void clearStacks() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.extractItem(i, this.getSlotLimit(i), false);
        }
    }

    private class ItemStackList
    extends NonNullList<ItemStack> {
        public ItemStackList(int size) {
            super(new ArrayList(size), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < size; ++i) {
                this.add(ItemStack.field_190927_a);
            }
        }
    }
}

