/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.gui.GuiHandler;
import zabi.minecraft.extraalchemy.inventory.PotionBagInventory;
import zabi.minecraft.extraalchemy.lib.Log;

public class ItemPotionBag
extends Item {
    public ItemPotionBag() {
        this.func_77625_d(1);
        if (ModConfig.options.addSeparateTab) {
            this.func_77637_a(ExtraAlchemy.TAB);
        } else {
            this.func_77637_a(CreativeTabs.field_78038_k);
        }
        this.setRegistryName(new ResourceLocation("extraalchemy", "potion_bag"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PotionBagInventory inv = this.getInventory(stack, false);
        if (inv == null) {
            tooltip.add("Old format detected, please shift right click at least once to convert");
            return;
        }
        int ch = this.getCharges(inv, false);
        if (ch > 0) {
            tooltip.add(I18n.func_135052_a((String)"item.potion_bag.charges", (Object[])new Object[]{ch}));
            tooltip.add("");
            PotionUtils.func_185182_a((ItemStack)inv.func_70301_a(0), tooltip, (float)1.0f);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            PotionBagInventory inv = this.getInventory(player.func_184586_b(hand), true);
            if (player.func_70093_af()) {
                player.openGui((Object)ExtraAlchemy.instance, GuiHandler.IDs.GUI_POTION_BAG.ordinal(), player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else if (this.getCharges(inv, true) > 0) {
                player.func_184598_c(hand);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public PotionBagInventory getInventory(ItemStack stack, boolean refresh) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            NBTTagCompound newTag = new NBTTagCompound();
            NonNullList list = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191281_a((NBTTagCompound)newTag, (NonNullList)list, (boolean)true);
            stack.func_77978_p().func_74782_a("new_inv", (NBTBase)newTag);
        }
        if (stack.func_77978_p().func_74764_b("inventory")) {
            if (refresh) {
                Log.d("Converting bag inventory to new format. Current tag:\n" + stack.func_77978_p());
                NBTTagCompound old = stack.func_179543_a("inventory");
                NBTTagCompound newTag = new NBTTagCompound();
                NonNullList list = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < 19; ++i) {
                    ItemStack is = new ItemStack(old.func_74775_l("inv" + i));
                    Log.d("Found potion, " + is);
                    list.set(i, (Object)is);
                }
                ItemStackHelper.func_191281_a((NBTTagCompound)newTag, (NonNullList)list, (boolean)true);
                stack.func_77978_p().func_74782_a("new_inv", (NBTBase)newTag);
                stack.func_77978_p().func_82580_o("inventory");
            } else {
                return null;
            }
        }
        return new PotionBagInventory(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        entityLiving.func_184597_cx();
        PotionBagInventory inventory = this.getInventory(stack, true);
        PotionType pt = PotionUtils.func_185191_c((ItemStack)inventory.func_70301_a(0));
        for (int i = 1; i < 19; ++i) {
            ItemStack pot = inventory.func_70301_a(i);
            if (pot.func_190926_b() || !PotionUtils.func_185191_c((ItemStack)pot).equals(pt)) continue;
            for (PotionEffect pe : pt.func_185170_a()) {
                if (pe.func_188419_a().func_76403_b()) {
                    pe.func_188419_a().func_180793_a(null, null, entityLiving, pe.func_76458_c(), 1.0);
                    continue;
                }
                entityLiving.func_70690_d(new PotionEffect(pe));
            }
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
            this.getCharges(inventory, true);
            return stack;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return (int)((double)Items.field_151068_bn.func_77626_a(stack) * 0.9);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return I18n.func_135052_a((String)"item.potion_bag", (Object[])new Object[0]);
    }

    private int getCharges(PotionBagInventory inventory, boolean update) {
        ItemStack selected = inventory.func_70301_a(0);
        if (selected.func_190926_b()) {
            if (update) {
                return this.selectNextAndGetCharges(inventory);
            }
            return 0;
        }
        PotionType selectedPT = PotionUtils.func_185191_c((ItemStack)selected);
        int count = 0;
        for (int i = 1; i < 19; ++i) {
            ItemStack potslot = inventory.func_70301_a(i);
            if (potslot.func_190926_b() || !PotionUtils.func_185191_c((ItemStack)potslot).equals(selectedPT)) continue;
            count += potslot.func_190916_E();
        }
        if (count == 0 && update) {
            return this.selectNextAndGetCharges(inventory);
        }
        return count;
    }

    private int selectNextAndGetCharges(PotionBagInventory inventory) {
        for (int i = 1; i < 19; ++i) {
            ItemStack potslot = inventory.func_70301_a(i);
            if (potslot.func_190926_b()) continue;
            inventory.setStackInSlot(0, potslot.func_77946_l());
            return this.getCharges(inventory, false);
        }
        return 0;
    }
}

