/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.tileentity.TileEntityColoured;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModernBed
extends BlockFurnitureTile {
    public static final PropertyEnum<Type> BED_TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final AxisAlignedBB BOUNDING_BOX = new Bounds(0, 0, 0, 16, 9, 16).toAABB();
    private static final AxisAlignedBB BASE = new Bounds(0, 4, 0, 16, 8, 16).toAABB();
    private static final AxisAlignedBB[] TOP = new Bounds(14, 0, 0, 16, 16, 16).getRotatedBounds();
    private static final AxisAlignedBB[] BOTTOM = new Bounds(0, 0, 0, 2, 8, 16).getRotatedBounds();

    public BlockModernBed(String id) {
        super(Material.field_151575_d);
        this.func_149663_c(id);
        this.setRegistryName(id);
        this.func_149711_c(0.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance * 0.25f);
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        if (entityIn.func_70093_af()) {
            super.func_176216_a(worldIn, entityIn);
        } else if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x = -entityIn.field_70181_x * 0.8;
            if (!(entityIn instanceof EntityLivingBase)) {
                entityIn.field_70181_x *= 0.8;
            }
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(state, worldIn, pos);
        for (AxisAlignedBB box : list) {
            BlockModernBed.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    protected List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(BASE);
        if (this == FurnitureBlocks.MODERN_BED_TOP) {
            boxes.add(TOP[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()]);
        } else {
            boxes.add(BOTTOM[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()]);
        }
        return boxes;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (this == FurnitureBlocks.MODERN_BED_BOTTOM && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() != FurnitureBlocks.MODERN_BED_TOP) {
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && worldIn.func_180494_b(pos) != Biomes.field_76778_j) {
            EntityPlayer.SleepResult sleepResult;
            TileEntity tileEntity;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInBed(worldIn, pos);
                if (entityplayer != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                tileEntity = worldIn.func_175625_s(pos);
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.FALSE);
                worldIn.func_180501_a(pos, state, 3);
                if (tileEntity != null) {
                    tileEntity.func_145829_t();
                    worldIn.func_175690_a(pos, tileEntity);
                }
            }
            if ((sleepResult = playerIn.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                tileEntity = worldIn.func_175625_s(pos);
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.TRUE);
                worldIn.func_180501_a(pos, state, 3);
                if (tileEntity != null) {
                    tileEntity.func_145829_t();
                    worldIn.func_175690_a(pos, tileEntity);
                }
                return true;
            }
            if (sleepResult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
            } else if (sleepResult == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
            } else if (sleepResult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.tooFarAway", new Object[0]), true);
            }
            return true;
        }
        worldIn.func_175698_g(pos);
        EnumFacing facing1 = (EnumFacing)state.func_177229_b((IProperty)FACING);
        pos = pos.func_177972_a(this == FurnitureBlocks.MODERN_BED_TOP ? facing1.func_176734_d() : facing1);
        if (worldIn.func_180495_p(pos).func_177230_c() == (this == FurnitureBlocks.MODERN_BED_TOP ? FurnitureBlocks.MODERN_BED_BOTTOM : FurnitureBlocks.MODERN_BED_TOP)) {
            worldIn.func_175698_g(pos);
        }
        worldIn.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, true);
        return true;
    }

    @Nullable
    private EntityPlayer getPlayerInBed(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityColoured();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState leftState;
        TileEntity tileEntity;
        IBlockState otherState;
        if (this == FurnitureBlocks.MODERN_BED_BOTTOM && (otherState = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() == FurnitureBlocks.MODERN_BED_TOP) {
            state = state.func_177226_a((IProperty)OCCUPIED, otherState.func_177229_b((IProperty)OCCUPIED));
        }
        if ((tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityColoured) {
            int colour = ((TileEntityColoured)tileEntity).getColour();
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(colour));
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean left = false;
        boolean right = false;
        IBlockState rightState = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        if (rightState.func_177230_c() == this && rightState.func_177229_b((IProperty)FACING) == facing) {
            right = true;
        }
        if ((leftState = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()))).func_177230_c() == this && leftState.func_177229_b((IProperty)FACING) == facing) {
            left = true;
        }
        state = left && right ? state.func_177226_a(BED_TYPE, (Comparable)((Object)Type.BOTH)) : (left ? state.func_177226_a(BED_TYPE, (Comparable)((Object)Type.RIGHT)) : (right ? state.func_177226_a(BED_TYPE, (Comparable)((Object)Type.LEFT)) : state.func_177226_a(BED_TYPE, (Comparable)((Object)Type.NONE))));
        return state;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(meta > 3));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
            meta += 4;
        }
        return meta;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BED_TYPE, COLOUR, OCCUPIED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            ((TileEntityColoured)tileEntity).setColour(15 - stack.func_77960_j());
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (this == FurnitureBlocks.MODERN_BED_TOP) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == FurnitureBlocks.MODERN_BED_BOTTOM) {
                worldIn.func_175655_b(pos.func_177972_a(facing.func_176734_d()), false);
            }
        } else if (this == FurnitureBlocks.MODERN_BED_BOTTOM && worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == FurnitureBlocks.MODERN_BED_TOP) {
            worldIn.func_175655_b(pos.func_177972_a(facing), false);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tileEntity, ItemStack stack) {
        if (tileEntity instanceof TileEntityColoured) {
            TileEntityColoured couch = (TileEntityColoured)tileEntity;
            ItemStack itemstack = new ItemStack(FurnitureBlocks.MODERN_BED_BOTTOM, 1, couch.getColour());
            BlockModernBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, tileEntity, stack);
        }
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = 0;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColoured) {
            metadata = ((TileEntityColoured)tileEntity).getColour();
        }
        return new ItemStack((Block)this, 1, metadata);
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(IBlockAccess blockAccess, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (blockAccess instanceof World) {
            World world = (World)blockAccess;
            TileEntity tileEntity = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
            world.func_180501_a(pos, state, 4);
            if (tileEntity != null) {
                tileEntity.func_145829_t();
                world.func_175690_a(pos, tileEntity);
            }
        }
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (EnumFacing)this.func_176221_a(state, world, pos).func_177229_b((IProperty)FACING);
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return this == FurnitureBlocks.MODERN_BED_BOTTOM;
    }

    public static enum Type implements IStringSerializable
    {
        LEFT,
        RIGHT,
        BOTH,
        NONE;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

