/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.moreplates.plugins.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.apache.logging.log4j.Level;
import panszelescik.morelibs.api.ClassComparator;
import panszelescik.morelibs.api.Helper;
import panszelescik.moreplates.MorePlates;
import panszelescik.moreplates.config.Config;
import panszelescik.moreplates.plugins.core.Plugin;

public class PluginLoader {
    private static ArrayList<Class> initList = new ArrayList();

    public static void addPlugins(ASMDataTable dataTable) {
        for (ASMDataTable.ASMData data : dataTable.getAll(Plugin.class.getName())) {
            try {
                String modid = (String)data.getAnnotationInfo().get("modid");
                String modname = (String)data.getAnnotationInfo().get("modname");
                String clazzName = data.getClassName();
                Class<?> clazz = Class.forName(clazzName);
                Plugin details = clazz.getAnnotation(Plugin.class);
                boolean loaded = details.checkModid() ? Helper.isLoaded((String)modid) : true;
                boolean config = details.checkConfig() ? PluginLoader.getB(modname) : true;
                if (loaded && config) {
                    initList.add(clazz);
                    MorePlates.logger.debug("Plugin " + modname + " loaded, adding");
                    continue;
                }
                MorePlates.logger.debug("Plugin " + modname + " not loaded, skipping");
            }
            catch (Exception e) {
                MorePlates.logger.error("Unable to add plugin class: " + data.getClassName() + "! An error occurred:");
                MorePlates.logger.catching(Level.ERROR, (Throwable)e);
            }
        }
        initList.sort((Comparator<Class>)new ClassComparator());
    }

    public static void preInitPlugin() {
        MorePlates.logger.info("Searching for preInit methods");
        for (Class clazz : initList) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Plugin.PreInit.class)) continue;
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    MorePlates.logger.error("Unable to initialise plugin using preInit method: " + method.getName() + "! The following error was thrown:");
                    MorePlates.logger.catching(Level.ERROR, (Throwable)e);
                }
            }
        }
    }

    public static void postInitPlugin() {
        MorePlates.logger.info("Searching for postInit methods");
        for (Class clazz : initList) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Plugin.PostInit.class)) continue;
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    MorePlates.logger.error("Unable to initialise plugin using postInit method: " + method.getName() + "! The following error was thrown:");
                    MorePlates.logger.catching(Level.ERROR, (Throwable)e);
                }
            }
        }
    }

    private static boolean getB(String modname) {
        return Config.getBoolean((String)modname, (String)"plugins", (String)("Enable this to load " + modname + " plugin"));
    }
}

