/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.worldgen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.DungeonHooks;
import pegbeard.dungeontactics.blocks.DTTrap;
import pegbeard.dungeontactics.blocks.tileentities.DTBarrelTile;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;

public class DTTower
extends WorldGenerator {
    private boolean netherTower = false;
    private int netherChance = DTConfigHandler.configuration.get("7-World", "5.3-Nether Variant Chance", 9).getInt(9);
    private int minHeight = DTConfigHandler.configuration.get("7-World", "5.1-Dungeon MinHeight", 3).getInt(3);
    private int maxHeight = DTConfigHandler.configuration.get("7-World", "5.2-Dungeon MaxHeight", 10).getInt(10);
    private int trap = 3;
    private int floor = 1;
    private boolean isVoid = false;
    private Biome biome = Biomes.field_185440_P;
    private static final List<Block> useDecorative = Lists.newArrayList();
    private static final List<Block> trapVarient = Lists.newArrayList();

    public DTTower() {
        useDecorative.add(Blocks.field_150350_a);
        useDecorative.add(Blocks.field_150467_bQ);
        useDecorative.add(Blocks.field_150421_aI);
        useDecorative.add((Block)Blocks.field_150383_bp);
        useDecorative.add(Blocks.field_150462_ai);
        useDecorative.add(Blocks.field_150460_al);
        useDecorative.add(DTBlocks.BARREL);
        trapVarient.add(DTBlocks.TRAP_BOOM);
        trapVarient.add(DTBlocks.TRAP_FIRE);
        trapVarient.add(DTBlocks.TRAP_SLIME);
        trapVarient.add(DTBlocks.TRAP_FOUL);
        trapVarient.add(DTBlocks.TRAP_AILMENT);
        trapVarient.add(DTBlocks.TRAP_PORT);
        trapVarient.add(DTBlocks.TRAP_AMBUSH);
        trapVarient.add(DTBlocks.TRAP_SPECTRAL);
    }

    public void settle(World world, Random rand, BlockPos start) {
        int level;
        if (world.func_175623_d(new BlockPos(start.func_177958_n(), 0, start.func_177952_p()))) {
            this.isVoid = true;
        }
        BlockPos ne = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() - 4);
        BlockPos se = new BlockPos(start.func_177958_n() + 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos sw = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() + 4);
        BlockPos nw = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() - 4);
        int count = 0;
        if (!this.isVoid) {
            for (level = start.func_177956_o(); level > 0 && (!world.func_175677_d(ne.func_177979_c(count), false) && world.func_180495_p(ne.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(ne.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(ne.func_177979_c(count)) || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(ne.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(se.func_177979_c(count), false) && world.func_180495_p(se.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(se.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(se.func_177979_c(count)) || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(se.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(sw.func_177979_c(count), false) && world.func_180495_p(sw.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(sw.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(sw.func_177979_c(count)) || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(sw.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u || !world.func_175677_d(nw.func_177979_c(count), false) && world.func_180495_p(nw.func_177979_c(count)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(nw.func_177979_c(count)).func_177230_c() != Blocks.field_150353_l || world.func_175623_d(nw.func_177979_c(count)) || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150364_r || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150363_s || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150362_t || world.func_180495_p(nw.func_177979_c(count)).func_177230_c() == Blocks.field_150361_u); --level) {
                ++count;
            }
        }
        if (level < 1) {
            level = 1;
        }
        BlockPos pos = new BlockPos(start.func_177958_n(), level, start.func_177952_p());
        this.func_180709_b(world, rand, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos start) {
        int vert;
        int hor;
        this.biome = world.func_180494_b(start);
        if (rand.nextInt(100) < this.netherChance) {
            this.netherTower = true;
        }
        BlockPos pos = new BlockPos(start.func_177958_n(), start.func_177956_o(), start.func_177952_p());
        BlockPos cs = new BlockPos(start.func_177958_n() - 4, start.func_177956_o(), start.func_177952_p() - 4);
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y = 0; y < 6; ++y) {
                    if (world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150358_i && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150356_k && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                if (!this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        world.func_180501_a(pos.func_177984_a().func_177978_c().func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d(), this.useStair(world, pos).func_176203_a(1), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(4).func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177974_f())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177974_f());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177976_e());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177976_e());
        }
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177984_a());
        if (mobspawner instanceof TileEntityMobSpawner) {
            ResourceLocation mob = this.pickMobSpawner(rand);
            mobspawner.func_145881_a().func_190894_a(mob);
            if (!this.netherTower) {
                int chance = 40;
                if (mob.toString().contains("spider")) {
                    chance = 10;
                }
                this.spiderNest(world, pos, chance);
            }
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 1 + ", " + pos.func_177952_p() + ")");
        }
        for (int vert2 = 1; vert2 < 6; ++vert2) {
            world.func_180501_a(cs.func_177981_b(vert2), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177965_g(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8).func_177965_g(8), this.useLog(world, pos), 2);
        }
        this.generateRoom(world, rand, pos.func_177982_a(0, 5, 0));
        return true;
    }

    public boolean generateRoom(World world, Random rand, BlockPos pos) {
        int next;
        int vert;
        int hor;
        ++this.floor;
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y = 0; y < 6; ++y) {
                    if (world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150358_i && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150356_k && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 6; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 9; ++vert) {
                if (!this.terrainHelper(world, cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5))) continue;
                world.func_180501_a(cs.func_177970_e(vert).func_177965_g(hor).func_177981_b(5), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(2).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(2).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177965_g(6).func_177970_e(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177965_g(6).func_177970_e(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(2))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(6))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(2).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(2).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(2).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, cs.func_177981_b(3).func_177970_e(6).func_177965_g(8))) {
            world.func_180501_a(cs.func_177981_b(3).func_177970_e(6).func_177965_g(8), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        world.func_180501_a(pos.func_177984_a().func_177978_c().func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177974_f(), this.useStair(world, pos).func_176203_a(2), 2);
        world.func_180501_a(pos.func_177981_b(2).func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d(), this.useStair(world, pos).func_176203_a(1), 2);
        world.func_180501_a(pos.func_177981_b(3).func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        world.func_180501_a(pos.func_177981_b(4).func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        world.func_180501_a(pos.func_177981_b(5).func_177978_c().func_177976_e(), this.useStair(world, pos).func_176203_a(3), 2);
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177974_f())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177974_f());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177968_d().func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177968_d().func_177976_e());
        }
        if (this.windowHelper(world, pos.func_177981_b(5).func_177976_e())) {
            world.func_175698_g(pos.func_177981_b(5).func_177976_e());
        }
        if (rand.nextInt(2) == 0) {
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150486_ae.func_176458_f(world, pos.func_177984_a(), Blocks.field_150486_ae.func_176223_P()), 2);
            TileEntity chest = world.func_175625_s(pos.func_177984_a());
            if (chest instanceof TileEntityChest) {
                if (this.floor <= 3) {
                    if (this.netherTower && rand.nextInt(2) == 0) {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
                    } else {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186420_b, rand.nextLong());
                    }
                }
                if (this.floor >= 4 && this.floor <= 6) {
                    if (this.netherTower && rand.nextInt(2) == 0) {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
                    } else {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186422_d, rand.nextLong());
                    }
                }
                if (this.floor >= 7) {
                    if (this.netherTower && rand.nextInt(2) == 0) {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
                    } else {
                        ((TileEntityChest)chest).func_189404_a(LootTableList.field_186423_e, rand.nextLong());
                    }
                }
            }
        }
        world.func_180501_a(pos.func_177981_b(2), Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntityMobSpawner mobspawner = (TileEntityMobSpawner)world.func_175625_s(pos.func_177981_b(2));
        if (mobspawner instanceof TileEntityMobSpawner) {
            ResourceLocation mob = this.pickMobSpawner(rand);
            mobspawner.func_145881_a().func_190894_a(mob);
            if (!this.netherTower) {
                int chance = 40;
                if (mob.toString().contains("spider")) {
                    chance = 10;
                }
                this.spiderNest(world, pos, chance);
            }
        } else {
            System.err.println("Failed to fetch mob spawner entity at (" + pos.func_177958_n() + ", " + pos.func_177956_o() + 2 + ", " + pos.func_177952_p() + ")");
        }
        for (int vert2 = 0; vert2 < 5; ++vert2) {
            world.func_180501_a(cs.func_177981_b(vert2), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177965_g(8), this.useLog(world, pos), 2);
            world.func_180501_a(cs.func_177981_b(vert2).func_177970_e(8).func_177965_g(8), this.useLog(world, pos), 2);
        }
        if (rand.nextInt(this.trap) == 0) {
            this.placeTrapPlate(world, pos.func_177984_a().func_177964_d(rand.nextInt(3)).func_177970_e(rand.nextInt(3)).func_177965_g(rand.nextInt(3)).func_177985_f(rand.nextInt(3)), rand);
        }
        if (((next = rand.nextInt(3)) < 2 || this.floor < this.minHeight) && this.floor < this.maxHeight && pos.func_177956_o() < world.func_72940_L() - 20) {
            if (this.floor > 2) {
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177964_d(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(0, 0, -8), "north");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177970_e(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(0, 0, 8), "south");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177965_g(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(8, 0, 0), "east");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177985_f(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(-8, 0, 0), "west");
                }
            }
            this.generateRoom(world, rand, pos.func_177982_a(0, 5, 0));
        } else {
            if (pos.func_177956_o() < world.func_72940_L() - 30) {
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177964_d(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(0, 0, -8), "north");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177970_e(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(0, 0, 8), "south");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177965_g(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(8, 0, 0), "east");
                }
                if (rand.nextInt(6) == 0 && world.func_175623_d(pos.func_177985_f(8).func_177984_a())) {
                    this.generateSide(world, rand, pos.func_177982_a(-8, 0, 0), "west");
                }
            }
            this.generateTop(world, rand, pos.func_177982_a(0, 5, 0));
        }
        return true;
    }

    public boolean generateTop(World world, Random rand, BlockPos pos) {
        int vert;
        int hor;
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 9; ++x) {
            for (int z = 0; z < 9; ++z) {
                for (int y = 0; y < 6; ++y) {
                    if (world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150358_i && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150356_k && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 2; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177970_e(hor).func_177965_g(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; ++hor) {
            for (vert = 0; vert < 2; ++vert) {
                if (this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor))) {
                    world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                }
                if (!this.terrainHelper(world, cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8))) continue;
                world.func_180501_a(cs.func_177981_b(vert).func_177965_g(hor).func_177970_e(8), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
        }
        for (hor = 0; hor < 9; hor += 2) {
            if (this.terrainHelper(world, cs.func_177981_b(2).func_177970_e(hor))) {
                world.func_180501_a(cs.func_177981_b(2).func_177970_e(hor), this.useSlab(world, pos), 2);
            }
            if (!this.terrainHelper(world, cs.func_177981_b(2).func_177970_e(hor).func_177965_g(8))) continue;
            world.func_180501_a(cs.func_177981_b(2).func_177970_e(hor).func_177965_g(8), this.useSlab(world, pos), 2);
        }
        for (hor = 2; hor < 7; hor += 2) {
            if (this.terrainHelper(world, cs.func_177981_b(2).func_177965_g(hor))) {
                world.func_180501_a(cs.func_177981_b(2).func_177965_g(hor), this.useSlab(world, pos), 2);
            }
            if (!this.terrainHelper(world, cs.func_177981_b(2).func_177965_g(hor).func_177970_e(8))) continue;
            world.func_180501_a(cs.func_177981_b(2).func_177965_g(hor).func_177970_e(8), this.useSlab(world, pos), 2);
        }
        world.func_180501_a(pos.func_177984_a(), DTBlocks.GUARDIAN_ALTER.func_176223_P(), 2);
        return true;
    }

    public boolean generateSide(World world, Random rand, BlockPos pos, String dir) {
        TileEntity barrel;
        int hor;
        BlockPos cs = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() - 1);
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                for (int y = 0; y < 13; ++y) {
                    if (world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150358_i && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150353_l && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150356_k && world.func_180495_p(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z)).func_177230_c() != Blocks.field_150424_aL) continue;
                    world.func_175698_g(cs.func_177981_b(y).func_177970_e(x).func_177965_g(z));
                }
            }
        }
        for (int vert = 1; vert < 12; ++vert) {
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177964_d(2))) {
                world.func_180501_a(pos.func_177981_b(vert).func_177964_d(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177964_d(2).func_177974_f())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177964_d(2).func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177964_d(2).func_177976_e())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177964_d(2).func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177970_e(2))) {
                world.func_180501_a(pos.func_177981_b(vert).func_177970_e(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177970_e(2).func_177974_f())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177970_e(2).func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177970_e(2).func_177976_e())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177970_e(2).func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177965_g(2))) {
                world.func_180501_a(pos.func_177981_b(vert).func_177965_g(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177965_g(2).func_177978_c())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177965_g(2).func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177965_g(2).func_177968_d())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177965_g(2).func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177985_f(2))) {
                world.func_180501_a(pos.func_177981_b(vert).func_177985_f(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (this.terrainHelper(world, pos.func_177981_b(vert).func_177985_f(2).func_177978_c())) {
                world.func_180501_a(pos.func_177981_b(vert).func_177985_f(2).func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
            }
            if (!this.terrainHelper(world, pos.func_177981_b(vert).func_177985_f(2).func_177968_d())) continue;
            world.func_180501_a(pos.func_177981_b(vert).func_177985_f(2).func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos)) {
            world.func_180501_a(pos, this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177978_c())) {
            world.func_180501_a(pos.func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177968_d())) {
            world.func_180501_a(pos.func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177974_f())) {
            world.func_180501_a(pos.func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177976_e())) {
            world.func_180501_a(pos.func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177978_c().func_177974_f())) {
            world.func_180501_a(pos.func_177978_c().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177978_c().func_177976_e())) {
            world.func_180501_a(pos.func_177978_c().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177968_d().func_177974_f())) {
            world.func_180501_a(pos.func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177968_d().func_177976_e())) {
            world.func_180501_a(pos.func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10))) {
            world.func_180501_a(pos.func_177981_b(10), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177978_c())) {
            world.func_180501_a(pos.func_177981_b(10).func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177968_d())) {
            world.func_180501_a(pos.func_177981_b(10).func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177974_f())) {
            world.func_180501_a(pos.func_177981_b(10).func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177976_e())) {
            world.func_180501_a(pos.func_177981_b(10).func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177978_c().func_177974_f())) {
            world.func_180501_a(pos.func_177981_b(10).func_177978_c().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177978_c().func_177976_e())) {
            world.func_180501_a(pos.func_177981_b(10).func_177978_c().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177968_d().func_177974_f())) {
            world.func_180501_a(pos.func_177981_b(10).func_177968_d().func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(10).func_177968_d().func_177976_e())) {
            world.func_180501_a(pos.func_177981_b(10).func_177968_d().func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(12).func_177964_d(2))) {
            world.func_180501_a(pos.func_177981_b(12).func_177964_d(2), this.useSlab(world, pos), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(12).func_177970_e(2))) {
            world.func_180501_a(pos.func_177981_b(12).func_177970_e(2), this.useSlab(world, pos), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(12).func_177965_g(2))) {
            world.func_180501_a(pos.func_177981_b(12).func_177965_g(2), this.useSlab(world, pos), 2);
        }
        if (this.terrainHelper(world, pos.func_177981_b(12).func_177985_f(2))) {
            world.func_180501_a(pos.func_177981_b(12).func_177985_f(2), this.useSlab(world, pos), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(2).func_177964_d(2))) {
            world.func_180501_a(pos.func_177981_b(2).func_177964_d(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(3).func_177964_d(2))) {
            world.func_180501_a(pos.func_177981_b(3).func_177964_d(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(2).func_177970_e(2))) {
            world.func_180501_a(pos.func_177981_b(2).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(3).func_177970_e(2))) {
            world.func_180501_a(pos.func_177981_b(3).func_177970_e(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(2).func_177965_g(2))) {
            world.func_180501_a(pos.func_177981_b(2).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(3).func_177965_g(2))) {
            world.func_180501_a(pos.func_177981_b(3).func_177965_g(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(2).func_177985_f(2))) {
            world.func_180501_a(pos.func_177981_b(2).func_177985_f(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (this.windowHelper(world, pos.func_177981_b(3).func_177985_f(2))) {
            world.func_180501_a(pos.func_177981_b(3).func_177985_f(2), DTBlocks.DUNGEON_GLASS.func_176223_P(), 2);
        }
        if (dir.equals("north")) {
            for (hor = 2; hor < 5; ++hor) {
                world.func_180501_a(pos.func_177970_e(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177974_f().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177976_e().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177974_f().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177976_e().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177974_f().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177970_e(hor).func_177976_e().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_175698_g(pos.func_177970_e(hor).func_177984_a());
                world.func_175698_g(pos.func_177970_e(hor).func_177981_b(2));
            }
            if (rand.nextInt(this.trap) == 0) {
                this.placeTrapPlate(world, pos.func_177984_a().func_177970_e(3), rand);
            }
        }
        if (dir.equals("south")) {
            for (hor = 2; hor < 5; ++hor) {
                world.func_180501_a(pos.func_177964_d(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177974_f(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177976_e(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177974_f().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177976_e().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177974_f().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177976_e().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177974_f().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177964_d(hor).func_177976_e().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_175698_g(pos.func_177964_d(hor).func_177984_a());
                world.func_175698_g(pos.func_177964_d(hor).func_177981_b(2));
            }
            if (rand.nextInt(this.trap) == 0) {
                this.placeTrapPlate(world, pos.func_177984_a().func_177964_d(3), rand);
            }
        }
        if (dir.equals("east")) {
            for (hor = 2; hor < 5; ++hor) {
                world.func_180501_a(pos.func_177985_f(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177978_c().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177968_d().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177978_c().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177968_d().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177978_c().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177985_f(hor).func_177968_d().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_175698_g(pos.func_177985_f(hor).func_177984_a());
                world.func_175698_g(pos.func_177985_f(hor).func_177981_b(2));
            }
            if (rand.nextInt(this.trap) == 0) {
                this.placeTrapPlate(world, pos.func_177984_a().func_177985_f(3), rand);
            }
        }
        if (dir.equals("west")) {
            for (hor = 2; hor < 5; ++hor) {
                world.func_180501_a(pos.func_177965_g(hor), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177978_c(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177968_d(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177978_c().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177968_d().func_177984_a(), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177978_c().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177968_d().func_177981_b(2), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177978_c().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_180501_a(pos.func_177965_g(hor).func_177968_d().func_177981_b(3), this.useBlock(world, pos).func_176203_a(rand.nextInt(3)), 2);
                world.func_175698_g(pos.func_177965_g(hor).func_177984_a());
                world.func_175698_g(pos.func_177965_g(hor).func_177981_b(2));
            }
            if (rand.nextInt(this.trap) == 0) {
                this.placeTrapPlate(world, pos.func_177984_a().func_177965_g(3), rand);
            }
        }
        Block decoration = useDecorative.get(rand.nextInt(useDecorative.size()));
        IBlockState prop = decoration.func_176223_P();
        if (decoration == Blocks.field_150460_al) {
            prop = prop.func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)this.getDirection(dir));
        }
        if (decoration == Blocks.field_150467_bQ) {
            prop = prop.func_177226_a((IProperty)BlockAnvil.field_176506_a, (Comparable)this.getDirection(dir)).func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(rand.nextInt(3)));
        }
        if (decoration == Blocks.field_150383_bp) {
            prop = prop.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(rand.nextInt(4)));
        }
        world.func_180501_a(pos.func_177984_a(), prop, 2);
        if (decoration == DTBlocks.BARREL && (barrel = world.func_175625_s(pos.func_177984_a())) instanceof DTBarrelTile) {
            if (this.netherTower && rand.nextInt(2) == 0) {
                ((DTBarrelTile)barrel).func_189404_a(LootTableList.field_186425_g, rand.nextLong());
            } else {
                ((DTBarrelTile)barrel).func_189404_a(LootTableList.field_186423_e, rand.nextLong());
            }
        }
        return true;
    }

    public void spiderNest(World world, BlockPos pos, int chance) {
        BlockPos cs = new BlockPos(pos.func_177958_n() - 4, pos.func_177956_o(), pos.func_177952_p() - 4);
        for (int x = 0; x < 7; ++x) {
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 4; ++y) {
                    if (!world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z)) || world.field_73012_v.nextInt(chance) != 0 || world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177984_a()) && world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177977_b()) && world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177974_f()) && world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177976_e()) && world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177978_c()) && world.func_175623_d(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z).func_177968_d())) continue;
                    world.func_180501_a(cs.func_177981_b(1 + y).func_177970_e(1 + x).func_177965_g(1 + z), Blocks.field_150321_G.func_176223_P(), 2);
                }
            }
        }
    }

    public boolean placeTrapPlate(World world, BlockPos pos, Random rand) {
        Block varient = trapVarient.get(rand.nextInt(trapVarient.size()));
        if (world.func_175623_d(pos) && varient.func_176196_c(world, pos)) {
            world.func_180501_a(pos, varient.func_176223_P(), 2);
            ((DTTrap)varient).setHiddenState(world, pos, true);
        }
        return true;
    }

    private ResourceLocation pickMobSpawner(Random rand) {
        if (this.netherTower) {
            switch (rand.nextInt(3)) {
                case 0: {
                    return new ResourceLocation("blaze");
                }
                case 1: {
                    return new ResourceLocation("zombie_pigman");
                }
                case 2: {
                    return new ResourceLocation("skeleton");
                }
            }
            return new ResourceLocation("blaze");
        }
        return DungeonHooks.getRandomDungeonMob((Random)rand);
    }

    private boolean terrainHelper(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos);
        return block.func_177230_c() != DTBlocks.DUNGEON_GLASS && (block.func_177230_c() == Blocks.field_150350_a || !block.func_185915_l() || !block.func_185914_p());
    }

    private boolean windowHelper(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150417_aV || block == Blocks.field_150322_A || block == Blocks.field_180395_cM || block == Blocks.field_150385_bj || block == Blocks.field_150418_aU || block == Blocks.field_150333_U || block == Blocks.field_180389_cP;
    }

    private Block useBlock(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherTower) {
            return Blocks.field_150385_bj;
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150322_A;
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180395_cM;
        }
        int block = world.field_73012_v.nextInt(9);
        Block result = block == 0 ? Blocks.field_150418_aU : Blocks.field_150417_aV;
        return result;
    }

    private Block useStair(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherTower) {
            return Blocks.field_150387_bl;
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150372_bz;
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180396_cN;
        }
        return Blocks.field_150390_bg;
    }

    private IBlockState useLog(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherTower) {
            return DTBlocks.OBSIDIAN_BRICK.func_176223_P();
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s || this.biome == Biomes.field_150588_X || this.biome == Biomes.field_150587_Y || this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_150363_s.func_176223_P();
        }
        return Blocks.field_150364_r.func_176203_a(1);
    }

    private IBlockState useSlab(World world, BlockPos pos) {
        if (this.biome == Biomes.field_76778_j || this.netherTower) {
            return Blocks.field_150333_U.func_176203_a(6);
        }
        if (this.biome == Biomes.field_76769_d || this.biome == Biomes.field_76786_s) {
            return Blocks.field_150333_U.func_176203_a(1);
        }
        if (this.biome == Biomes.field_150589_Z || this.biome == Biomes.field_150608_ab || this.biome == Biomes.field_150607_aa) {
            return Blocks.field_180389_cP.func_176203_a(0);
        }
        return Blocks.field_150333_U.func_176203_a(0);
    }

    private EnumFacing getDirection(String dir) {
        switch (dir) {
            case "north": {
                return EnumFacing.SOUTH;
            }
            case "south": {
                return EnumFacing.NORTH;
            }
            case "east": {
                return EnumFacing.WEST;
            }
            case "west": {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.NORTH;
    }
}

