/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.items.DTToolGeneric;

public class DTBoomGlove
extends DTToolGeneric {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});
    private int mineRadius = 1;
    private int mineDepth = 0;
    protected float explosionSize = 2.5f;

    public DTBoomGlove(String name, Item.ToolMaterial material, float attackDamage, float attackSpeed) {
        super(name, material, attackDamage, attackSpeed, EFFECTIVE_ON);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return true;
    }

    public int func_77619_b() {
        return 1;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        if (material == Material.field_151576_e || material == Material.field_151578_c) {
            return this.field_77862_b.func_77998_b();
        }
        return material != Material.field_151575_d ? 1.5f : 0.5f;
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_151571_B || state.func_177230_c() instanceof BlockOre;
    }

    private ItemStack hasAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isAmmo(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151016_H;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int bigger = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.BIGGERBOOM, (ItemStack)player.func_184586_b(hand));
        boolean sonic = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.SONICBOOM, (ItemStack)player.func_184586_b(hand)) > 0;
        boolean flag = player.field_71075_bZ.field_75098_d;
        ItemStack ammo = this.hasAmmo(player);
        if (world.func_180495_p(pos) != null && !world.func_175623_d(pos) && (!ammo.func_190926_b() || sonic || flag)) {
            if (ammo.func_190926_b()) {
                ammo = new ItemStack(Items.field_151016_H);
            }
            if (!flag) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                if (!sonic) {
                    ammo.func_190918_g(1);
                    if (ammo.func_190926_b()) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
            }
            if (!world.field_72995_K) {
                if (world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos)) < 3 && world.func_180495_p(pos).func_177230_c().getHarvestLevel(world.func_180495_p(pos)) > -1 && world.func_180495_p(pos).func_177230_c().func_149638_a((Entity)player) < 500.0f) {
                    world.func_180495_p(pos).func_177230_c().func_149752_b(2.0f);
                }
                world.func_72885_a((Entity)player, (double)((float)pos.func_177958_n() + 0.54f), (double)((float)pos.func_177956_o() + 0.54f), (double)((float)pos.func_177952_p() + 0.54f), this.explosionSize + (float)bigger, false, true);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            int zDist;
            EntityPlayer player = (EntityPlayer)entityLiving;
            RayTraceResult result = this.func_77621_a(world, player, false);
            if (result == null) {
                return super.func_179218_a(stack, world, state, pos, entityLiving);
            }
            EnumFacing sideHit = result.field_178784_b;
            int xDist = zDist = this.mineRadius;
            int yDist = zDist;
            switch (sideHit) {
                case UP: 
                case DOWN: {
                    yDist = this.mineDepth;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    zDist = this.mineDepth;
                    break;
                }
                case EAST: 
                case WEST: {
                    xDist = this.mineDepth;
                }
            }
            if (!player.func_70093_af()) {
                for (int x = pos.func_177958_n() - xDist; x <= pos.func_177958_n() + xDist; ++x) {
                    for (int y = pos.func_177956_o() - yDist; y <= pos.func_177956_o() + yDist; ++y) {
                        for (int z = pos.func_177952_p() - zDist; z <= pos.func_177952_p() + zDist; ++z) {
                            BlockPos targetPos = new BlockPos(x, y, z);
                            IBlockState targetBlock = world.func_180495_p(targetPos);
                            if (!this.func_150897_b(targetBlock) || targetBlock.func_177230_c() != state.func_177230_c() || stack.func_77958_k() - stack.func_77952_i() < 1 || targetBlock.func_177230_c() == Blocks.field_150357_h || world.field_72995_K) continue;
                            if (targetBlock.func_177230_c().getExpDrop(targetBlock, (IBlockAccess)world, targetPos, 0) > 0 && world.func_82736_K().func_82766_b("doTileDrops")) {
                                targetBlock.func_177230_c().func_180637_b(world, pos, targetBlock.func_177230_c().getExpDrop(targetBlock, (IBlockAccess)world, targetPos, 0));
                            }
                            world.func_175655_b(targetPos, true);
                        }
                    }
                }
            }
        }
        return super.func_179218_a(stack, world, state, pos, entityLiving);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean sonic;
        super.func_77644_a(stack, target, attacker);
        boolean bigger = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.BIGGERBOOM, (ItemStack)stack) > 0;
        boolean bl = sonic = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.SONICBOOM, (ItemStack)stack) > 0;
        if (attacker instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attacker;
            boolean flag = player.field_71075_bZ.field_75098_d;
            if (player.field_71071_by.func_70431_c(new ItemStack(Items.field_151016_H)) || sonic || flag) {
                if (!flag) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    if (!sonic) {
                        player.field_71071_by.func_70298_a(player.field_71071_by.func_184429_b(new ItemStack(Items.field_151016_H)), 1);
                    }
                }
                if (!attacker.func_130014_f_().field_72995_K) {
                    float f = 0.5f;
                    if (bigger) {
                        f = 1.0f;
                    }
                    attacker.func_130014_f_().func_72885_a((Entity)attacker, target.field_70165_t, target.field_70163_u + (double)0.54f, target.field_70161_v, f, false, false);
                }
            }
        }
        return true;
    }
}

