/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pegbeard.dungeontactics.reference.Reference;

public class DTConfigHandler {
    public static Configuration configuration;
    protected static List<Integer> dims;
    public static int hearts;
    public static int extraHearts;
    public static int boneCharms;
    public static int breakCharms;
    public static int potionFish;
    public static boolean flamerBehaviour;
    public static boolean oreClusters;
    public static boolean oreDusters;
    public static int lootbags;
    public static boolean attackBot;
    public static boolean sitting;
    public static boolean seasonal;
    public static boolean modifyLoot;
    public static boolean weaponSpawn;
    public static boolean invisNoArmour;
    public static boolean swapArmour;
    public static boolean quickLadders;
    public static boolean chainCreepers;
    public static float hammerDamage;
    public static float hammerSpeed;
    public static float battleaxeDamage;
    public static float battleaxeSpeed;
    public static float glaiveDamage;
    public static float glaiveSpeed;
    public static float glaiveReach;
    public static float cutlassDamage;
    public static float cutlassSpeed;
    public static float knifeDamage;
    public static float knifeSpeed;
    public static float knifeReach;
    public static float cestusDamage;
    public static float cestusSpeed;
    public static float cestusReach;
    public static int toolDurability;
    public static int gildedDurability;
    public static float gildedDamage;
    public static int jewelledDurability;
    public static float jewelledDamage;
    public static int tinDurability;
    public static float tinDamage;
    public static int copperDurability;
    public static float copperDamage;
    public static int bronzeDurability;
    public static float bronzeDamage;
    public static int leadDurability;
    public static float leadDamage;
    public static int invarDurability;
    public static float invarDamage;
    public static int steelDurability;
    public static float steelDamage;
    public static int silverDurability;
    public static float silverDamage;
    public static int electrumDurability;
    public static float electrumDamage;
    public static int platinumDurability;
    public static float platinumDamage;
    public static int tungstenDurability;
    public static float tungstenDamage;
    public static int titaniumDurability;
    public static float titaniumDamage;
    public static int osmiumDurability;
    public static float osmiumDamage;
    public static int emeraldDurability;
    public static float emeraldDamage;
    public static int rubyDurability;
    public static float rubyDamage;
    public static int sapphireDurability;
    public static float sapphireDamage;
    public static int peridotDurability;
    public static float peridotDamage;
    public static int amethystDurability;
    public static float amethystDamage;
    public static int crystalDurability;
    public static float crystalDamage;
    public static int topazDurability;
    public static float topazDamage;
    public static int soulsteelDurability;
    public static float soulsteelDamage;
    public static float trinketSpeed;
    public static float trinketJump;
    public static float trinketMining;
    public static float trinketGills;
    public static float trinketNightVision;
    public static float trinketFire;
    public static float trinketResistance;
    public static float trinketStrength;
    public static float trinketInvisibility;
    public static boolean oreClustersOverride;
    public static String[] ironOverride;
    public static String[] goldOverride;
    public static String[] tinOverride;
    public static String[] copperOverride;
    public static String[] leadOverride;
    public static String[] silverOverride;
    public static String[] platinumOverride;
    public static String[] tungstenOverride;
    public static String[] titaniumOverride;
    public static String[] ducttapeWhite;
    public static String[] ducttapeBlack;
    public static String[] slingshotWhite;
    public static String[] slingshotBlack;
    public static int netherGold;
    public static int stoneQuartz;
    public static int endDiamond;
    public static int endLapis;
    public static int flowers;
    public static String[] flowerBiomes;
    public static boolean dungeons;
    public static int shipSpacing;
    public static int dungeonSpacing;
    public static String[] dungeonDimensions;
    public static int dungeonMinHeight;
    public static int dungeonMaxHeight;
    public static int netherDungeonChance;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            DTConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        hearts = configuration.getInt("1-Heart Drops", "1-Feature", 20, 0, 100, "Percentage chance for Heart Drops. Set to 100 for guarenteed drops, 0 to disable.");
        extraHearts = configuration.getInt("2-Extra Hearts", "1-Feature", 20, 0, 60, "Maximum amount of extra hearts allowed.");
        boneCharms = configuration.getInt("3-Bone Charm Drops", "1-Feature", 10, 0, 100, "Percentage chance for Bone Charms to be dropped. Set to 100 for guarenteed drops, 0 to disable.");
        breakCharms = configuration.getInt("4-Bone Charm Break Chance", "1-Feature", 7, 1, 20, "Percentage chance for Bone Charms to break on use. Set to 1 to break on every use.");
        potionFish = configuration.getInt("5-Potion Fish Catch Chance", "1-Feature", 7, 0, 100, "Weight for catching Potion Fish, when fishing - 0 will disable, vanilla fish weight is 10.");
        flamerBehaviour = configuration.getBoolean("6-Flamer Behaviour", "1-Feature", true, "Set 'false' to disable certain flamer behaviour, such as heating furnaces and igniting TNT.");
        oreClusters = configuration.getBoolean("7-Ore Clusters", "1-Feature", true, "Set 'false' to disable fortunable metal ore drops.");
        oreDusters = configuration.getBoolean("8-Ore Clusters = Dust", "1-Feature", false, "Set 'true' to have ore clusters registered as dusts in the oredict.");
        lootbags = configuration.getInt("9-Loot Bag Drops", "1-Feature", 10, 0, 100, "Percentage chance for Loot Bags. Set to 100 for guarenteed drops, 0 to disable.");
        attackBot = configuration.getBoolean("U-Dispensers use weapons", "1-Feature", true, "Set 'false' to disable Dispensers using weapons/tools.");
        sitting = configuration.getBoolean("C-Can Sit", "1-Feature", true, "Set 'false' to disable sitting.");
        seasonal = configuration.getBoolean("E-Seasonal Events", "1-Feature", true, "Set 'false' to disable Seasonal Events, because you have no sense of fun, you monster.");
        modifyLoot = configuration.getBoolean("C-Modify Loot Pools", "1-Feature", true, "Set 'false' to disable loot pool manipulation - this stops the mod from adding content to vanilla loot pools.");
        weaponSpawn = configuration.getBoolean("C-Give Weapons to Mobs", "1-Feature", true, "Set 'false' to stop mobs spawning with DT weapons.");
        invisNoArmour = configuration.getBoolean("C-Invisiblity Removes Armour", "1-Feature", true, "If 'true' armour will be unequipped and placed into the inventory of players with invisibility.");
        swapArmour = configuration.getBoolean("C-Quick Change Armour", "1-Feature", true, "If enabled. right-clicking armour while already wearing a piece in the same slot will change over the piece in your hand and the piece you are wearing.");
        quickLadders = configuration.getBoolean("C-Quick Ladder Climb", "1-Feature", true, "Enable/disable ability to right-click a ladder to instantly climb it.");
        chainCreepers = configuration.getBoolean("D-Chained Creeper Explosions", "1-Feature", true, "If true, explosions will cause creepers to explode, in normal or hard difficulties.");
        hammerDamage = configuration.getFloat("1-Hammer Base Damage", "5-Weapon Modifiers", 7.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Hammers.");
        hammerSpeed = configuration.getFloat("1-Hammer Base Speed", "5-Weapon Modifiers", -3.1f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Hammers.");
        battleaxeDamage = configuration.getFloat("2-Battleaxe Base Damage", "5-Weapon Modifiers", 7.2f, 0.0f, 100.0f, "This option allows you to set the base damage of Battleaxes.");
        battleaxeSpeed = configuration.getFloat("2-Battleaxe Base Speed", "5-Weapon Modifiers", -3.3f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Battleaxes.");
        glaiveDamage = configuration.getFloat("3-Glaive Base Damage", "5-Weapon Modifiers", 3.3f, 0.0f, 100.0f, "This option allows you to set the base damage of Glaives.");
        glaiveSpeed = configuration.getFloat("3-Glaive Base Speed", "5-Weapon Modifiers", -2.8f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Glaives.");
        glaiveReach = configuration.getFloat("3-Glaive Base Reach", "5-Weapon Modifiers", 4.5f, 3.5f, 10.0f, "This option allows you to set the reach of Glaives.");
        cutlassDamage = configuration.getFloat("4-Cutlass Base Damage", "5-Weapon Modifiers", 2.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Cutlass'.");
        cutlassSpeed = configuration.getFloat("4-Cutlass Base Speed", "5-Weapon Modifiers", -2.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Cutlass'.");
        knifeDamage = configuration.getFloat("5-Knife Base Damage", "5-Weapon Modifiers", 1.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Knives.");
        knifeSpeed = configuration.getFloat("5-Knife Base Speed", "5-Weapon Modifiers", -1.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Knives.");
        knifeReach = configuration.getFloat("5-Knife Base Reach", "5-Weapon Modifiers", 2.5f, 0.0f, 100.0f, "This option allows you to set the reach of Knives.");
        cestusDamage = configuration.getFloat("6-Cestus Base Damage", "5-Weapon Modifiers", 0.5f, 0.0f, 100.0f, "This option allows you to set the base damage of Cestus'.");
        cestusSpeed = configuration.getFloat("6-Cestus Base Speed", "5-Weapon Modifiers", 1.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Cestus'.");
        cestusReach = configuration.getFloat("6-Cestus Base Reach", "5-Weapon Modifiers", 2.0f, 0.0f, 100.0f, "This option allows you to set the reach of Cestus'.");
        toolDurability = configuration.getInt("0-Weapon/Tool Durability", "6-Material Modifiers", 0, 0, 2, "Setting this option to '1' will half weapon/tool durability, '2' will double it, '0' will do nothing.");
        gildedDurability = configuration.getInt("1-Gilded Durability Modifiers", "6-Material Modifiers", 200, 0, 5000, "Durability modifier for Gilded material items.");
        gildedDamage = configuration.getFloat("1-Gilded Damage Modifiers", "6-Material Modifiers", 2.0f, 0.0f, 5000.0f, "Damage modifier for Gilded material items.");
        jewelledDurability = configuration.getInt("2-Jewelled Durability Modifiers", "6-Material Modifiers", 1000, 0, 5000, "Durability modifier for Jewelled material items.");
        jewelledDamage = configuration.getFloat("2-Jewelled Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Jewelled material items.");
        tinDurability = configuration.getInt("3-Tin Durability Modifiers", "6-Material Modifiers", 150, 0, 5000, "Durability modifier for Tin material items.");
        tinDamage = configuration.getFloat("3-Tin Damage Modifiers", "6-Material Modifiers", 1.2f, 0.0f, 5000.0f, "Damage modifier for Tin material items.");
        copperDurability = configuration.getInt("4-Copper Durability Modifiers", "6-Material Modifiers", 180, 0, 5000, "Durability modifier for Copper material items.");
        copperDamage = configuration.getFloat("4-Copper Damage Modifiers", "6-Material Modifiers", 1.5f, 0.0f, 5000.0f, "Damage modifier for Copper material items.");
        bronzeDurability = configuration.getInt("5-Bronze Durability Modifiers", "6-Material Modifiers", 300, 0, 5000, "Durability modifier for Bronze material items.");
        bronzeDamage = configuration.getFloat("5-Bronze Damage Modifiers", "6-Material Modifiers", 2.0f, 0.0f, 5000.0f, "Damage modifier for Bronze material items.");
        leadDurability = configuration.getInt("6-Lead Durability Modifiers", "6-Material Modifiers", 160, 0, 5000, "Durability modifier for Lead material items.");
        leadDamage = configuration.getFloat("6-Lead Damage Modifiers", "6-Material Modifiers", 2.0f, 0.0f, 5000.0f, "Damage modifier for Lead material items.");
        invarDurability = configuration.getInt("7-Invar Durability Modifiers", "6-Material Modifiers", 450, 0, 5000, "Durability modifier for Invar material items.");
        invarDamage = configuration.getFloat("7-Invar Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Invar material items.");
        steelDurability = configuration.getInt("8-Steel Durability Modifiers", "6-Material Modifiers", 500, 0, 5000, "Durability modifier for Steel material items.");
        steelDamage = configuration.getFloat("8-Steel Damage Modifiers", "6-Material Modifiers", 2.5f, 0.0f, 5000.0f, "Damage modifier for Steel material items.");
        silverDurability = configuration.getInt("9-Silver Durability Modifiers", "6-Material Modifiers", 200, 0, 5000, "Durability modifier for Silver material items.");
        silverDamage = configuration.getFloat("9-Silver Damage Modifiers", "6-Material Modifiers", 1.7f, 0.0f, 5000.0f, "Damage modifier for Silver material items.");
        electrumDurability = configuration.getInt("10-Electrum Durability Modifiers", "6-Material Modifiers", 200, 0, 5000, "Durability modifier for Electrum material items.");
        electrumDamage = configuration.getFloat("10-Electrum Damage Modifiers", "6-Material Modifiers", 2.0f, 0.0f, 5000.0f, "Damage modifier for Electrum material items.");
        platinumDurability = configuration.getInt("11-Platinum Durability Modifiers", "6-Material Modifiers", 1400, 0, 5000, "Durability modifier for Platinum material items.");
        platinumDamage = configuration.getFloat("11-Platinum Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Platinum material items.");
        tungstenDurability = configuration.getInt("12-Tungsten Durability Modifiers", "6-Material Modifiers", 1400, 0, 5000, "Durability modifier for Tungsten material items.");
        tungstenDamage = configuration.getFloat("12-Tungsten Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Tungsten material items.");
        titaniumDurability = configuration.getInt("13-Titanium Durability Modifiers", "6-Material Modifiers", 1400, 0, 5000, "Durability modifier for Titanium material items.");
        titaniumDamage = configuration.getFloat("13-Titanium Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Titanium material items.");
        osmiumDurability = configuration.getInt("14-Osmium Durability Modifiers", "6-Material Modifiers", 500, 0, 5000, "Durability modifier for Osmium material items.");
        osmiumDamage = configuration.getFloat("14-Osmium Damage Modifiers", "6-Material Modifiers", 4.0f, 0.0f, 5000.0f, "Damage modifier for Osmium material items.");
        emeraldDurability = configuration.getInt("15-Emerald Durability Modifiers", "6-Material Modifiers", 600, 0, 5000, "Durability modifier for Emerald material items.");
        emeraldDamage = configuration.getFloat("15-Emerald Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Emerald material items.");
        rubyDurability = configuration.getInt("16-Ruby Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Ruby material items.");
        rubyDamage = configuration.getFloat("16-Ruby Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Ruby material items.");
        sapphireDurability = configuration.getInt("17-Sapphire Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Sapphire material items.");
        sapphireDamage = configuration.getFloat("17-Sapphire Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Sapphire material items.");
        peridotDurability = configuration.getInt("18-Peridot Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Peridot material items.");
        peridotDamage = configuration.getFloat("18-Peridot Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Peridot material items.");
        amethystDurability = configuration.getInt("19-Amethyst Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Amethyst material items.");
        amethystDamage = configuration.getFloat("19-Amethyst Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Amethyst material items.");
        crystalDurability = configuration.getInt("20-Crystal Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Crystal material items.");
        crystalDamage = configuration.getFloat("20-Crystal Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Crystal material items.");
        topazDurability = configuration.getInt("21-Topaz Durability Modifiers", "6-Material Modifiers", 400, 0, 5000, "Durability modifier for Topaz material items.");
        topazDamage = configuration.getFloat("21-Topaz Damage Modifiers", "6-Material Modifiers", 2.7f, 0.0f, 5000.0f, "Damage modifier for Topaz material items.");
        soulsteelDurability = configuration.getInt("22-Soulforged Steel Durability Modifiers", "6-Material Modifiers", 1561, 0, 5000, "Durability modifier for Soulforged Steel material items.");
        soulsteelDamage = configuration.getFloat("22-Soulforged Steel Damage Modifiers", "6-Material Modifiers", 3.0f, 0.0f, 5000.0f, "Damage modifier for Soulforged Steel material items.");
        trinketSpeed = configuration.getFloat("1-Trinket Speed Boost", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Speed Effect.");
        trinketJump = configuration.getFloat("2-Trinket Jump Boost", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Jump Effect.");
        trinketMining = configuration.getFloat("3-Trinket Minging Haste", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Mining Haste Effect.");
        trinketGills = configuration.getFloat("4-Trinket Water Breathing", "6-Other Modifiers", 0.2f, 0.0f, 100.0f, "Hunger cost value for Trinket Gills Effect.");
        trinketNightVision = configuration.getFloat("5-Trinket Night Vision", "6-Other Modifiers", 0.2f, 0.0f, 100.0f, "Hunger cost value for Trinket Night Vision Effect.");
        trinketFire = configuration.getFloat("6-Trinket Fire Resistance", "6-Other Modifiers", 0.3f, 0.0f, 100.0f, "Hunger cost value for Trinket Fire Resistance Effect.");
        trinketResistance = configuration.getFloat("7-Trinket Resistance", "6-Other Modifiers", 0.3f, 0.0f, 100.0f, "Hunger cost value for Trinket Stone Skin Effect.");
        trinketStrength = configuration.getFloat("8-Trinket Strength", "6-Other Modifiers", 0.4f, 0.0f, 100.0f, "Hunger cost value for Trinket Strength Effect.");
        trinketInvisibility = configuration.getFloat("9-Trinket Invisibility", "6-Other Modifiers", 0.4f, 0.0f, 100.0f, "Hunger cost value for Trinket Invisibilty Effect.");
        oreClustersOverride = configuration.getBoolean("0.0-Cluster Output Override", "4-OreClusterOverrides", false, "Set 'true' to override Ore Cluster smelting outputs.");
        ironOverride = configuration.getStringList("0.1-Iron Override", "4-OreClusterOverrides", Reference.IRONOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:iron_ingot or 265. If specified item does not exist, cluster will not be smeltable.");
        goldOverride = configuration.getStringList("0.2-Gold Override", "4-OreClusterOverrides", Reference.GOLDOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:gold_ingot or 266. If specified item does not exist, cluster will not be smeltable.");
        tinOverride = configuration.getStringList("0.3-Tin Override", "4-OreClusterOverrides", Reference.TINOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        copperOverride = configuration.getStringList("0.4-Copper Override", "4-OreClusterOverrides", Reference.COPPEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        leadOverride = configuration.getStringList("0.5-Lead Override", "4-OreClusterOverrides", Reference.LEADOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        silverOverride = configuration.getStringList("0.6-Silver Override", "4-OreClusterOverrides", Reference.SILVEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        platinumOverride = configuration.getStringList("0.7-Platinum Override", "4-OreClusterOverrides", Reference.PLATINUMOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        tungstenOverride = configuration.getStringList("0.8-Tungsten Override", "4-OreClusterOverrides", Reference.TUNGSTENOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        titaniumOverride = configuration.getStringList("0.9-Titanium Override", "4-OreClusterOverrides", Reference.TITANIUMOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        ducttapeWhite = configuration.getStringList("1-Ductape White List", "2-Ducttapableslists", Reference.DUCTTAPEWHITELISTDEFAULT, "White List of items that can be repaired with Duct Tape. Weapons, tools, and armour should be detected by default.");
        ducttapeBlack = configuration.getStringList("2-Ductape Black List", "2-Ducttapableslists", Reference.DUCTTAPEBLACKLISTDEFAULT, "Black List of items that can not be repaired with Duct Tape. Example 'minecraft:fishing_rod'. Leave this EMPTY to blacklist ALL.");
        slingshotWhite = configuration.getStringList("1-Slingshot Ammo White List", "3-SlingshotAmmo", Reference.SLINGSHOTWHITELISTDEFAULT, "White List of items that can be used as ammo for the Slingshot. Items oreDicted as 'seeds' will be detected automatically.");
        slingshotBlack = configuration.getStringList("2-Slingshot Ammo Black List", "3-SlingshotAmmo", Reference.SLINGSHOTBLACKLISTDEFAULT, "Black List of items that can not used as ammo for the Slingshot.");
        netherGold = configuration.getInt("1.1-Nether Gold", "7-World", 6, 0, 100, "Number of times to attempt to generate Gold per chunk. Set to 0 to disable Gold from being generated in the Nether.");
        stoneQuartz = configuration.getInt("1.2-Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Quartz per chunk. Set to 0 to disable Quartz from being generated in the Overworld.");
        endDiamond = configuration.getInt("1.3-Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Diamond per chunk. Set to 0 to disable Diamond from being generated in the End.");
        endLapis = configuration.getInt("1.4-Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Lapis per chunk. Set to 0 to disable Lapis from being generated in the End.");
        flowers = configuration.getInt("2-Flower Generation", "7-World", 32, 0, 100, "Set higher for more Dungeon Tactics Flowers.");
        flowerBiomes = configuration.getStringList("1-Flower Biomes", "8-WorldGen", Reference.FLOWERBIOMESDEFAULT, "Whitelist of biomes where Dungeon Tactics Flowers can be generated (only effects worldgen).");
        dungeons = configuration.getBoolean("3-Dungeon Generation", "7-World", true, "Set 'false' to disable Dungeon Tactics structures.");
        shipSpacing = configuration.getInt("4.2-Ship Spacing", "7-World", 500, 50, 5000, "Rough distance between Ships (Only generated in oceans).");
        dungeonSpacing = configuration.getInt("4.1-Dungeon Spacing", "7-World", 1000, 50, 5000, "Rough distance between Towers/Dungeons.");
        dungeonDimensions = configuration.getStringList("4.3-Structure Dimensions", "7-World", Reference.DUNGEONDIMENSIONSDEFAULT, "Whitelist of dimensions in which Dungeon Tactics Structures can be generated.");
        dungeonMinHeight = configuration.getInt("5.1-Dungeon MinHeight", "7-World", 3, 0, 20, "Minimum floors for towers to generate (Setting this higher than 'Max Height' will make all towers this height).");
        dungeonMaxHeight = configuration.getInt("5.2-Dungeon MaxHeight", "7-World", 10, 0, 20, "Maximum floors for towers to generate.");
        netherDungeonChance = configuration.getInt("5.3-Nether Variant Chance", "7-World", 9, 0, 100, "Percentage chance for Towers/Dungeons to be 'Nether themed'. This only effects Overworld Towers/Dungeons. Set to 100 for guarenteed chance, 0 to disable.");
        DTConfigHandler.DimensionConfig("4.3-Structure Dimensions", "7-World", Reference.DUNGEONDIMENSIONSDEFAULT);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void DimensionConfig(String name, String category, String ... defaultStrs) {
        String[] dimStrs = configuration.getStringList(name, category, defaultStrs, "");
        dims = new ArrayList<Integer>();
        for (String s : dimStrs) {
            try {
                dims.add(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean canSpawnHere(World world) {
        return dims.contains(world.field_73011_w.getDimension());
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("dungeontactics")) {
            DTConfigHandler.loadConfiguration();
        }
    }

    static {
        hearts = 20;
        extraHearts = 20;
        boneCharms = 10;
        breakCharms = 7;
        potionFish = 7;
        flamerBehaviour = true;
        oreClusters = true;
        oreDusters = false;
        lootbags = 10;
        attackBot = true;
        sitting = true;
        seasonal = true;
        modifyLoot = true;
        weaponSpawn = true;
        invisNoArmour = true;
        swapArmour = true;
        quickLadders = true;
        chainCreepers = true;
        hammerDamage = 7.0f;
        hammerSpeed = -3.1f;
        battleaxeDamage = 7.2f;
        battleaxeSpeed = -3.3f;
        glaiveDamage = 3.3f;
        glaiveSpeed = -2.8f;
        glaiveReach = 4.5f;
        cutlassDamage = 2.0f;
        cutlassSpeed = -2.0f;
        knifeDamage = 1.0f;
        knifeSpeed = -1.0f;
        knifeReach = 2.5f;
        cestusDamage = 0.5f;
        cestusSpeed = 1.0f;
        cestusReach = 2.0f;
        toolDurability = 0;
        gildedDurability = 200;
        gildedDamage = 2.0f;
        jewelledDurability = 1000;
        jewelledDamage = 3.0f;
        tinDurability = 150;
        tinDamage = 1.2f;
        copperDurability = 180;
        copperDamage = 1.5f;
        bronzeDurability = 300;
        bronzeDamage = 2.0f;
        leadDurability = 160;
        leadDamage = 2.0f;
        invarDurability = 450;
        invarDamage = 3.0f;
        steelDurability = 500;
        steelDamage = 2.5f;
        silverDurability = 200;
        silverDamage = 1.7f;
        electrumDurability = 200;
        electrumDamage = 2.0f;
        platinumDurability = 1400;
        platinumDamage = 3.0f;
        tungstenDurability = 1400;
        tungstenDamage = 3.0f;
        titaniumDurability = 1400;
        titaniumDamage = 3.0f;
        osmiumDurability = 500;
        osmiumDamage = 4.0f;
        emeraldDurability = 600;
        emeraldDamage = 3.0f;
        rubyDurability = 400;
        rubyDamage = 2.7f;
        sapphireDurability = 400;
        sapphireDamage = 2.7f;
        peridotDurability = 400;
        peridotDamage = 2.7f;
        amethystDurability = 400;
        amethystDamage = 2.7f;
        crystalDurability = 400;
        crystalDamage = 2.7f;
        topazDurability = 400;
        topazDamage = 2.7f;
        soulsteelDurability = 1561;
        soulsteelDamage = 3.0f;
        trinketSpeed = 0.1f;
        trinketJump = 0.1f;
        trinketMining = 0.1f;
        trinketGills = 0.2f;
        trinketNightVision = 0.2f;
        trinketFire = 0.3f;
        trinketResistance = 0.3f;
        trinketStrength = 0.4f;
        trinketInvisibility = 0.4f;
        oreClustersOverride = false;
        ironOverride = Reference.IRONOVERRIDEDEFAULT;
        goldOverride = Reference.GOLDOVERRIDEDEFAULT;
        tinOverride = Reference.TINOVERRIDEDEFAULT;
        copperOverride = Reference.COPPEROVERRIDEDEFAULT;
        leadOverride = Reference.LEADOVERRIDEDEFAULT;
        silverOverride = Reference.SILVEROVERRIDEDEFAULT;
        platinumOverride = Reference.PLATINUMOVERRIDEDEFAULT;
        tungstenOverride = Reference.TUNGSTENOVERRIDEDEFAULT;
        titaniumOverride = Reference.TITANIUMOVERRIDEDEFAULT;
        ducttapeWhite = Reference.DUCTTAPEWHITELISTDEFAULT;
        ducttapeBlack = Reference.DUCTTAPEBLACKLISTDEFAULT;
        slingshotWhite = Reference.SLINGSHOTWHITELISTDEFAULT;
        slingshotBlack = Reference.SLINGSHOTBLACKLISTDEFAULT;
        netherGold = 6;
        stoneQuartz = 6;
        endDiamond = 6;
        endLapis = 6;
        flowers = 32;
        flowerBiomes = Reference.FLOWERBIOMESDEFAULT;
        dungeons = true;
        shipSpacing = 500;
        dungeonSpacing = 1000;
        dungeonDimensions = Reference.DUNGEONDIMENSIONSDEFAULT;
        dungeonMinHeight = 3;
        dungeonMaxHeight = 10;
        netherDungeonChance = 9;
    }
}

