/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.entities.projectiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;

public class DTThrowableGeneric
extends EntityThrowable
implements IProjectile {
    public int lifespan = 6000;
    public boolean cluster = false;
    public int fuse = 0;
    public float explosionRadius = 1.5f;
    private int ignoreTime;

    public DTThrowableGeneric(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.4f);
        this.field_70156_m = true;
    }

    public DTThrowableGeneric(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    public DTThrowableGeneric(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    public void func_184538_a(Entity thrower, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        float f = (float)Math.PI / 180;
        float x = -MathHelper.func_76126_a((float)(yaw * f)) * MathHelper.func_76134_b((float)(pitch * f));
        float y = -MathHelper.func_76126_a((float)((pitch + pitchOffset) * f));
        float z = MathHelper.func_76134_b((float)(yaw * f)) * MathHelper.func_76134_b((float)(pitch * f));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70186_c(x, y, z, velocity, inaccuracy);
        this.field_70159_w += thrower.field_70159_w;
        this.field_70179_y += thrower.field_70179_y;
        if (!thrower.field_70122_E) {
            this.field_70181_x += thrower.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_70071_h_() {
        Entity entity;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.getHitEntity(vec3d, vec3d1)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            this.func_70184_a(raytraceresult);
        }
        if (this.field_70122_E || this.field_70132_H) {
            this.field_70159_w *= 0.7;
            this.field_70181_x *= -0.5;
            this.field_70179_y *= 0.7;
        }
        if (--this.lifespan <= 0) {
            this.func_70184_a(raytraceresult);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        this.field_70132_H = true;
        if (result.field_72308_g != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    protected void killFish(double x, double y, double z) {
        double newX = x + (double)(this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2));
        double newY = y + this.field_70146_Z.nextDouble();
        double newZ = z + (double)(this.field_70146_Z.nextInt(2) - this.field_70146_Z.nextInt(2));
        LootContext.Builder build = new LootContext.Builder((WorldServer)this.func_130014_f_());
        for (ItemStack stack : this.func_130014_f_().func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.func_130014_f_().field_73012_v, build.func_186471_a())) {
            EntityItem item = new EntityItem(this.func_130014_f_(), newX, newY, newZ, stack.func_77946_l());
            this.func_130014_f_().func_72838_d((Entity)item);
        }
    }

    @Nullable
    private Entity getHitEntity(Vec3d vec1, Vec3d vec2) {
        Entity target = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L()) continue;
            if (entity == this.field_184539_c) {
                flag = true;
                continue;
            }
            if (this.func_85052_h() != null && this.field_70173_aa < 2 && this.field_184539_c == null) {
                this.field_184539_c = entity;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec1, vec2);
            if (raytraceresult1 == null || !((d1 = vec1.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            target = entity;
            d0 = d1;
        }
        if (this.field_184539_c != null) {
            if (flag) {
                this.ignoreTime = 2;
            } else if (this.ignoreTime-- <= 0) {
                this.field_184539_c = null;
            }
        }
        return target;
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("lifespan", this.lifespan);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.lifespan = tagCompound.func_74762_e("lifespan") != 0 ? tagCompound.func_74762_e("lifespan") : 20;
    }
}

