/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks.tileentities;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pegbeard.dungeontactics.blocks.DTCauldron;
import pegbeard.dungeontactics.blocks.DTFlamerBlock;
import pegbeard.dungeontactics.blocks.DTPowderkeg;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;

public class DTFlamerTile
extends TileEntity
implements ITickable {
    static boolean behaviour = DTConfigHandler.configuration.get("1-Feature", "6-Flamer Behaviour", true).getBoolean(true);
    private boolean isPowered = false;
    private int range = 5;

    public void whilePowered(World world, BlockPos pos, IBlockState state, Random rand) {
        List list;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DTFlamerBlock.FACING);
        BlockPos frontPos = new BlockPos(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
        Block block = world.func_180495_p(frontPos).func_177230_c();
        if (behaviour) {
            TileEntity brewStand;
            TileEntity furnace;
            if (block instanceof DTCauldron) {
                return;
            }
            if (block instanceof BlockFurnace && (furnace = world.func_175625_s(frontPos)) != null) {
                this.igniteFurnace((TileEntityFurnace)furnace);
            }
            if (block instanceof BlockBrewingStand && (brewStand = world.func_175625_s(frontPos)) != null) {
                this.igniteBrewingStand((TileEntityBrewingStand)brewStand);
            }
            if (block instanceof BlockPackedIce || block instanceof BlockIce || block instanceof BlockNetherrack || block instanceof BlockMagma || !FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block)).func_190926_b()) {
                this.tryBurn(world, facing, rand);
            }
        }
        if (!this.canPass(block) && !this.notObstructed(world, null, facing) && (!block.func_176205_b((IBlockAccess)world, frontPos) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, frontPos, facing) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, frontPos, facing.func_176734_d()) || block instanceof BlockLiquid || block instanceof BlockCauldron)) {
            return;
        }
        this.tryBurn(world, facing, rand);
        if (world.func_175687_A(pos) > 0 && !(list = world.func_72872_a(Entity.class, this.getDirection(state))).isEmpty()) {
            for (Entity entity : list) {
                double d0 = this.getDistanceSqToEntity(entity);
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                float j = (float)(d1 * 10.0 + 0.5);
                if (!this.notObstructed(world, entity, facing)) {
                    return;
                }
                if (entity == null) continue;
                if (entity instanceof EntityLivingBase) {
                    entity.func_70097_a(DamageSource.field_76372_a, j);
                }
                if (entity.func_70027_ad() || rand.nextInt(3) != 0) continue;
                if (j < 1.0f) {
                    j = 1.0f;
                }
                entity.func_70015_d(2 + (int)j);
            }
        }
    }

    public void func_73660_a() {
        if (this.getPowered()) {
            this.whilePowered(this.func_145831_w(), this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().field_73012_v);
        }
    }

    public boolean getPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean b) {
        this.isPowered = b;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int r) {
        this.range = r;
    }

    public AxisAlignedBB getDirection(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DTFlamerBlock.FACING);
        int r = this.getRange();
        switch (facing) {
            case NORTH: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177964_d(r).func_177952_p() + 1.0);
            }
            case EAST: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177965_g(r).func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177970_e(r).func_177952_p() + 1.0);
            }
            case WEST: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177985_f(r).func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case UP: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177981_b(r).func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
            case DOWN: {
                return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177979_c(r).func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.0);
            }
        }
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n() + 1.0, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177964_d(r).func_177952_p() + 1.0);
    }

    public void igniteFurnace(TileEntityFurnace furnace) {
        boolean flag = furnace.func_145950_i();
        int burnTimeField = 0;
        if (furnace.func_174887_a_(burnTimeField) == 0) {
            furnace.func_174885_b(burnTimeField, furnace.func_174887_a_(burnTimeField) + 2);
        }
        if (furnace.func_174887_a_(burnTimeField) < 200) {
            furnace.func_174885_b(burnTimeField, furnace.func_174887_a_(burnTimeField) + 1);
            if (flag != furnace.func_145950_i()) {
                BlockFurnace.func_176446_a((furnace.func_174887_a_(burnTimeField) > 0 ? 1 : 0) != 0, (World)furnace.func_145831_w(), (BlockPos)furnace.func_174877_v());
            }
        }
    }

    public void igniteBrewingStand(TileEntityBrewingStand brewStand) {
        int fuelTimeField = 1;
        if (brewStand.func_174887_a_(fuelTimeField) < 1) {
            brewStand.func_174885_b(fuelTimeField, 1);
        }
    }

    public boolean notObstructed(World world, Entity entity, EnumFacing facing) {
        for (int i = 1; i < this.getRange(); ++i) {
            BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()).func_177967_a(facing, i);
            Block block = world.func_180495_p(pos).func_177230_c();
            if (this.canPass(block) || block.func_176205_b((IBlockAccess)world, pos) && !block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing) && !block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing.func_176734_d()) && !(block instanceof BlockLiquid)) continue;
            this.tryBurn(world, facing, world.field_73012_v);
            if (entity != null && !(entity.func_180425_c().func_177954_c((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) > pos.func_177954_c((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()))) continue;
            return false;
        }
        return true;
    }

    public void tryBurn(World world, EnumFacing facing, Random rand) {
        if (world.func_82736_K().func_82766_b("doFireTick")) {
            for (int i = 1; i < this.getRange(); ++i) {
                BlockPos pos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()).func_177967_a(facing, i);
                Block block = world.func_180495_p(pos).func_177230_c();
                if (block != Blocks.field_150350_a && behaviour) {
                    if (block instanceof DTPowderkeg) {
                        if (rand.nextInt(100) == 0) {
                            ((DTPowderkeg)block).explode(world, pos, world.func_180495_p(pos), null);
                            world.func_175698_g(pos);
                            world.func_184133_a(null, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockTNT) {
                        if (rand.nextInt(100) == 0) {
                            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)), 2);
                            ((BlockTNT)block).func_180692_a(world, pos, world.func_180495_p(pos), (EntityLivingBase)null);
                            world.func_175698_g(pos);
                            world.func_184133_a(null, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockNetherrack) {
                        if (rand.nextInt(500) == 0) {
                            world.func_180501_a(pos, Blocks.field_189877_df.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockMagma) {
                        if (rand.nextInt(500) == 0) {
                            world.func_180501_a(pos, Blocks.field_150356_k.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockPackedIce) {
                        if (rand.nextInt(500) == 0) {
                            world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockIce) {
                        if (rand.nextInt(500) == 0) {
                            world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (block instanceof BlockOre || block instanceof BlockLog) {
                        ItemStack smelted;
                        if (rand.nextInt(500) == 0 && !(smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block))).func_190926_b()) {
                            world.func_175698_g(pos);
                            EntityItem drop = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), smelted);
                            world.func_72838_d((Entity)drop);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (!FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block)).func_190926_b()) {
                        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(block));
                        Block smeltedblock = Block.func_149634_a((Item)smelted.func_77973_b());
                        if (smeltedblock != null && rand.nextInt(500) == 0) {
                            world.func_180501_a(pos, smeltedblock.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                    if (!(block instanceof DTPowderkeg) && !(block instanceof BlockTNT) && block.isFlammable((IBlockAccess)world, pos, facing.func_176734_d())) {
                        if (rand.nextInt(100) == 0) {
                            world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
                            world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 0.2f, 1.0f / (rand.nextFloat() * 0.4f + 1.2f));
                        }
                        return;
                    }
                }
                if (!this.canPass(block) && (!block.func_176205_b((IBlockAccess)world, pos) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing) || block.isSideSolid(block.func_176223_P(), (IBlockAccess)world, pos, facing.func_176734_d()) || block instanceof BlockLiquid)) {
                    return;
                }
                if (block != Blocks.field_150350_a || !world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) continue;
                if (rand.nextInt(1000) == 0) {
                    world.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 2);
                }
                return;
            }
        }
    }

    public boolean canPass(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150362_t || block == Blocks.field_150361_u || block == Blocks.field_150376_bx || block == Blocks.field_150333_U || block == Blocks.field_180389_cP || block instanceof BlockFence || block == Blocks.field_150411_aY || block == DTBlocks.POWERED_FENCE || block == Blocks.field_150488_af || block == Blocks.field_150429_aA || block == Blocks.field_150437_az || block == Blocks.field_150473_bD || block == Blocks.field_150480_ab;
    }

    public double getDistanceSqToEntity(Entity entity) {
        double d0 = (double)this.func_174877_v().func_177958_n() - entity.field_70165_t;
        double d1 = (double)this.func_174877_v().func_177956_o() - entity.field_70163_u;
        double d2 = (double)this.func_174877_v().func_177952_p() - entity.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("isPowered", this.getPowered());
        return super.func_189515_b(nbttagcompound);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setPowered(nbttagcompound.func_74767_n("isPowered"));
    }
}

