/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks.tileentities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class DTBarrelTile
extends TileEntityLockableLoot
implements ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    protected String BARREL_GUI_IG = "minecraft:dispenser";
    protected String BARREL_GUI_NAME = "container.dungeontactics:barrel.name";
    private int transferCooldown = -1;
    private long tickedGameTime;

    public static void registerFixesBarrel(DataFixer fixer) {
        fixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemStackDataLists(DTBarrelTile.class, new String[]{"Items"}));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return super.func_189515_b(compound);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : this.BARREL_GUI_NAME;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateBarrel();
            }
        }
    }

    protected boolean updateBarrel() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.isOnTransferCooldown()) {
                boolean flag = false;
                if (!this.isFull()) {
                    boolean bl = flag = DTBarrelTile.captureDroppedItems(this) || flag;
                }
                if (flag) {
                    this.setTransferCooldown(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isInventoryEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static boolean captureDroppedItems(DTBarrelTile barrel) {
        for (EntityItem entityitem : DTBarrelTile.getCaptureItems(barrel.func_145831_w(), barrel.getXPos(), barrel.getYPos(), barrel.getZPos())) {
            if (!DTBarrelTile.putDropInInventoryAllSlots(null, (IInventory)barrel, entityitem)) continue;
            return true;
        }
        return false;
    }

    public static boolean putDropInInventoryAllSlots(IInventory source, IInventory destination, EntityItem entity) {
        boolean flag = false;
        if (entity == null) {
            return false;
        }
        ItemStack itemstack = entity.func_92059_d().func_77946_l();
        ItemStack itemstack1 = DTBarrelTile.putStackInInventoryAllSlots(source, destination, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            entity.func_70106_y();
        } else {
            entity.func_92058_a(itemstack1);
        }
        return flag;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory source, IInventory destination, ItemStack stack, @Nullable EnumFacing direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory isidedinventory = (ISidedInventory)destination;
            int[] aint = isidedinventory.func_180463_a(direction);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = DTBarrelTile.insertStack(source, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = DTBarrelTile.insertStack(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory source, IInventory destination, ItemStack stack, int index, EnumFacing direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (DTBarrelTile.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (DTBarrelTile.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                DTBarrelTile tileentitybarrel1;
                if (flag1 && destination instanceof DTBarrelTile && !(tileentitybarrel1 = (DTBarrelTile)destination).mayTransfer()) {
                    int k = 0;
                    if (source != null && source instanceof DTBarrelTile) {
                        DTBarrelTile tileentitybarrel = (DTBarrelTile)source;
                        if (tileentitybarrel1.tickedGameTime >= tileentitybarrel.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentitybarrel1.setTransferCooldown(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    public static List<EntityItem> getCaptureItems(World world, double x, double y, double z) {
        return world.func_175647_a(EntityItem.class, new AxisAlignedBB(x - 0.5, y, z - 0.5, x + 0.5, y + 1.5, z + 0.5), EntitySelectors.field_94557_a);
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    public String func_174875_k() {
        return this.BARREL_GUI_IG;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        this.func_184281_d(player);
        return new ContainerDispenser((IInventory)playerInventory, (IInventory)this);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    public double getXPos() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double getYPos() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double getZPos() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

