/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.mc;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.mc.AromaBackup;
import aroma1997.core.config.Conf;
import java.io.File;
import java.util.Date;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class Config {
    public static final Config instance = new Config();
    private static final String CATEGORY_BACKUP = "BACKUP";
    private static final String CATEGORY_SCHEDULE = "BACKUP_SCHEDULE";
    private static final String CATEGORY_LOCATION = "BACKUP_LOCATION";
    private final Configuration config = Conf.getConfig((String)"aromabackup");
    public boolean allPlayers;
    public String location;
    private String filename;
    private String compression;
    public int toKeepFull;
    public int toKeepIncremental;
    public int toCreateincremental;
    public long delay;
    public boolean onStartup;
    public boolean skipBackup;
    public int compressionRate;
    public boolean useWhitelist;
    private int[] whitelist;
    private int[] blacklist;

    public void reload() {
        this.config.load();
        this.allPlayers = this.config.get("general", "allPlayers", true, "If all players or only admins can use the /backup command.").getBoolean(true);
        this.location = this.config.get(CATEGORY_LOCATION, "location", "./backups", "Where to store the Backups. Either an absolute path or relative to the minecraft folder.").getString();
        this.delay = this.config.get(CATEGORY_SCHEDULE, "delay", 30, "How frequently a automatic backup is done in minutes. 0 means Auto-Backup disabled.").getInt();
        this.onStartup = this.config.get(CATEGORY_SCHEDULE, "onStartup", true, "If a backup should be done when the world gets loaded.").getBoolean(true);
        this.skipBackup = this.config.get(CATEGORY_SCHEDULE, "skipbackup", true, "If the scheduled backup should be skipped if no players were on the server since the last one.").getBoolean(true);
        if (this.delay <= 0L) {
            this.delay = 0L;
            AromaBackup.instance.logger.log(Level.WARN, "Automatic backups disabled. This is not recommended.");
        } else {
            this.delay *= 60000L;
        }
        Property compression = this.config.get("general", "compressionRate", 5, "Compression rate. Has to be between 9 (high compression) and 1 (low compression).");
        this.compressionRate = compression.getInt();
        if (this.compressionRate > 9 || this.compressionRate < 1) {
            compression.set(5);
            this.compressionRate = 5;
        }
        this.useWhitelist = this.config.get("general", "useWhitelist", false, "If this is set to true, it will use the Dimension Whitelist, if it is false, it will use the Dimension Blacklist").getBoolean();
        this.whitelist = this.config.get("general", "whitelist", new int[]{0, 1, -1}, "If the whitelist is enabled, only the dimensions (ids) specified here will be backed up.").getIntList();
        this.blacklist = this.config.get("general", "blacklist", new int[0], "If the blacklist is enabled, the dimensions (ids) specified here will not be backed up.").getIntList();
        AromaBackup.instance.logger.log(Level.INFO, (this.useWhitelist ? "Using Dimension Whitelist " : "Using Dimension Blacklist ") + "with  " + (this.useWhitelist ? this.whitelist.length : this.blacklist.length) + " entries.");
        compression = this.config.get(CATEGORY_BACKUP, "compressionType", "zip");
        String comment = "The compression type used for backups. The following ones are available: ";
        for (String compressionName : CompressionHelper.getRegisteredCompressions().keySet()) {
            comment = comment + "\"" + compressionName + "\", ";
        }
        comment = comment.substring(0, comment.length() - 2);
        compression.setComment(comment);
        if (CompressionHelper.getCompression(compression.getString()) == null) {
            compression.setValue("zip");
        }
        this.compression = compression.getString();
        this.filename = this.config.getString("filename", CATEGORY_LOCATION, "%world%/Backup--%world%--%year%-%month%-%date%--%hour%-%minute%", "The filename of the backup files. Supported variables: \r\n world, year, month, date, hour, minute, second, identifier. \r\n Please note: using the identifier is recommended, but not enforced. Please make sure, that your filenames are unique and that two backups will not have the same filename.");
        this.toKeepFull = this.config.getInt("fullBackupsToKeep", CATEGORY_SCHEDULE, 30, 1, Integer.MAX_VALUE, "How many full backups to keep. When there are this many full backups, the oldest full backup will be deleted together with all incremental backups, that depend on it.");
        this.toKeepIncremental = this.config.getInt("incrementalBackupsToKeep", CATEGORY_SCHEDULE, 100, 1, Integer.MAX_VALUE, "How many incremental backups to keep. When there are this many incremental backups, the oldest incremental backup will be deleted together with all backups, that depend on it.");
        this.toCreateincremental = this.config.getInt("incrementalBackupsToCreate", CATEGORY_SCHEDULE, 0, 0, 500, "How many incremental backups to create. Set to something bigger that 0 to enable. If this is set to for example 5, then there will be one full backup, 5 incremental backups and then the next full backup and so on.");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public boolean shouldSaveDimension(int dim) {
        if (this.useWhitelist) {
            for (int i = 0; i < this.whitelist.length; ++i) {
                if (this.whitelist[i] != dim) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.blacklist.length; ++i) {
            if (this.blacklist[i] != dim) continue;
            return false;
        }
        return true;
    }

    public File getBackupFile(String world, Date date) {
        int year = date.getYear() + 1900;
        int month = date.getMonth() + 1;
        int day = date.getDate();
        int hour = date.getHours();
        int minute = date.getMinutes();
        int second = date.getSeconds();
        long identifier = date.getTime();
        String name = this.filename.replace("%world%", world).replace("%year%", "" + year).replace("%month%", String.format("%02d", month)).replace("%date%", String.format("%02d", day)).replace("%hour%", String.format("%02d", hour)).replace("%minute%", String.format("%02d", minute)).replace("%second%", String.format("%02d", second)).replace("%identifier%", "" + identifier);
        return new File(this.location + "/" + name + "." + this.compression);
    }
}

