/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.compression;

import aroma1997.backup.common.compression.ICompression;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CompressionHelper {
    private static final Map<String, ICompression> compressions = new HashMap<String, ICompression>();
    public static final int DEFAULT_BLOCK_SIZE = 4096;

    private CompressionHelper() {
    }

    public static void registerCompressionForExtension(String extension, ICompression compression) {
        if (compressions.containsKey(extension = extension.toLowerCase())) {
            throw new IllegalArgumentException("Compression handler for file extension " + extension + "already exists.");
        }
        compressions.put(extension, compression);
    }

    public static ICompression getCompression(String extension) {
        if (extension == null) {
            return null;
        }
        return compressions.get(extension.toLowerCase());
    }

    public static Map<String, ICompression> getRegisteredCompressions() {
        return Collections.unmodifiableMap(compressions);
    }

    public static Map<File, String> listFiles(File dir) {
        HashMap<File, String> map = new HashMap<File, String>();
        for (File sub : dir.listFiles()) {
            CompressionHelper.discover(map, sub, "");
        }
        return map;
    }

    static void discover(Map<File, String> map, File file, String target) {
        String newTarget = CompressionHelper.appendFilename(target, file.getName());
        if (file.isFile()) {
            map.put(file, target);
        }
        if (file.isDirectory()) {
            File[] subFiles;
            for (File sub : subFiles = file.listFiles()) {
                CompressionHelper.discover(map, sub, newTarget);
            }
        }
    }

    public static String appendFilename(String dir, String name) {
        if (dir.isEmpty()) {
            return name;
        }
        return dir + "/" + name;
    }

    public static String getFilenameFromStructure(String struct) {
        int idx = struct.lastIndexOf(47);
        if (idx == -1) {
            return struct;
        }
        return struct.substring(idx);
    }
}

