/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.ItemUtils;

public class DankNullItemHandler
implements IItemHandlerModifiable,
ICapabilitySerializable<NBTBase> {
    int maxSize = 0;
    ItemStack dankNull;
    TileDankNullDock dankDock;
    protected NonNullList<ItemStack> stacks;

    public DankNullItemHandler(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            this.dankNull = stack;
        }
        this.stacks = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
    }

    public void setTile(TileDankNullDock dock) {
        this.dankDock = dock;
    }

    public TileDankNullDock getTile() {
        return this.dankDock;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)((ItemStack)this.stacks.get(slot)), (ItemStack)stack)) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (!existing.func_190926_b() && !ItemUtils.areItemsEqual((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)))) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)stack);
            } else {
                existing.func_190920_e(stack.func_190916_E());
            }
            this.serializeNBT();
        }
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack ret = ItemStack.field_190927_a;
        if (this.getTile() != null) {
            if (ItemUtils.areItemsEqual((ItemStack)this.getStackInSlot(slot), (ItemStack)this.getTile().getSelectedStack())) {
                ret = this.doExtract(slot, amount, simulate);
            }
        } else {
            ret = this.doExtract(slot, amount, simulate);
        }
        return ret;
    }

    private ItemStack doExtract(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public NBTBase serializeNBT() {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74768_a("Slot", i);
            int size = ((ItemStack)this.stacks.get(i)).func_190916_E();
            int max = DankNullUtils.getDankNullMaxStackSize(this.dankNull);
            if (size > max) {
                ((ItemStack)this.stacks.get(i)).func_190920_e(max);
            }
            itemTag.func_74768_a("RealCount", ((ItemStack)this.stacks.get(i)).func_190916_E());
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.func_74742_a((NBTBase)itemTag);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(this.getName(), (NBTBase)nbtTagList);
        nbt.func_74768_a("Size", this.stacks.size());
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this, null);
    }

    public void deserializeNBT(NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.stacks.size());
            NBTTagList tagList = nbt.func_150295_c(this.getName(), 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTags = tagList.func_150305_b(i);
                int slot = itemTags.func_74762_e("Slot");
                if (slot < 0 || slot >= this.stacks.size()) continue;
                this.stacks.set(slot, (Object)new ItemStack(itemTags));
                ((ItemStack)this.stacks.get(slot)).func_190920_e(itemTags.func_74762_e("RealCount"));
            }
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this, null, (NBTBase)tagList);
            this.onLoad();
        }
    }

    private String getName() {
        return "danknull-inventory";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this) : null);
    }
}

