/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileTank
extends TileEntityTank {
    public int emitType;
    public int emitThreashold;
    public static int inputSlots = 2;
    public static int templateSlots = 5;
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TileTank.this.canFillFiltered(fluid) && TileTank.this.isValidSubstance(fluid);
        }

        public boolean canDrain() {
            return true;
        }

        public void onContentsChanged() {
            TileTank.this.updateNeighbours();
        }
    };
    public static int FILL_BUCKET = 0;
    public static int DRAIN_BUCKET = 1;
    public FluidStack filter = null;

    public TileTank() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == FILL_BUCKET && TileTank.this.canFillFiltered(FluidUtil.getFluidContained((ItemStack)insertingStack))) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                if (slot == DRAIN_BUCKET && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
        this.filter = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Filter"));
        this.emitThreashold = compound.func_74762_e("EmitThreashold");
        this.emitType = compound.func_74762_e("EmitType");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("EmitType", this.emitType);
        compound.func_74768_a("EmitThreashold", this.emitThreashold);
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        if (this.getFilter() != null) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filter.writeToNBT(filterNBT);
            compound.func_74782_a("Filter", (NBTBase)filterNBT);
        }
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack fillSlot() {
        return this.input.getStackInSlot(FILL_BUCKET);
    }

    public ItemStack drainSlot() {
        return this.input.getStackInSlot(DRAIN_BUCKET);
    }

    public int getGUIHeight() {
        return 200;
    }

    public void updateNeighbours() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
    }

    public int emittedPower() {
        int powerFraction = this.getTankCapacity() / 16;
        if (this.getEmitType() == 1) {
            return 15 * this.getTankAmount() / this.getTankCapacity();
        }
        if (this.getEmitType() == 2) {
            return this.getTankAmount() >= this.getTankCapacity() / 100 * this.getEmitThreashold() ? 15 : 0;
        }
        if (this.getEmitType() == 3) {
            return this.getTankAmount() < this.getTankCapacity() / 100 * this.getEmitThreashold() ? 15 : 0;
        }
        return 0;
    }

    public int getTankCapacity() {
        return 100000;
    }

    public boolean hasTankFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getTankFluid() {
        return this.hasTankFluid() ? this.inputTank.getFluid() : null;
    }

    public int getTankAmount() {
        return this.hasTankFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public FluidStack getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.getFilter() != null;
    }

    private boolean isMatchingFilter(FluidStack fluid) {
        return this.hasFilter() ? this.getFilter().isFluidEqual(fluid) : true;
    }

    public boolean canFillFiltered(FluidStack fluid) {
        return this.isMatchingFilter(fluid) && this.input.canSetOrFillFluid(this.inputTank, this.getTankFluid(), fluid);
    }

    public boolean canDrainFluid(FluidStack fluid) {
        return this.canDrainFiltered(fluid);
    }

    private boolean canDrainFiltered(FluidStack fluid) {
        return this.isMatchingFilter(fluid) && this.input.canDrainFluid(this.getTankFluid(), fluid);
    }

    public boolean isValidSubstance(FluidStack fluid) {
        return ModUtils.isLightFluid(fluid.getFluid());
    }

    public int getEmitType() {
        return this.emitType;
    }

    public int getEmitThreashold() {
        return this.emitThreashold;
    }

    public void func_73660_a() {
    }
}

