/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.utils.CoreBasics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;

public class TEWaterPump
extends TileEntityTank {
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.isFluidEqual(CoreBasics.waterStack((int)1000));
        }

        public boolean canDrain() {
            return true;
        }
    };
    public int tier;
    public boolean compressor;

    public TEWaterPump() {
        super(0, 0, 0, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tier = compound.func_74762_e("Tier");
        this.compressor = compound.func_74767_n("Compressor");
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Tier", this.getTier());
        compound.func_74757_a("Compressor", this.getCompressor());
        NBTTagCompound inputTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(inputTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)inputTankNBT);
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "water_pump";
    }

    public int getTankCapacity() {
        return 10000;
    }

    public FluidStack getTankFluid() {
        return this.inputTank.getFluid();
    }

    public int getTankAmount() {
        return this.inputTank.getFluidAmount();
    }

    public boolean hasTankFluid() {
        return this.inputTank.getFluid() != null;
    }

    public boolean getCompressor() {
        return this.compressor;
    }

    public int getTier() {
        return this.tier;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isPowered() && this.isValidWaterTile() && this.field_145850_b.field_73012_v.nextInt(this.compressorFactor()) == 0 && this.input.canSetOrAddFluid(this.inputTank, this.getTankFluid(), this.water(), this.tierFactor())) {
                this.input.setOrFillFluid(this.inputTank, this.water(), this.tierFactor());
                if (ModConfig.consumeWater && this.field_145850_b.field_73012_v.nextInt(ModConfig.consumeWaterChance) == 0) {
                    this.field_145850_b.func_175698_g(this.field_174879_c.func_177977_b());
                }
            }
            this.markDirtyClient();
        }
    }

    private boolean isValidWaterTile() {
        IBlockState waterstate = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Block waterblock = waterstate.func_177230_c();
        return waterblock == Blocks.field_150355_j && waterblock.func_176201_c(waterstate) == 0;
    }

    private FluidStack water() {
        return CoreBasics.waterStack((int)1000);
    }

    public int tierFactor() {
        if (this.getTier() == 0 && this.getCompressor()) {
            return 200;
        }
        if (this.getTier() == 1 && this.getCompressor()) {
            return 1000;
        }
        if (this.getTier() == 1 && !this.getCompressor()) {
            return 500;
        }
        if (this.getTier() == 2 && this.getCompressor()) {
            return 2000;
        }
        if (this.getTier() == 2 && !this.getCompressor()) {
            return 1000;
        }
        return 100;
    }

    private int compressorFactor() {
        return this.getCompressor() ? 1 : 16;
    }
}

