/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.recipe.TransposerRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.TransposerRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.ICollapse;
import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGaslinePump;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.gas.GasHandlerConcatenate;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTankVessel;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TETransposer
extends TileEntityTankVessel
implements IToxic,
ICollapse {
    public static final int SPEED_SLOT = 0;
    public static int templateSlots = 6;
    public static int upgradeSlots = 1;
    public FluidTank inputTankMain = new FluidTank(this.getFluidCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return TETransposer.this.canFillMainFiltered(fluid);
        }

        public boolean canDrain() {
            return false;
        }
    };
    public FluidTank outputTankFluid;
    public FluidTank outputTankGas;
    public FluidStack filterMain = null;
    public boolean isFluidActive;
    public boolean isGasActive;
    public int collapseRate = 0;

    public TETransposer() {
        super(0, 0, templateSlots, upgradeSlots);
        this.inputTankMain.setTileEntity((TileEntity)this);
        this.outputTankFluid = new FluidTank(this.getFluidCapacity()){

            public boolean canFillFluidType(FluidStack fluid) {
                return false;
            }

            public boolean canDrain() {
                return true;
            }
        };
        this.outputTankFluid.setTileEntity((TileEntity)this);
        this.outputTankGas = new FluidTank(this.getGasCapacity()){

            public boolean canFillFluidType(FluidStack gas) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack gas) {
                return true;
            }
        };
        this.outputTankGas.setTileEntity((TileEntity)this);
        this.upgrade = new MachineStackHandler(upgradeSlots, (TileEntityInv)this){

            public void validateSlotIndex(int slot) {
                if (TETransposer.this.upgrade.getSlots() < upgradeSlots) {
                    NonNullList stacksCloned = this.stacks;
                    TETransposer.this.upgrade.setSize(upgradeSlots);
                    for (ItemStack stack : stacksCloned) {
                        this.stacks.set(slot, (Object)stack);
                    }
                }
                super.validateSlotIndex(slot);
            }

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTankMain.readFromNBT(compound.func_74775_l("InputTankMain"));
        this.outputTankFluid.readFromNBT(compound.func_74775_l("OutputTankFluid"));
        this.outputTankGas.readFromNBT(compound.func_74775_l("OutputTankGas"));
        this.filterMain = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("FilterMain"));
        this.isFluidActive = compound.func_74767_n("EnableFluid");
        this.isGasActive = compound.func_74767_n("EnableGas");
        this.collapseRate = compound.func_74762_e("Collapse");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound inputTankMainNBT = new NBTTagCompound();
        this.inputTankMain.writeToNBT(inputTankMainNBT);
        compound.func_74782_a("InputTankMain", (NBTBase)inputTankMainNBT);
        NBTTagCompound outputTankFluidNBT = new NBTTagCompound();
        this.outputTankFluid.writeToNBT(outputTankFluidNBT);
        compound.func_74782_a("OutputTankFluid", (NBTBase)outputTankFluidNBT);
        NBTTagCompound outputTankGasNBT = new NBTTagCompound();
        this.outputTankGas.writeToNBT(outputTankGasNBT);
        compound.func_74782_a("OutputTankGas", (NBTBase)outputTankGasNBT);
        if (this.hasFilterMain()) {
            NBTTagCompound filterNBT = new NBTTagCompound();
            this.filterMain.writeToNBT(filterNBT);
            compound.func_74782_a("FilterMain", (NBTBase)filterNBT);
        }
        compound.func_74757_a("EnableFluid", this.isFluidActive);
        compound.func_74757_a("EnableGas", this.isGasActive);
        compound.func_74768_a("Collapse", this.getCollapse());
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTankMain, this.outputTankFluid, this.outputTankGas});
    }

    public GasHandlerConcatenate getCombinedGasTank() {
        return new GasHandlerConcatenate(new IFluidHandler[]{this.outputTankGas});
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "transposer";
    }

    public boolean isFluidActive() {
        return this.isFluidActive;
    }

    public boolean isGasActive() {
        return this.isGasActive;
    }

    public int getCollapse() {
        return this.collapseRate;
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTankMain);
        tanks.add(this.outputTankFluid);
        return tanks;
    }

    @Override
    public ArrayList<FluidTank> collapseList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTankMain);
        tanks.add(this.outputTankGas);
        return tanks;
    }

    public boolean isComparatorSensible() {
        return false;
    }

    public int getFluidCapacity() {
        return 5000;
    }

    public int getGasCapacity() {
        return 5000;
    }

    public boolean hasInputTankMain() {
        return this.inputTankMain.getFluid() != null;
    }

    public FluidStack getInputTankMain() {
        return this.hasInputTankMain() ? this.inputTankMain.getFluid() : null;
    }

    public int getInputTankMainAmount() {
        return this.hasInputTankMain() ? this.inputTankMain.getFluidAmount() : 0;
    }

    public FluidStack getFilterMain() {
        return this.filterMain;
    }

    public boolean hasFilterMain() {
        return this.getFilterMain() != null;
    }

    private boolean isMatchingFilterMain(FluidStack fluid) {
        return this.hasFilterMain() ? this.getFilterMain().isFluidEqual(fluid) : true;
    }

    public boolean canFillMainFiltered(FluidStack fluid) {
        return fluid != null && this.isMatchingFilterMain(fluid) && this.input.canSetOrFillFluid(this.inputTankMain, this.getInputTankMain(), fluid);
    }

    public boolean hasOutputTankFluid() {
        return this.outputTankFluid.getFluid() != null;
    }

    public FluidStack getOutputTankFluid() {
        return this.hasOutputTankFluid() ? this.outputTankFluid.getFluid() : null;
    }

    public int getOutputTankFluidAmount() {
        return this.hasOutputTankFluid() ? this.outputTankFluid.getFluidAmount() : 0;
    }

    public boolean hasOutputTankGas() {
        return this.outputTankGas.getFluid() != null;
    }

    public FluidStack getOutputTankGas() {
        return this.hasOutputTankGas() ? this.outputTankGas.getFluid() : null;
    }

    public int getOutputTankGasAmount() {
        return this.hasOutputTankGas() ? this.outputTankGas.getFluidAmount() : 0;
    }

    public boolean isValidPump(FluidStack gas) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tile != null && tile instanceof TEGaslinePump) {
            TEGaslinePump pump = (TEGaslinePump)tile;
            return pump.isActive() && gas != null && gas.getFluid().isGaseous();
        }
        return false;
    }

    public static ArrayList<TransposerRecipe> recipeList() {
        return TransposerRecipes.transposer_recipes;
    }

    public static TransposerRecipe getRecipeList(int x) {
        return TETransposer.recipeList().get(x);
    }

    public TransposerRecipe getCurrentFluidRecipe() {
        for (int x = 0; x < TETransposer.recipeList().size(); ++x) {
            if (!this.isMatchingFluidInput(x)) continue;
            return TETransposer.getRecipeList(x);
        }
        return null;
    }

    public TransposerRecipe getCurrentGasRecipe() {
        for (int x = 0; x < TETransposer.recipeList().size(); ++x) {
            if (!this.isMatchingGasInput(x)) continue;
            return TETransposer.getRecipeList(x);
        }
        return null;
    }

    private boolean isMatchingFluidInput(int x) {
        Fluid inputfluid;
        FluidStack inputstack = TETransposer.getRecipeList(x).getInput();
        return inputstack != null && (inputfluid = inputstack.getFluid()) != null && !inputfluid.isGaseous() && this.hasInputTankMain() && this.getInputTankMain() != null && TETransposer.getRecipeList(x).getInput().isFluidEqual(this.getInputTankMain());
    }

    private boolean isMatchingGasInput(int x) {
        Fluid inputfluid;
        FluidStack inputstack = TETransposer.getRecipeList(x).getInput();
        return inputstack != null && (inputfluid = inputstack.getFluid()) != null && inputfluid.isGaseous() && this.hasInputTankMain() && this.getInputTankMain() != null && TETransposer.getRecipeList(x).getInput().isFluidEqual(this.getInputTankMain());
    }

    public boolean isValidFluidRecipe() {
        return this.getCurrentFluidRecipe() != null;
    }

    public boolean isValidGasRecipe() {
        return this.getCurrentGasRecipe() != null;
    }

    public FluidStack recipeFluidInput() {
        return this.isValidFluidRecipe() ? this.getCurrentFluidRecipe().getInput() : null;
    }

    public FluidStack recipeFluidOutput() {
        return this.isValidFluidRecipe() ? this.getCurrentFluidRecipe().getOutput() : null;
    }

    public FluidStack recipeGasInput() {
        return this.isValidGasRecipe() ? this.getCurrentGasRecipe().getInput() : null;
    }

    public FluidStack recipeGasOutput() {
        return this.isValidGasRecipe() ? this.getCurrentGasRecipe().getOutput() : null;
    }

    public int transposeRate() {
        return 125 * this.speedFactor();
    }

    public TileVessel getInTank() {
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            this.checkCollapse();
            if (this.hasInTank() && this.getInTank().inputTank.getFluidAmount() > 0 && this.canPushGas(this.getInTank())) {
                this.pushGas(this.getInTank());
            }
            if (this.canProcessFluid()) {
                this.processFluid();
            }
            if (this.canProcessGas()) {
                this.processGas();
            }
            this.markDirtyClient();
        }
    }

    private boolean canPushGas(TileVessel vess) {
        int fluidCan = this.inputTankMain.getCapacity() - this.inputTankMain.getFluidAmount();
        int fluidHas = this.getInTank().inputTank.getFluidAmount() >= fluidCan ? fluidCan : this.getInTank().inputTank.getFluidAmount();
        return this.input.canSetOrAddFluid(this.inputTankMain, this.getInputTankMain(), this.getInTank().getTankFluid(), fluidHas);
    }

    private void pushGas(TileVessel vess) {
        if (this.getInTank().getTankFluid() != null) {
            int fluidCan = this.inputTankMain.getCapacity() - this.inputTankMain.getFluidAmount();
            int fluidHas = this.getInTank().inputTank.getFluidAmount() >= fluidCan ? fluidCan : this.getInTank().inputTank.getFluidAmount();
            this.input.setOrFillFluid(this.inputTankMain, this.getInTank().getTankFluid(), fluidHas);
            this.input.drainOrCleanFluid(this.getInTank().inputTank, fluidHas, true);
        }
    }

    private boolean canProcessFluid() {
        int fluidCan = this.outputTankFluid.getCapacity() - this.getOutputTankFluidAmount();
        int fluidHas = this.getInputTankMainAmount() >= this.transposeRate() ? this.transposeRate() : this.getInputTankMainAmount();
        int fluidWant = fluidHas >= fluidCan ? fluidCan : fluidHas;
        return this.isFluidActive() && this.inputTankMain.getFluid() != null && this.isValidFluidRecipe() && fluidCan > 0 && this.input.canDrainFluid(this.getInputTankMain(), this.recipeFluidInput(), this.transposeRate()) && this.output.canSetOrAddFluid(this.outputTankFluid, this.getOutputTankFluid(), this.recipeFluidOutput(), this.transposeRate());
    }

    private void processFluid() {
        int fluidCan = this.outputTankFluid.getCapacity() - this.getOutputTankFluidAmount();
        int fluidHas = this.getInputTankMainAmount() >= this.transposeRate() ? this.transposeRate() : this.getInputTankMainAmount();
        int fluidWant = fluidHas >= fluidCan ? fluidCan : fluidHas;
        this.output.setOrFillFluid(this.outputTankFluid, this.recipeFluidOutput(), fluidWant);
        this.input.drainOrCleanFluid(this.inputTankMain, fluidWant, true);
    }

    private boolean canProcessGas() {
        int fluidCan = this.outputTankGas.getCapacity() - this.getOutputTankGasAmount();
        int fluidHas = this.getInputTankMainAmount() >= this.transposeRate() ? this.transposeRate() : this.getInputTankMainAmount();
        int fluidWant = fluidHas >= fluidCan ? fluidCan : fluidHas;
        return this.isGasActive() && this.isValidGasRecipe() && fluidCan > 0 && this.input.canDrainFluid(this.getInputTankMain(), this.recipeGasInput(), fluidWant) && this.output.canSetOrAddFluid(this.outputTankGas, this.getOutputTankGas(), this.recipeGasOutput(), fluidWant);
    }

    private void processGas() {
        int fluidCan = this.outputTankGas.getCapacity() - this.getOutputTankGasAmount();
        int fluidHas = this.getInputTankMainAmount() >= this.transposeRate() ? this.transposeRate() : this.getInputTankMainAmount();
        int fluidWant = fluidHas >= fluidCan ? fluidCan : fluidHas;
        this.output.setOrFillFluid(this.outputTankGas, this.recipeGasOutput(), fluidWant);
        this.input.drainOrCleanFluid(this.inputTankMain, fluidWant, true);
    }

    public void checkCollapse() {
        if (ModConfig.enableHazard && this.field_145850_b.field_73012_v.nextInt(ModConfig.hazardChance) == 0) {
            if (this.handleCollapse(this.getCollapse(), this.field_145850_b, this.field_174879_c)) {
                ++this.collapseRate;
                if (this.getCollapse() >= ModConfig.pressureTolerance) {
                    if (this.hasExhaust(this.field_145850_b, this.field_174879_c, 1)) {
                        this.doExhaustion(this.field_145850_b, this.field_174879_c, 1);
                        this.collapseRate /= 2;
                    } else {
                        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 2.0f, true);
                    }
                }
            } else if (this.handleRelease(this.getCollapse(), this.field_145850_b, this.field_174879_c) && this.getCollapse() > 0) {
                --this.collapseRate;
            }
        }
    }
}

