/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.machines.tile.IToxic;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityTank;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerConcatenate;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TEStirredTankOut
extends TileEntityTank
implements IToxic {
    public static int inputSlots = 1;
    public static int templateSlots = 1;
    public FluidTank inputTank = new FluidTank(this.getTankCapacity()){

        public boolean canFillFluidType(FluidStack fluid) {
            return false;
        }

        public boolean canDrain() {
            return true;
        }
    };
    public static int DRAIN_SLOT = 0;

    public TEStirredTankOut() {
        super(inputSlots, 0, templateSlots, 0);
        this.inputTank.setTileEntity((TileEntity)this);
        this.input = new MachineStackHandler(inputSlots, (TileEntityInv)this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == DRAIN_SLOT && CoreUtils.isEmptyBucket((ItemStack)insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputTank.readFromNBT(compound.func_74775_l("InputTank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound solutionTankNBT = new NBTTagCompound();
        this.inputTank.writeToNBT(solutionTankNBT);
        compound.func_74782_a("InputTank", (NBTBase)solutionTankNBT);
        return compound;
    }

    public FluidHandlerConcatenate getCombinedTank() {
        return new FluidHandlerConcatenate(new IFluidHandler[]{this.inputTank});
    }

    public ItemStack drainSlot() {
        return this.input.getStackInSlot(DRAIN_SLOT);
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "stirred_tank_out";
    }

    @Override
    public ArrayList<FluidTank> hazardList() {
        ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
        tanks.add(this.inputTank);
        return tanks;
    }

    public int getTankCapacity() {
        return 20000;
    }

    public boolean hasTankFluid() {
        return this.inputTank.getFluid() != null;
    }

    public FluidStack getTankFluid() {
        return this.hasTankFluid() ? this.inputTank.getFluid() : null;
    }

    public int getTankAmount() {
        return this.hasTankFluid() ? this.inputTank.getFluidAmount() : 0;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.fillContainer(DRAIN_SLOT, this.inputTank);
            this.handleToxic(this.field_145850_b, this.field_174879_c);
            this.markDirtyClient();
        }
    }
}

