/*
 * Decompiled with CFR 0.152.
 */
package com.globbypotato.rockhounding_chemistry.machines.tile;

import com.globbypotato.rockhounding_chemistry.enums.EnumFluid;
import com.globbypotato.rockhounding_chemistry.enums.EnumMiscBlocksA;
import com.globbypotato.rockhounding_chemistry.handlers.ModConfig;
import com.globbypotato.rockhounding_chemistry.machines.io.MachineIO;
import com.globbypotato.rockhounding_chemistry.machines.recipe.PullingCrucibleRecipes;
import com.globbypotato.rockhounding_chemistry.machines.recipe.construction.PullingCrucibleRecipe;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEGasPressurizer;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPowerGenerator;
import com.globbypotato.rockhounding_chemistry.machines.tile.TEPullingCrucibleTop;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileStructure;
import com.globbypotato.rockhounding_chemistry.machines.tile.TileVessel;
import com.globbypotato.rockhounding_chemistry.utils.ModUtils;
import com.globbypotato.rockhounding_core.machines.tileentity.MachineStackHandler;
import com.globbypotato.rockhounding_core.machines.tileentity.TileEntityInv;
import com.globbypotato.rockhounding_core.machines.tileentity.WrappedItemHandler;
import com.globbypotato.rockhounding_core.utils.CoreUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class TEPullingCrucibleBase
extends TileEntityInv {
    public static int inputSlots = 1;
    public static int outputSlots = 1;
    public static int templateSlots = 1;
    public static int upgradeSlots = 1;
    public int meltcount;
    public static final int SPEED_SLOT = 0;
    public PullingCrucibleRecipe dummyRecipe;

    public TEPullingCrucibleBase() {
        super(inputSlots, outputSlots, templateSlots, upgradeSlots);
        this.input = new MachineStackHandler(inputSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && TEPullingCrucibleBase.isValidInput(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.input, WrappedItemHandler.WriteMode.IN);
        this.upgrade = new MachineStackHandler(upgradeSlots, this){

            public ItemStack insertItem(int slot, ItemStack insertingStack, boolean simulate) {
                if (slot == 0 && ModUtils.isValidSpeedUpgrade(insertingStack)) {
                    return super.insertItem(slot, insertingStack, simulate);
                }
                return insertingStack;
            }
        };
        this.automationUpgrade = new WrappedItemHandler((IItemHandlerModifiable)this.upgrade, WrappedItemHandler.WriteMode.IN);
    }

    public ItemStack inputSlot() {
        return this.input.getStackInSlot(0);
    }

    public ItemStack outputSlot() {
        return this.output.getStackInSlot(0);
    }

    public ItemStack speedSlot() {
        return this.upgrade.getStackInSlot(0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.meltcount = compound.func_74762_e("Melting");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Melting", this.getMelting());
        return compound;
    }

    public int getGUIHeight() {
        return 200;
    }

    public static String getName() {
        return "pulling_crucible_base";
    }

    public int speedFactor() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModUtils.speedUpgrade(this.speedSlot()) : 1;
    }

    public int getCooktimeMax() {
        return ModUtils.isValidSpeedUpgrade(this.speedSlot()) ? ModConfig.speedPulling / ModUtils.speedUpgrade(this.speedSlot()) : ModConfig.speedPulling;
    }

    public EnumFacing poweredFacing() {
        return this.getFacing().func_176734_d();
    }

    public static ArrayList<PullingCrucibleRecipe> recipeList() {
        return PullingCrucibleRecipes.pulling_crucible_recipes;
    }

    public static PullingCrucibleRecipe getRecipeList(int x) {
        return TEPullingCrucibleBase.recipeList().get(x);
    }

    public static boolean isValidInput(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (PullingCrucibleRecipe recipe : TEPullingCrucibleBase.recipeList()) {
                ArrayList inputOreIDs;
                if (!(recipe.getType1() ? !(inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)stack))).isEmpty() && inputOreIDs.contains(OreDictionary.getOreID((String)recipe.getOredict1())) : recipe.getInput().func_77969_a(stack))) continue;
                return true;
            }
        }
        return false;
    }

    public PullingCrucibleRecipe getCurrentRecipe() {
        if (!this.inputSlot().func_190926_b() && this.hasDopant() && !this.getDopant().inputSlot().func_190926_b()) {
            for (int x = 0; x < TEPullingCrucibleBase.recipeList().size(); ++x) {
                if (!this.hasInputIngredient(x) || !this.hasDopantIngredient(x)) continue;
                return TEPullingCrucibleBase.getRecipeList(x);
            }
        }
        return null;
    }

    private boolean hasInputIngredient(int x) {
        ArrayList inputOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.inputSlot()));
        return TEPullingCrucibleBase.getRecipeList(x).getType1() ? inputOreIDs.contains(OreDictionary.getOreID((String)TEPullingCrucibleBase.getRecipeList(x).getOredict1())) : TEPullingCrucibleBase.getRecipeList(x).getInput().func_77969_a(this.inputSlot());
    }

    private boolean hasDopantIngredient(int x) {
        ArrayList dopantOreIDs = CoreUtils.intArrayToList((int[])OreDictionary.getOreIDs((ItemStack)this.getDopant().inputSlot()));
        return TEPullingCrucibleBase.getRecipeList(x).getType2() ? dopantOreIDs.contains(OreDictionary.getOreID((String)TEPullingCrucibleBase.getRecipeList(x).getOredict2())) : TEPullingCrucibleBase.getRecipeList(x).getDopant().func_77969_a(this.getDopant().inputSlot());
    }

    public PullingCrucibleRecipe getDummyRecipe() {
        return this.dummyRecipe;
    }

    public boolean isValidRecipe() {
        return this.getDummyRecipe() != null;
    }

    public ItemStack input() {
        return this.isValidRecipe() ? this.getDummyRecipe().getInput() : ItemStack.field_190927_a;
    }

    public ItemStack dopant() {
        return this.isValidRecipe() ? this.getDummyRecipe().getDopant() : ItemStack.field_190927_a;
    }

    public ItemStack output() {
        return this.isValidRecipe() ? this.getDummyRecipe().getOutput() : ItemStack.field_190927_a;
    }

    private void doPreset() {
        if (this.hasEngine()) {
            if (this.getEngine().enablePower) {
                this.getEngine().enablePower = false;
                this.getEngine().markDirtyClient();
            }
            if (!this.getEngine().enableRedstone) {
                this.getEngine().enableRedstone = true;
                this.getEngine().markDirtyClient();
            }
        }
        if (this.hasInTank() && this.getInTank().getFilter() != TEPullingCrucibleBase.argon()) {
            this.getInTank().filter = TEPullingCrucibleBase.argon();
        }
    }

    public int powerConsume() {
        int baseConsume = 10 * ModConfig.basePower;
        return ModConfig.speedMultiplier ? baseConsume * this.speedFactor() : baseConsume;
    }

    public int getMelting() {
        return this.meltcount;
    }

    public int getMeltingMax() {
        return 2500;
    }

    public int getMeltingLev() {
        return 2000;
    }

    public int consumedArgon() {
        return 100;
    }

    public TEPowerGenerator getEngine() {
        TEPowerGenerator engine = TileStructure.getEngine(this.field_145850_b, this.field_174879_c, this.getFacing(), 1, 0);
        return engine != null ? engine : null;
    }

    public boolean hasEngine() {
        return this.getEngine() != null;
    }

    public boolean hasRedstonePower() {
        return this.hasEngine() ? this.getEngine().getRedstone() >= this.powerConsume() : false;
    }

    private void drainPower() {
        this.getEngine().redstoneCount -= this.powerConsume();
        this.getEngine().markDirtyClient();
    }

    public TileVessel getInTank() {
        BlockPos vesselpos = this.field_174879_c.func_177972_a(EnumFacing.UP);
        TileVessel vessel = TileStructure.getHolder(this.field_145850_b, vesselpos, this.isFacingAt(90), 1, 180);
        return vessel != null ? vessel : null;
    }

    public boolean hasInTank() {
        return this.getInTank() != null;
    }

    public boolean hasCap() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177981_b(2));
        Block block = state.func_177230_c();
        return MachineIO.miscBlocksA(block, state, EnumMiscBlocksA.PULLING_CRUCIBLE_CAP.ordinal());
    }

    public TEGasPressurizer getPressurizer() {
        BlockPos pPos = this.field_174879_c.func_177972_a(EnumFacing.UP);
        TEGasPressurizer pressurizer = TileStructure.getPressurizer(this.field_145850_b, pPos, this.getFacing(), 1, 0);
        return pressurizer != null ? pressurizer : null;
    }

    public boolean hasPressurizer() {
        return this.getPressurizer() != null;
    }

    public TEPullingCrucibleTop getDopant() {
        TEPullingCrucibleTop injector;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()) != null && te instanceof TEPullingCrucibleTop && (injector = (TEPullingCrucibleTop)te).getFacing() == this.getFacing()) {
            return injector;
        }
        return null;
    }

    public boolean hasDopant() {
        return this.getDopant() != null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.doPreset();
            if (this.getDummyRecipe() == null) {
                this.dummyRecipe = this.getCurrentRecipe();
                this.cooktime = 0;
            }
            if (this.canMelt()) {
                this.meltcount += this.powerConsume();
                this.drainPower();
                this.markDirtyClient();
            }
            if (this.getMelting() >= 100 && this.rand.nextInt(32) == 0) {
                this.meltcount -= 100;
                this.markDirtyClient();
            }
            if (this.canProcess()) {
                ++this.cooktime;
                this.drainPower();
                if (this.getCooktime() >= this.getCooktimeMax()) {
                    this.cooktime = 0;
                    this.process();
                }
                this.markDirtyClient();
            } else {
                this.tickOff();
            }
        }
    }

    private boolean canMelt() {
        return this.isActive() && this.isValidRecipe() && this.hasRedstonePower() && this.getMelting() <= this.getMeltingMax() - this.powerConsume() && this.canOutput();
    }

    private boolean canProcess() {
        return this.isActive() && this.isValidRecipe() && this.hasPressurizer() && this.hasCap() && this.hasArgon() && this.getMelting() >= this.getMeltingLev() && this.canOutput();
    }

    private boolean canOutput() {
        return this.output.canSetOrStack(this.outputSlot(), this.getDummyRecipe().getOutput());
    }

    private boolean hasArgon() {
        return this.hasInTank() ? this.input.canDrainFluid(this.getInTank().inputTank.getFluid(), TEPullingCrucibleBase.argon(), this.consumedArgon()) : false;
    }

    private static FluidStack argon() {
        return new FluidStack(EnumFluid.pickFluid(EnumFluid.ARGON), 1000);
    }

    private void process() {
        if (this.getDummyRecipe() != null && this.getDummyRecipe() == this.getCurrentRecipe()) {
            this.output.setOrStack(0, this.output());
            if (this.hasInTank()) {
                this.input.drainOrCleanFluid(this.getInTank().inputTank, this.consumedArgon(), true);
            }
            if (this.hasDopant()) {
                ((MachineStackHandler)this.getDopant().getInput()).decrementSlot(0);
            }
            this.meltcount /= 6;
            this.input.decrementSlot(0);
        }
        this.dummyRecipe = null;
    }
}

